/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.intellij.icons.AllIcons;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

class CpuProfilerContextMenuInstaller {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final ContextMenuInstaller myInstaller;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final JComponent myContainerComponent;
    @NotNull
    private final IdeProfilerComponents myIdeComponents;

    private CpuProfilerContextMenuInstaller(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideComponents, @NotNull JComponent component, @NotNull JComponent containerComponent) {
        this.myInstaller = ideComponents.createContextMenuInstaller();
        this.myIdeComponents = ideComponents;
        this.myStage = stage;
        this.myComponent = component;
        this.myContainerComponent = containerComponent;
    }

    private void install() {
        this.installRecordMenuItem();
        this.installExportTraceMenuItem();
    }

    private void installExportTraceMenuItem() {
        DefaultContextMenuItem exportTrace = new DefaultContextMenuItem.Builder("Export trace...").setIcon(AllIcons.ToolbarDecorator.Export).setContainerComponent(this.myContainerComponent).build();
        this.myInstaller.installGenericContextMenu(this.myComponent, (ContextMenuItem)exportTrace, x -> exportTrace.isEnabled() && this.getTraceIntersectingWithMouseX(x) != null, x -> this.myIdeComponents.createExportDialog().open(() -> "Export trace as", () -> CpuProfiler.generateCaptureFileName(this.getTraceIntersectingWithMouseX(x).getTraceType()), () -> "trace", file -> this.myStage.getStudioProfilers().getIdeServices().saveFile((File)file, output -> CpuProfiler.saveCaptureToFile(this.myStage.getStudioProfilers(), this.getTraceIntersectingWithMouseX(x).getTraceInfo(), output), null)));
        this.myInstaller.installGenericContextMenu(this.myComponent, ContextMenuItem.SEPARATOR);
    }

    private void installRecordMenuItem() {
        DefaultContextMenuItem record = new DefaultContextMenuItem.Builder(() -> this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING ? "Stop recording" : "Record CPU trace").setContainerComponent(this.myContainerComponent).setEnableBooleanSupplier(() -> this.shouldEnableCaptureButton() && (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.IDLE)).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())}).setActionRunnable(this.myStage::toggleCapturing).build();
        this.myInstaller.installGenericContextMenu(this.myComponent, (ContextMenuItem)record);
        this.myInstaller.installGenericContextMenu(this.myComponent, ContextMenuItem.SEPARATOR);
    }

    private boolean shouldEnableCaptureButton() {
        return this.myStage.getStudioProfilers().getSessionsManager().isSessionAlive() && !this.myStage.isApiInitiatedTracingInProgress();
    }

    private CpuTraceInfo getTraceIntersectingWithMouseX(int mouseXLocation) {
        Range range = this.myStage.getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.myComponent.getSize().getWidth() * range.getLength() + range.getMin();
        return this.myStage.getIntersectingTraceInfo(new Range(pos, pos));
    }

    public static void install(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideComponents, @NotNull JComponent component, @NotNull JComponent containerComponent) {
        CpuProfilerContextMenuInstaller menus = new CpuProfilerContextMenuInstaller(stage, ideComponents, component, containerComponent);
        menus.install();
    }
}

