/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.config.ImportedConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AtraceExporter;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfiler
implements StudioProfiler {
    @NotNull
    private final StudioProfilers profilers;

    public CpuProfiler(@NotNull StudioProfilers profilers) {
        this.profilers = profilers;
        this.registerImportedSessionListener();
        this.registerTraceImportHandler();
    }

    private void onImportSessionSelected() {
        this.profilers.getIdeServices().runAsync(() -> CpuCaptureStage.create(this.profilers, new ImportedConfiguration(), this.profilers.getSession().getStartTimestamp()), captureStage -> {
            if (captureStage != null) {
                this.profilers.getIdeServices().getMainExecutor().execute(() -> this.profilers.setStage((Stage)((Object)captureStage)));
            } else {
                this.profilers.getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfiler.class);
    }

    private void registerImportedSessionListener() {
        this.profilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.CPU_CAPTURE, this::onImportSessionSelected);
    }

    private void registerTraceImportHandler() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        sessionsManager.registerImportHandler("trace", this::loadCapture);
        sessionsManager.registerImportHandler("pftrace", this::loadCapture);
        sessionsManager.registerImportHandler("perfetto-trace", this::loadCapture);
    }

    private void loadCapture(File file) {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        long startTimestampNs = (Long)timestampsNs.first;
        if (sessionsManager.setSessionById(startTimestampNs)) {
            return;
        }
        long endTimestampNs = (Long)timestampsNs.second;
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            Map<String, ByteString> byteCacheMap = Collections.singletonMap(String.valueOf(startTimestampNs), ByteString.copyFrom((byte[])fileBytes));
            sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.CPU_CAPTURE, startTimestampNs, endTimestampNs, startTimestampEpochMs, byteCacheMap, new Common.Event[0]);
        }
        catch (IOException ex) {
            CpuProfiler.getLogger().warn("Importing Session Failed: cannot read from " + file.getPath());
            return;
        }
        this.profilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.CPU_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    @Override
    @NotNull
    public ProfilerMonitor newMonitor() {
        return new CpuMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Cpu.CpuTraceInfo mostRecentTrace;
        List<Cpu.CpuTraceInfo> traces = CpuProfiler.getTraceInfoFromSession(this.profilers.getClient(), session);
        Cpu.CpuTraceInfo cpuTraceInfo = mostRecentTrace = traces.isEmpty() ? null : traces.get(traces.size() - 1);
        if (mostRecentTrace != null && mostRecentTrace.getToTimestamp() == -1L) {
            CpuProfiler.stopTracing(this.profilers, session, mostRecentTrace.getConfiguration(), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void saveCaptureToFile(@NotNull StudioProfilers profilers, @NotNull Cpu.CpuTraceInfo info, @NotNull OutputStream outputStream) {
        try {
            Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(info.getTraceId())).build();
            Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) == ProfilingConfiguration.TraceType.ATRACE) {
                File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", info.getTraceId()), (String)".trace", (boolean)true);
                try (FileOutputStream out = new FileOutputStream(trace);){
                    out.write(traceResponse.getContents().toByteArray());
                }
                AtraceExporter.export(trace, outputStream);
                return;
            }
            FileUtil.copy((InputStream)new ByteArrayInputStream(traceResponse.getContents().toByteArray()), (OutputStream)outputStream);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) != ProfilingConfiguration.TraceType.PERFETTO) return;
        }
        catch (IOException exception) {
            CpuProfiler.getLogger().warn("Failed to export CPU trace file:\n" + exception);
        }
    }

    @NotNull
    static String generateCaptureFileName(@NotNull ProfilingConfiguration.TraceType profilerType) {
        StringBuilder traceName = new StringBuilder(String.format("cpu-%s-", StringUtil.toLowerCase((String)profilerType.name())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        traceName.append(LocalDateTime.now().format(formatter));
        return traceName.toString();
    }

    @NotNull
    public static List<Cpu.CpuTraceInfo> getTraceInfoFromRange(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        long rangeMinNs = rangeUs.getMin() == -9.223372036854776E18 ? Long.MIN_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = rangeUs.getMax() == 9.223372036854776E18 ? Long.MAX_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.CPU_TRACE).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        return response.getGroupsList().stream().map(group -> {
            Cpu.CpuTraceInfo info;
            Common.Event event = group.getEvents(group.getEventsCount() - 1);
            Cpu.CpuTraceInfo cpuTraceInfo = info = event.getCpuTrace().hasTraceStarted() ? event.getCpuTrace().getTraceStarted().getTraceInfo() : event.getCpuTrace().getTraceEnded().getTraceInfo();
            if (info.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance())) {
                assert (group.getEventsCount() > 1);
                info = group.getEvents(0).getCpuTrace().getTraceStarted().getTraceInfo();
                if (info.getToTimestamp() == -1L) {
                    info = info.toBuilder().setToTimestamp(session.getEndTimestamp()).setStopStatus(Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.APP_PROCESS_DIED)).build();
                }
            }
            return info;
        }).sorted(Comparator.comparingLong(Cpu.CpuTraceInfo::getFromTimestamp)).collect(Collectors.toList());
    }

    @NotNull
    public static Cpu.CpuTraceInfo getTraceInfoFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.CPU_TRACE).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            return Cpu.CpuTraceInfo.getDefaultInstance();
        }
        Cpu.CpuTraceData data = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1).getCpuTrace();
        if (data.hasTraceStarted()) {
            return data.getTraceStarted().getTraceInfo();
        }
        return data.getTraceEnded().getTraceInfo();
    }

    @NotNull
    public static List<Cpu.CpuTraceInfo> getTraceInfoFromSession(@NotNull ProfilerClient client, @NotNull Common.Session session) {
        return CpuProfiler.getTraceInfoFromRange(client, session, new Range(-9.223372036854776E18, 9.223372036854776E18));
    }

    @NotNull
    public static Common.Event getTraceStatusEventFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.TRACE_STATUS).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            return Common.Event.getDefaultInstance();
        }
        return response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1);
    }

    public static void stopTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceConfiguration configuration, @Nullable Consumer<Trace.TraceStopStatus> responseHandler) {
        Commands.Command stopCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.STOP_CPU_TRACE).setStopCpuTrace(Cpu.StopCpuTrace.newBuilder().setConfiguration(configuration).setNeedTraceResponse(responseHandler != null)).build();
        Transport.ExecuteResponse response = profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(stopCommand).build());
        if (responseHandler != null) {
            TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.TRACE_STATUS, profilers.getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> session.getStreamId(), () -> session.getPid(), event -> {
                responseHandler.accept(event.getTraceStatus().getTraceStopStatus());
                return true;
            });
            profilers.getTransportPoller().registerListener(statusListener2);
        }
    }
}

