/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.util.SwingUtil;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.jetbrains.annotations.NotNull;

public abstract class CpuCellRenderer<T, K>
implements ListCellRenderer<T> {
    protected final JLabel myLabel = new JLabel();
    protected int myHoveredIndex = -1;
    protected final Map<Integer, StateChartData<K>> myStateCharts;

    public CpuCellRenderer(final JList<T> list) {
        this.myLabel.setFont(ProfilerFonts.STANDARD_FONT);
        MatteBorder rightSeparator = BorderFactory.createMatteBorder(0, 0, 0, 1, ProfilerColors.THREAD_LABEL_BORDER);
        JBEmptyBorder marginLeft = JBUI.Borders.emptyLeft((int)10);
        this.myLabel.setBorder(new CompoundBorder(rightSeparator, (Border)marginLeft));
        this.myLabel.setOpaque(true);
        this.myStateCharts = new HashMap<Integer, StateChartData<K>>();
        list.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                StateChart chart2;
                Point p = new Point(e.getX(), e.getY());
                int oldHoveredIndex = CpuCellRenderer.this.myHoveredIndex;
                CpuCellRenderer.this.myHoveredIndex = list.locationToIndex(p);
                if (oldHoveredIndex != CpuCellRenderer.this.myHoveredIndex && list.getModel().getSize() > oldHoveredIndex && oldHoveredIndex >= 0) {
                    list.repaint(list.getCellBounds(oldHoveredIndex, oldHoveredIndex));
                    chart2 = CpuCellRenderer.this.getChartForModel(list.getModel().getElementAt(oldHoveredIndex));
                    chart2.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventID((MouseEvent)e, (int)505));
                }
                if (CpuCellRenderer.this.myHoveredIndex >= 0) {
                    if (CpuCellRenderer.this.myHoveredIndex != oldHoveredIndex) {
                        list.repaint(list.getCellBounds(CpuCellRenderer.this.myHoveredIndex, CpuCellRenderer.this.myHoveredIndex));
                    }
                    chart2 = CpuCellRenderer.this.getChartForModel(list.getModel().getElementAt(CpuCellRenderer.this.myHoveredIndex));
                    chart2.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventID((MouseEvent)e, (int)503));
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (list.getModel().getSize() > CpuCellRenderer.this.myHoveredIndex && CpuCellRenderer.this.myHoveredIndex >= 0) {
                    StateChart chart2 = CpuCellRenderer.this.getChartForModel(list.getModel().getElementAt(CpuCellRenderer.this.myHoveredIndex));
                    chart2.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventID((MouseEvent)e, (int)505));
                }
                CpuCellRenderer.this.myHoveredIndex = -1;
            }
        });
    }

    @NotNull
    abstract StateChart<K> getChartForModel(@NotNull T var1);

    protected static class StateChartData<T> {
        private final StateChart<T> myChart;
        private final StateChartModel<T> myModel;

        public StateChartData(StateChart<T> chart2, StateChartModel<T> model) {
            this.myChart = chart2;
            this.myModel = model;
        }

        public StateChart<T> getChart() {
            return this.myChart;
        }

        public StateChartModel<T> getModel() {
            return this.myModel;
        }
    }
}

