/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CpuCapture
extends ConfigurableDurationData {
    public long getTraceId();

    @NotNull
    public ProfilingConfiguration.TraceType getType();

    @NotNull
    public Timeline getTimeline();

    @NotNull
    default public Range getRange() {
        return this.getTimeline().getDataRange();
    }

    public boolean isDualClock();

    @Nullable
    public String getDualClockDisabledMessage();

    public void updateClockType(@NotNull ClockType var1);

    public int getMainThreadId();

    @NotNull
    public Set<CpuThreadInfo> getThreads();

    public boolean containsThread(int var1);

    @Nullable
    public CaptureNode getCaptureNode(int var1);

    @NotNull
    public Collection<CaptureNode> getCaptureNodes();

    @Nullable
    default public CpuSystemTraceData getSystemTraceData() {
        return null;
    }

    default public long getDurationUs() {
        return (long)this.getRange().getLength();
    }

    default public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    default public boolean canSelectPartialRange() {
        return true;
    }

    public void collapseNodesWithTags(@NotNull Set<String> var1);

    @NotNull
    public Set<String> getCollapsedTags();

    @NotNull
    public Set<String> getTags();
}

