/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CaptureNodeKt;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002efB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u00109\u001a\u00020\u00002\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00030;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002000;J\"\u00109\u001a\u00020\u00002\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002000;2\u0006\u0010>\u001a\u00020\u0003J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0000H\u0016J\u0014\u0010B\u001a\u00020@2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00000DJ\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020@J\u0010\u0010J\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010K\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0006\u0010L\u001a\u00020\u0000J?\u0010M\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HN0;2\u0018\u0010P\u001a\u0014\u0012\u0004\u0012\u0002HN\u0012\u0004\u0012\u0002HN\u0012\u0004\u0012\u0002HN0Q\u00a2\u0006\u0002\u0010RJ\u0010\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u001bH\u0016J\b\u0010U\u001a\u00020\u001bH\u0016J\b\u0010V\u001a\u00020\u001bH\u0016J\b\u0010W\u001a\u00020!H\u0016J\n\u0010X\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010Y\u001a\u00020!H\u0016J:\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f2\u0006\u0010[\u001a\u00020\u001b2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000\\2\u0016\u0010]\u001a\u0012\u0012\u0004\u0012\u00020\u00000^j\b\u0012\u0004\u0012\u00020\u0000`_J\u0010\u0010`\u001a\u00020@2\u0006\u0010a\u001a\u00020\u001bH\u0002J\u000e\u0010b\u001a\u00020@2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010c\u001a\u00020dR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00138\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0010\u00102\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010#\"\u0004\b5\u0010%R\u001a\u00106\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010#\"\u0004\b8\u0010%\u00a8\u0006g"}, d2={"Lcom/android/tools/profilers/cpu/CaptureNode;", "Lcom/android/tools/adtui/model/HNode;", "data", "Lcom/android/tools/profilers/cpu/nodemodel/CaptureNodeModel;", "(Lcom/android/tools/profilers/cpu/nodemodel/CaptureNodeModel;)V", "clockType", "Lcom/android/tools/perflib/vmtrace/ClockType;", "(Lcom/android/tools/profilers/cpu/nodemodel/CaptureNodeModel;Lcom/android/tools/perflib/vmtrace/ClockType;)V", "aspectModel", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/cpu/CaptureNode$Aspect;", "getAspectModel", "()Lcom/android/tools/adtui/model/AspectModel;", "aspectModelPlaceHolder", "children", "", "getChildren", "()Ljava/util/List;", "childrenList", "", "getClockType", "()Lcom/android/tools/perflib/vmtrace/ClockType;", "setClockType", "(Lcom/android/tools/perflib/vmtrace/ClockType;)V", "getData", "()Lcom/android/tools/profilers/cpu/nodemodel/CaptureNodeModel;", "depth", "", "descendantsStream", "Ljava/util/stream/Stream;", "getDescendantsStream", "()Ljava/util/stream/Stream;", "endGlobal", "", "getEndGlobal", "()J", "setEndGlobal", "(J)V", "endThread", "getEndThread", "setEndThread", "filterType", "Lcom/android/tools/profilers/cpu/CaptureNode$FilterType;", "getFilterType", "()Lcom/android/tools/profilers/cpu/CaptureNode$FilterType;", "setFilterType", "(Lcom/android/tools/profilers/cpu/CaptureNode$FilterType;)V", "isUnmatched", "", "()Z", "parent", "startGlobal", "getStartGlobal", "setStartGlobal", "startThread", "getStartThread", "setStartThread", "abbreviatedBy", "abbreviate", "Lkotlin/Function1;", "isAbbreviation", "shouldAbbreviate", "abbreviation", "addChild", "", "node", "addChildren", "nodes", "", "applyFilter", "Lcom/android/tools/adtui/model/filter/FilterResult;", "filter", "Lcom/android/tools/adtui/model/filter/Filter;", "clearChildren", "clonedWithData", "computeFilter", "findRootNode", "fold", "T", "init", "combine", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getChildAt", "index", "getChildCount", "getDepth", "getEnd", "getParent", "getStart", "getTopKNodes", "k", "Ljava/util/function/Predicate;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "resetDepth", "n", "setDepth", "threadGlobalRatio", "", "Aspect", "FilterType", "intellij.android.profilers"})
public class CaptureNode
implements HNode<CaptureNode> {
    @NotNull
    private final CaptureNodeModel data;
    @NotNull
    private ClockType clockType;
    private long startGlobal;
    private long endGlobal;
    private long startThread;
    private long endThread;
    @JvmField
    @NotNull
    protected final List<CaptureNode> childrenList;
    @Nullable
    private CaptureNode parent;
    @NotNull
    private FilterType filterType;
    private int depth;
    @Nullable
    private AspectModel<Aspect> aspectModelPlaceHolder;

    public CaptureNode(@NotNull CaptureNodeModel data, @NotNull ClockType clockType) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)clockType, (String)"clockType");
        this.data = data;
        this.clockType = clockType;
        this.childrenList = new ArrayList();
        this.filterType = FilterType.MATCH;
    }

    @NotNull
    public final CaptureNodeModel getData() {
        return this.data;
    }

    @NotNull
    public final ClockType getClockType() {
        return this.clockType;
    }

    public final void setClockType(@NotNull ClockType clockType) {
        Intrinsics.checkNotNullParameter((Object)clockType, (String)"<set-?>");
        this.clockType = clockType;
    }

    @VisibleForTesting
    public CaptureNode(@NotNull CaptureNodeModel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, ClockType.GLOBAL);
    }

    public final long getStartGlobal() {
        return this.startGlobal;
    }

    public final void setStartGlobal(long l) {
        this.startGlobal = l;
    }

    public final long getEndGlobal() {
        return this.endGlobal;
    }

    public final void setEndGlobal(long l) {
        this.endGlobal = l;
    }

    public final long getStartThread() {
        return this.startThread;
    }

    public final void setStartThread(long l) {
        this.startThread = l;
    }

    public final long getEndThread() {
        return this.endThread;
    }

    public final void setEndThread(long l) {
        this.endThread = l;
    }

    @NotNull
    public final FilterType getFilterType() {
        return this.filterType;
    }

    public final void setFilterType(@NotNull FilterType filterType) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"<set-?>");
        this.filterType = filterType;
    }

    @NotNull
    public final List<CaptureNode> getChildren() {
        return this.childrenList;
    }

    public final boolean isUnmatched() {
        return this.filterType == FilterType.UNMATCH;
    }

    @NotNull
    public final Stream<CaptureNode> getDescendantsStream() {
        Stream<CaptureNode> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(descendantsStream.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"concat(Stream.of(this), \u2026{ it.descendantsStream })");
        return stream;
    }

    public void addChild(@NotNull CaptureNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.childrenList.add(node);
        node.parent = this;
    }

    public final void addChildren(@NotNull Collection<? extends CaptureNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CaptureNode p0 = (CaptureNode)element$iv;
            boolean bl = false;
            this.addChild(p0);
        }
    }

    public final void clearChildren() {
        this.childrenList.clear();
    }

    public int getChildCount() {
        return this.childrenList.size();
    }

    @NotNull
    public CaptureNode getChildAt(int index) {
        return this.childrenList.get(index);
    }

    @Nullable
    public CaptureNode getParent() {
        return this.parent;
    }

    @NotNull
    public final CaptureNode findRootNode() {
        return CaptureNode.findRootNode$find(this);
    }

    public long getStart() {
        return this.clockType == ClockType.THREAD ? this.startThread : this.startGlobal;
    }

    public long getEnd() {
        return this.clockType == ClockType.THREAD ? this.endThread : this.endGlobal;
    }

    public int getDepth() {
        return this.depth;
    }

    @NotNull
    public final AspectModel<Aspect> getAspectModel() {
        if (this.aspectModelPlaceHolder == null) {
            this.aspectModelPlaceHolder = new AspectModel();
        }
        AspectModel<Aspect> aspectModel = this.aspectModelPlaceHolder;
        Intrinsics.checkNotNull(aspectModel);
        return aspectModel;
    }

    public final double threadGlobalRatio() {
        return (double)(this.endThread - this.startThread) / (double)(this.endGlobal - this.startGlobal);
    }

    public final void setDepth(int depth) {
        this.depth = depth;
    }

    @NotNull
    public final List<CaptureNode> getTopKNodes(int k, @NotNull Predicate<CaptureNode> filter, @NotNull Comparator<CaptureNode> comparator) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        PriorityQueue<CaptureNode> candidates = new PriorityQueue<CaptureNode>(k + 1, comparator);
        this.getDescendantsStream().filter(filter).forEach(new Consumer(candidates, k){
            final /* synthetic */ PriorityQueue<CaptureNode> $candidates;
            final /* synthetic */ int $k;
            {
                this.$candidates = $candidates;
                this.$k = $k;
            }

            public final void accept(CaptureNode node) {
                this.$candidates.offer(node);
                if (this.$candidates.size() > this.$k) {
                    this.$candidates.poll();
                }
            }
        });
        Iterable iterable = candidates;
        Comparator<CaptureNode> comparator2 = comparator.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparator.reversed()");
        return CollectionsKt.sortedWith((Iterable)iterable, comparator2);
    }

    @NotNull
    public final FilterResult applyFilter(@NotNull Filter filter) {
        FilterResult filterResult;
        block0: {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            FilterResult it = filterResult = this.computeFilter(filter);
            boolean bl = false;
            AspectModel<Aspect> aspectModel = this.aspectModelPlaceHolder;
            if (aspectModel == null) break block0;
            aspectModel.changed((Enum)Aspect.FILTER_APPLIED);
        }
        return filterResult;
    }

    private final FilterResult computeFilter(Filter filter) {
        Ref.IntRef totalCount = new Ref.IntRef();
        Ref.IntRef matchCount = new Ref.IntRef();
        CaptureNode.computeFilter$updateFilter(this, filter, matchCount, totalCount, false);
        return new FilterResult(matchCount.element, totalCount.element, !filter.isEmpty());
    }

    private final void resetDepth(int n) {
        this.depth = n;
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CaptureNode it = (CaptureNode)element$iv;
            boolean bl = false;
            it.resetDepth(n + 1);
        }
    }

    @NotNull
    public final CaptureNode abbreviatedBy(@NotNull Function1<? super CaptureNode, ? extends CaptureNodeModel> abbreviate, @NotNull Function1<? super CaptureNodeModel, Boolean> isAbbreviation) {
        Intrinsics.checkNotNullParameter(abbreviate, (String)"abbreviate");
        Intrinsics.checkNotNullParameter(isAbbreviation, (String)"isAbbreviation");
        Object t = this.fold((Function1)new Function1<CaptureNode, CaptureNode>(abbreviate){
            final /* synthetic */ Function1<CaptureNode, CaptureNodeModel> $abbreviate;
            {
                this.$abbreviate = $abbreviate;
                super(1);
            }

            @NotNull
            public final CaptureNode invoke(@NotNull CaptureNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CaptureNodeModel captureNodeModel = (CaptureNodeModel)this.$abbreviate.invoke((Object)it);
                if (captureNodeModel == null) {
                    captureNodeModel = it.getData();
                }
                return CaptureNode.access$clonedWithData(it, captureNodeModel);
            }
        }, (Function2)new Function2<CaptureNode, CaptureNode, CaptureNode>(isAbbreviation){
            final /* synthetic */ Function1<CaptureNodeModel, Boolean> $isAbbreviation;
            {
                this.$isAbbreviation = $isAbbreviation;
                super(2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final CaptureNode invoke(@NotNull CaptureNode clone, @NotNull CaptureNode abbreviatedChild) {
                Intrinsics.checkNotNullParameter((Object)clone, (String)"clone");
                Intrinsics.checkNotNullParameter((Object)abbreviatedChild, (String)"abbreviatedChild");
                CaptureNode captureNode = clone;
                Function1<CaptureNodeModel, Boolean> function1 = this.$isAbbreviation;
                CaptureNode it = captureNode;
                boolean bl = false;
                if (((Boolean)function1.invoke((Object)clone.getData())).booleanValue() && abbreviatedChild.getData() == clone.getData()) {
                    clone.addChildren((Collection<? extends CaptureNode>)abbreviatedChild.getChildren());
                    return captureNode;
                }
                if (((Boolean)function1.invoke((Object)abbreviatedChild.getData())).booleanValue()) {
                    CaptureNode captureNode2 = (CaptureNode)CollectionsKt.lastOrNull(clone.getChildren());
                    if ((captureNode2 != null ? captureNode2.getData() : null) == abbreviatedChild.getData()) {
                        CaptureNode mergedChild = (CaptureNode)CollectionsKt.last(clone.getChildren());
                        boolean bl2 = false;
                        mergedChild.addChildren((Collection<? extends CaptureNode>)abbreviatedChild.getChildren());
                        KMutableProperty1[] kMutableProperty1Array = new KMutableProperty1[]{(KMutableProperty1)abbreviatedBy.1.1.1.INSTANCE, (KMutableProperty1)abbreviatedBy.1.1.2.INSTANCE};
                        CaptureNodeKt.access$copyFrom(mergedChild, abbreviatedChild, kMutableProperty1Array);
                        return captureNode;
                    }
                }
                clone.addChild(abbreviatedChild);
                return captureNode;
            }
        });
        CaptureNode it = (CaptureNode)t;
        boolean bl = false;
        it.resetDepth(this.depth);
        return (CaptureNode)t;
    }

    @NotNull
    public final CaptureNode abbreviatedBy(@NotNull Function1<? super CaptureNode, Boolean> shouldAbbreviate, @NotNull CaptureNodeModel abbreviation) {
        Intrinsics.checkNotNullParameter(shouldAbbreviate, (String)"shouldAbbreviate");
        Intrinsics.checkNotNullParameter((Object)abbreviation, (String)"abbreviation");
        return this.abbreviatedBy((Function1<? super CaptureNode, ? extends CaptureNodeModel>)((Function1)new Function1<CaptureNode, CaptureNodeModel>(abbreviation, shouldAbbreviate){
            final /* synthetic */ CaptureNodeModel $abbreviation;
            final /* synthetic */ Function1<CaptureNode, Boolean> $shouldAbbreviate;
            {
                this.$abbreviation = $abbreviation;
                this.$shouldAbbreviate = $shouldAbbreviate;
                super(1);
            }

            @Nullable
            public final CaptureNodeModel invoke(@NotNull CaptureNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CaptureNodeModel captureNodeModel = this.$abbreviation;
                Function1<CaptureNode, Boolean> function1 = this.$shouldAbbreviate;
                CaptureNodeModel it = captureNodeModel;
                boolean bl = false;
                return (Boolean)function1.invoke((Object)node) != false ? captureNodeModel : null;
            }
        }), (Function1<? super CaptureNodeModel, Boolean>)((Function1)new Function1<CaptureNodeModel, Boolean>(abbreviation){
            final /* synthetic */ CaptureNodeModel $abbreviation;
            {
                this.$abbreviation = $abbreviation;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CaptureNodeModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it == this.$abbreviation;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T fold(@NotNull Function1<? super CaptureNode, ? extends T> init, @NotNull Function2<? super T, ? super T, ? extends T> combine) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(init, (String)"init");
        Intrinsics.checkNotNullParameter(combine, (String)"combine");
        Iterable iterable = this.getChildren();
        Object initial$iv = init.invoke((Object)this);
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void child;
            CaptureNode captureNode = (CaptureNode)element$iv;
            Object acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = combine.invoke(acc, child.fold(init, combine));
        }
        return (T)accumulator$iv;
    }

    private final CaptureNode clonedWithData(CaptureNodeModel data) {
        CaptureNode captureNode;
        CaptureNode clone = captureNode = new CaptureNode(data, this.clockType);
        boolean bl = false;
        KMutableProperty1[] kMutableProperty1Array = new KMutableProperty1[]{(KMutableProperty1)clonedWithData.1.1.INSTANCE, (KMutableProperty1)clonedWithData.1.2.INSTANCE, (KMutableProperty1)clonedWithData.1.3.INSTANCE, (KMutableProperty1)clonedWithData.1.4.INSTANCE};
        CaptureNodeKt.access$copyFrom(clone, this, kMutableProperty1Array);
        return captureNode;
    }

    private static final CaptureNode findRootNode$find(CaptureNode node) {
        CaptureNode captureNode;
        CaptureNode captureNode2 = node;
        while (true) {
            captureNode = captureNode2;
            CaptureNode parent = captureNode.parent;
            if (parent == null) break;
            captureNode2 = parent;
        }
        return captureNode;
    }

    /*
     * Unable to fully structure code
     */
    private static final void computeFilter$updateFilter(CaptureNode $this$computeFilter_u24updateFilter, Filter $filter, Ref.IntRef matchCount, Ref.IntRef totalCount, boolean ancestorMatches) {
        block7: {
            nodeExactMatch = $filter.matches($this$computeFilter_u24updateFilter.data.getFullName());
            v0 = matches = ancestorMatches != false || nodeExactMatch != false;
            if (nodeExactMatch) {
                var7_7 = matchCount.element;
                matchCount.element = var7_7 + 1;
            }
            var7_7 = totalCount.element;
            totalCount.element = var7_7 + 1;
            $this$forEach$iv = $this$computeFilter_u24updateFilter.getChildren();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (CaptureNode)element$iv;
                $i$a$-forEach-CaptureNode$computeFilter$updateFilter$1 = false;
                CaptureNode.computeFilter$updateFilter(it, $filter, matchCount, totalCount, matches);
            }
            v1 = $this$computeFilter_u24updateFilter;
            if (matches) ** GOTO lbl-1000
            $this$forEach$iv = $this$computeFilter_u24updateFilter.getChildren();
            var13_14 = v1;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (CaptureNode)element$iv;
                    $i$a$-all-CaptureNode$computeFilter$updateFilter$2 = false;
                    if (it.isUnmatched()) continue;
                    v2 = false;
                    break block7;
                }
                v2 = true;
            }
        }
        var14_15 = v2;
        v1 = var13_14;
        if (var14_15) {
            v3 = FilterType.UNMATCH;
        } else lbl-1000:
        // 2 sources

        {
            v3 = nodeExactMatch != false && $filter.isEmpty() == false ? FilterType.EXACT_MATCH : FilterType.MATCH;
        }
        v1.filterType = v3;
    }

    public static final /* synthetic */ CaptureNode access$clonedWithData(CaptureNode $this, CaptureNodeModel data) {
        return $this.clonedWithData(data);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/CaptureNode$FilterType;", "", "(Ljava/lang/String;I)V", "EXACT_MATCH", "MATCH", "UNMATCH", "intellij.android.profilers"})
    public static final class FilterType
    extends Enum<FilterType> {
        public static final /* enum */ FilterType EXACT_MATCH = new FilterType();
        public static final /* enum */ FilterType MATCH = new FilterType();
        public static final /* enum */ FilterType UNMATCH = new FilterType();
        private static final /* synthetic */ FilterType[] $VALUES;

        public static FilterType[] values() {
            return (FilterType[])$VALUES.clone();
        }

        public static FilterType valueOf(String value) {
            return Enum.valueOf(FilterType.class, value);
        }

        static {
            $VALUES = filterTypeArray = new FilterType[]{FilterType.EXACT_MATCH, FilterType.MATCH, FilterType.UNMATCH};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/CaptureNode$Aspect;", "", "(Ljava/lang/String;I)V", "FILTER_APPLIED", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect FILTER_APPLIED = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.FILTER_APPLIED};
        }
    }
}

