/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTooltip;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0003H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u001b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001b\u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/profilers/cpu/AndroidFrameEventTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;)V", "durationLabel", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "getDurationLabel", "()Ljavax/swing/JLabel;", "frameNumberLabel", "getFrameNumberLabel", "helpTextLabel", "getHelpTextLabel", "labelContainer", "Ljavax/swing/JPanel;", "getLabelContainer", "()Ljavax/swing/JPanel;", "startTimeLabel", "getStartTimeLabel", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;", "createTooltip", "updateView", "", "intellij.android.profilers.ui"})
public final class AndroidFrameEventTooltipView
extends TooltipView {
    @NotNull
    private final AndroidFrameEventTooltip tooltip;
    @VisibleForTesting
    @NotNull
    private final JPanel labelContainer;
    @VisibleForTesting
    @NotNull
    private final JLabel frameNumberLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel startTimeLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel durationLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel helpTextLabel;

    /*
     * WARNING - void declaration
     */
    public AndroidFrameEventTooltipView(@NotNull JComponent parent, @NotNull AndroidFrameEventTooltip tooltip2) {
        JPanel jPanel;
        void $this$helpTextLabel_u24lambda_u2d0;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip2), (String)"tooltip");
        super(tooltip2.getTimeline());
        this.tooltip = tooltip2;
        this.labelContainer = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel2 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel()");
        this.frameNumberLabel = jLabel2;
        JLabel jLabel3 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel3, (String)"createTooltipLabel()");
        this.startTimeLabel = jLabel3;
        JLabel jLabel4 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel4, (String)"createTooltipLabel()");
        this.durationLabel = jLabel4;
        JLabel jLabel5 = jLabel = TooltipView.createTooltipLabel();
        AndroidFrameEventTooltipView androidFrameEventTooltipView = this;
        boolean bl = false;
        $this$helpTextLabel_u24lambda_u2d0.setText(this.tooltip.getAndroidFramePhase().getTooltipText());
        JLabel jLabel6 = jLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel6, (String)"createTooltipLabel().app\u2026dFramePhase.tooltipText }");
        androidFrameEventTooltipView.helpTextLabel = jLabel6;
        JPanel $this$_init__u24lambda_u2d4 = jPanel = this.labelContainer;
        boolean bl2 = false;
        $this$_init__u24lambda_u2d4.add((Component)this.frameNumberLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u2d4.add((Component)this.startTimeLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$_init__u24lambda_u2d4.add((Component)this.durationLabel, new TabularLayout.Constraint(2, 0, 0, 4, null));
        $this$_init__u24lambda_u2d4.add((Component)this.helpTextLabel, new TabularLayout.Constraint(3, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)AndroidFrameEventTooltip.Aspect.VALUE_CHANGED, new Runnable(){

            @Override
            public final void run() {
                AndroidFrameEventTooltipView.this.updateView();
            }
        });
        this.updateView();
    }

    @NotNull
    public final AndroidFrameEventTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JPanel getLabelContainer() {
        return this.labelContainer;
    }

    @NotNull
    public final JLabel getFrameNumberLabel() {
        return this.frameNumberLabel;
    }

    @NotNull
    public final JLabel getStartTimeLabel() {
        return this.startTimeLabel;
    }

    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @NotNull
    public final JLabel getHelpTextLabel() {
        return this.helpTextLabel;
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.labelContainer;
    }

    private final void updateView() {
        AndroidFrameEvent activeEvent = this.tooltip.getActiveFrameEvent();
        if (activeEvent instanceof AndroidFrameEvent.Data) {
            JLabel jLabel;
            JLabel $this$updateView_u24lambda_u2d1 = jLabel = this.frameNumberLabel;
            boolean bl = false;
            $this$updateView_u24lambda_u2d1.setVisible(true);
            $this$updateView_u24lambda_u2d1.setText("Frame number: " + ((AndroidFrameEvent.Data)activeEvent).getFrameNumber());
            JLabel $this$updateView_u24lambda_u2d2 = jLabel = this.startTimeLabel;
            boolean bl2 = false;
            $this$updateView_u24lambda_u2d2.setVisible(true);
            $this$updateView_u24lambda_u2d2.setText("Start time: " + TimeFormatter.getSemiSimplifiedClockString((long)(((AndroidFrameEvent.Data)activeEvent).getTimestampUs() - (long)this.getTimeline().getDataRange().getMin())));
            JLabel $this$updateView_u24lambda_u2d3 = jLabel = this.durationLabel;
            boolean bl3 = false;
            $this$updateView_u24lambda_u2d3.setVisible(true);
            $this$updateView_u24lambda_u2d3.setText("Duration: " + TimeFormatter.getSingleUnitDurationString((long)((AndroidFrameEvent.Data)activeEvent).getDurationUs()));
            this.helpTextLabel.setVisible(true);
        } else {
            this.frameNumberLabel.setVisible(false);
            this.startTimeLabel.setVisible(false);
            this.durationLabel.setVisible(false);
            this.helpTextLabel.setVisible(false);
        }
    }
}

