/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StudioMonitorStage
extends StreamingStage {
    @NotNull
    private final List<ProfilerMonitor> myMonitors = new LinkedList<ProfilerMonitor>();

    public StudioMonitorStage(@NotNull StudioProfilers profiler) {
        super(profiler);
    }

    @Override
    public void enter() {
        this.getTimeline().getSelectionRange().clear();
        Common.Session session = this.getStudioProfilers().getSession();
        if (session != Common.Session.getDefaultInstance()) {
            SupportLevel supportLevel = this.getStudioProfilers().getSelectedSessionSupportLevel();
            for (StudioProfiler profiler : this.getStudioProfilers().getProfilers()) {
                if (!supportLevel.isMonitorSupported(profiler)) continue;
                this.myMonitors.add(profiler.newMonitor());
            }
        }
        this.myMonitors.forEach(ProfilerMonitor::enter);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
    }

    @Override
    public void exit() {
        this.myMonitors.forEach(ProfilerMonitor::exit);
        this.myMonitors.clear();
    }

    @NotNull
    public List<ProfilerMonitor> getMonitors() {
        return this.myMonitors;
    }

    @Override
    public void setTooltip(TooltipModel tooltip2) {
        super.setTooltip(tooltip2);
        this.myMonitors.forEach(monitor -> monitor.setFocus(this.getTooltip() instanceof ProfilerMonitorTooltip && ((ProfilerMonitorTooltip)this.getTooltip()).getMonitor() == monitor));
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.OVERVIEW_STAGE;
    }
}

