/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.DeviceProcessTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.datastore.poller.DeviceProcessPoller;
import com.android.tools.datastore.poller.UnifiedEventsDataPoller;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TransportService
extends TransportServiceGrpc.TransportServiceImplBase
implements ServicePassThrough {
    private final Map<Channel, DeviceProcessPoller> myLegacyPollers = Maps.newHashMap();
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final UnifiedEventsTable myTable;
    @NotNull
    private final DeviceProcessTable myLegacyTable;
    @NotNull
    private final DataStoreService myService;
    private final boolean myLegacyPipelineForProfilers;
    private final Map<Channel, UnifiedEventsDataPoller> myUnifiedEventsPollers = Maps.newHashMap();
    private final Map<Channel, Common.Stream> myChannelToStream = Maps.newHashMap();
    @VisibleForTesting
    final AtomicInteger myNextCommandId = new AtomicInteger();

    public TransportService(@NotNull DataStoreService service, @NotNull UnifiedEventsTable unifiedTable, Consumer<Runnable> fetchExecutor, boolean legacyPipelineForProfilers) {
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myTable = unifiedTable;
        this.myLegacyTable = new DeviceProcessTable();
        this.myLegacyPipelineForProfilers = legacyPipelineForProfilers;
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myTable.initialize(connection);
        if (this.myLegacyPipelineForProfilers) {
            this.myLegacyTable.initialize(connection);
        }
    }

    public void connectToChannel(Common.Stream stream, Channel channel) {
        long streamId = stream.getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub stub = this.myService.getTransportClient(streamId);
        assert (stub != null);
        this.streamConnected(stream);
        UnifiedEventsDataPoller unifiedPoller = new UnifiedEventsDataPoller(stream.getStreamId(), this.myTable, stub, this.myService);
        this.myUnifiedEventsPollers.put(channel, unifiedPoller);
        this.myChannelToStream.put(channel, stream);
        DataStoreTable.addDataStoreErrorCallback(unifiedPoller);
        this.myFetchExecutor.accept(unifiedPoller);
        if (this.myLegacyPipelineForProfilers && stream.getType() == Common.Stream.Type.DEVICE) {
            DeviceProcessPoller legacyPoller = new DeviceProcessPoller(this.myLegacyTable, stub);
            this.myLegacyPollers.put(channel, legacyPoller);
            this.myFetchExecutor.accept(legacyPoller);
        }
    }

    public void disconnectFromChannel(Channel channel) {
        Runnable poller;
        if (this.myLegacyPollers.containsKey(channel)) {
            poller = this.myLegacyPollers.remove(channel);
            ((DeviceProcessPoller)poller).stop();
        }
        if (this.myUnifiedEventsPollers.containsKey(channel)) {
            poller = this.myUnifiedEventsPollers.remove(channel);
            ((UnifiedEventsDataPoller)poller).stop();
            DataStoreTable.removeDataStoreErrorCallback((DataStoreTable.DataStoreTableErrorCallback)((Object)poller));
            this.streamDisconnected(this.myChannelToStream.remove(channel));
        }
    }

    private void streamConnected(Common.Stream stream) {
        this.myTable.insertUnifiedEvent(-1L, Common.Event.newBuilder().setKind(Common.Event.Kind.STREAM).setGroupId(stream.getStreamId()).setTimestamp(System.nanoTime()).setStream(Common.StreamData.newBuilder().setStreamConnected(Common.StreamData.StreamConnected.newBuilder().setStream(stream))).build());
    }

    private void streamDisconnected(Common.Stream stream) {
        this.myTable.insertUnifiedEvent(-1L, Common.Event.newBuilder().setKind(Common.Event.Kind.STREAM).setGroupId(stream.getStreamId()).setIsEnded(true).setTimestamp(System.nanoTime()).build());
    }

    public void getCurrentTime(Transport.TimeRequest request, StreamObserver<Transport.TimeResponse> observer) {
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(request.getStreamId());
        if (client != null) {
            observer.onNext((Object)client.getCurrentTime(request));
        } else {
            observer.onNext((Object)Transport.TimeResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getVersion(Transport.VersionRequest request, StreamObserver<Transport.VersionResponse> observer) {
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(request.getStreamId());
        if (client != null) {
            observer.onNext((Object)client.getVersion(request));
        }
        observer.onCompleted();
    }

    public void getDevices(Transport.GetDevicesRequest request, StreamObserver<Transport.GetDevicesResponse> observer) {
        Transport.GetDevicesResponse response = this.myLegacyTable.getDevices();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getProcesses(Transport.GetProcessesRequest request, StreamObserver<Transport.GetProcessesResponse> observer) {
        Transport.GetProcessesResponse response = this.myLegacyTable.getProcesses(request);
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getAgentStatus(Transport.AgentStatusRequest request, StreamObserver<Common.AgentData> observer) {
        observer.onNext((Object)this.myLegacyTable.getAgentStatus(request));
        observer.onCompleted();
    }

    public void getBytes(Transport.BytesRequest request, StreamObserver<Transport.BytesResponse> responseObserver) {
        Transport.BytesResponse response = this.myTable.getBytes(request);
        long streamId = request.getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(streamId);
        if (response == null && client != null) {
            response = client.getBytes(request);
            if (!response.getContents().isEmpty()) {
                this.myTable.insertBytes(streamId, request.getId(), response);
            }
        } else if (response == null) {
            response = Transport.BytesResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void execute(Transport.ExecuteRequest request, StreamObserver<Transport.ExecuteResponse> responseObserver) {
        long streamId = request.getCommand().getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(streamId);
        if (client != null) {
            Commands.Command command = request.getCommand();
            int commandId = this.myNextCommandId.incrementAndGet();
            request = request.toBuilder().setCommand(command.toBuilder().setCommandId(commandId)).build();
            responseObserver.onNext((Object)client.execute(request).toBuilder().setCommandId(commandId).build());
        } else {
            responseObserver.onNext((Object)Transport.ExecuteResponse.getDefaultInstance());
        }
        responseObserver.onCompleted();
    }

    public void getEventGroups(Transport.GetEventGroupsRequest request, StreamObserver<Transport.GetEventGroupsResponse> responseObserver) {
        Transport.GetEventGroupsResponse.Builder response = Transport.GetEventGroupsResponse.newBuilder();
        List<Transport.EventGroup> events = this.myTable.queryUnifiedEventGroups(request);
        response.addAllGroups(events);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deleteEvents(Transport.DeleteEventsRequest request, StreamObserver<Transport.DeleteEventsResponse> responseObserver) {
        this.myTable.deleteEvents(request.getStreamId(), request.getPid(), request.getGroupId(), request.getKind(), request.getFromTimestamp(), request.getToTimestamp());
        responseObserver.onNext((Object)Transport.DeleteEventsResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }
}

