/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.CpuDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.datastore.service.ResponseData;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CpuService
extends CpuServiceGrpc.CpuServiceImplBase
implements ServicePassThrough {
    private final Map<Long, PollRunner> myRunners = new HashMap<Long, PollRunner>();
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final DataStoreService myService;
    @NotNull
    private final LogService myLogService;
    private ResponseData<CpuProfiler.CpuDataResponse> myLastCpuResponse = ResponseData.createEmpty();
    private ResponseData<CpuProfiler.GetThreadsResponse> myLastThreadsResponse = ResponseData.createEmpty();
    private ResponseData<CpuProfiler.GetTraceInfoResponse> myLastTraceInfoResponse = ResponseData.createEmpty();

    public CpuService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, LogService logService) {
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myLogService = logService;
        this.myCpuTable = new CpuTable();
    }

    public void getData(CpuProfiler.CpuDataRequest request, StreamObserver<CpuProfiler.CpuDataResponse> observer) {
        if (!this.myLastCpuResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.CpuDataResponse.Builder response = CpuProfiler.CpuDataResponse.newBuilder();
            List<Cpu.CpuUsageData> cpuData = this.myCpuTable.getCpuDataByRequest(request);
            for (Cpu.CpuUsageData data : cpuData) {
                response.addData(data);
            }
            this.myLastCpuResponse = new ResponseData<CpuProfiler.CpuDataResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastCpuResponse.getResponse());
        observer.onCompleted();
    }

    public void getThreads(CpuProfiler.GetThreadsRequest request, StreamObserver<CpuProfiler.GetThreadsResponse> observer) {
        if (!this.myLastThreadsResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.GetThreadsResponse.Builder response = CpuProfiler.GetThreadsResponse.newBuilder();
            response.addAllThreads(this.myCpuTable.getThreadsDataByRequest(request));
            this.myLastThreadsResponse = new ResponseData<CpuProfiler.GetThreadsResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastThreadsResponse.getResponse());
        observer.onCompleted();
    }

    public void getTraceInfo(CpuProfiler.GetTraceInfoRequest request, StreamObserver<CpuProfiler.GetTraceInfoResponse> responseObserver) {
        if (!this.myLastTraceInfoResponse.matches(request.getSession(), request.getFromTimestamp(), request.getToTimestamp())) {
            CpuProfiler.GetTraceInfoResponse.Builder response = CpuProfiler.GetTraceInfoResponse.newBuilder();
            List<Cpu.CpuTraceInfo> responses = this.myCpuTable.getTraceInfo(request);
            response.addAllTraceInfo(responses);
            this.myLastTraceInfoResponse = new ResponseData<CpuProfiler.GetTraceInfoResponse>(request.getSession(), request.getFromTimestamp(), request.getToTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastTraceInfoResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(CpuProfiler.CpuStartRequest request, StreamObserver<CpuProfiler.CpuStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            long sessionId = request.getSession().getSessionId();
            this.myRunners.put(sessionId, new CpuDataPoller(request.getSession(), this.myCpuTable, client, this.myLogService));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            observer.onNext((Object)CpuProfiler.CpuStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(CpuProfiler.CpuStopRequest request, StreamObserver<CpuProfiler.CpuStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub service;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((service = this.myService.getCpuClient(request.getSession().getStreamId())) == null) {
            observer.onNext((Object)CpuProfiler.CpuStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startProfilingApp(request));
        } else {
            observer.onNext((Object)CpuProfiler.CpuProfilingAppStartResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        CpuProfiler.CpuProfilingAppStopResponse response = CpuProfiler.CpuProfilingAppStopResponse.getDefaultInstance();
        if (client != null) {
            response = client.stopProfilingApp(request);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void startStartupProfiling(CpuProfiler.StartupProfilingRequest request, StreamObserver<CpuProfiler.StartupProfilingResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getDeviceId());
        if (client != null) {
            observer.onNext((Object)client.startStartupProfiling(request));
        } else {
            observer.onNext((Object)CpuProfiler.StartupProfilingResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest request, StreamObserver<CpuProfiler.CpuCoreConfigResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getDeviceId());
        if (client != null) {
            observer.onNext((Object)client.getCpuCoreConfig(request));
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myCpuTable.initialize(connection);
    }
}

