/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.IntObjectHashMap;
import org.jetbrains.annotations.NotNull;

public class IntObjectMap<T> {
    private final IntObjectHashMap<T> myObjectsMap = new IntObjectHashMap((IntObjectHashMap.ArrayProducer)new IntObjectHashMap.ArrayProducer<T[]>(){

        public T[] produce(int s) {
            return s == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[s];
        }
    });

    public T computeIfAbsent(int objectID, @NotNull ObjectFactory<T> objectFactory) {
        Object object = this.myObjectsMap.get(objectID);
        if (object == null) {
            object = objectFactory.newInstance();
            this.myObjectsMap.put(objectID, object);
            objectFactory.fill(object);
        }
        return (T)object;
    }

    public static abstract class SimpleObjectFactory<T>
    implements ObjectFactory<T> {
        public abstract T create();

        @Override
        public T newInstance() {
            return this.create();
        }

        @Override
        public void fill(T object) {
        }
    }

    public static interface ObjectFactory<T> {
        public T newInstance();

        public void fill(T var1);
    }
}

