/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import java.util.HashMap;
import java.util.Map;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public final class GradleVersionComparator
implements Comparable<GradleVersion> {
    private final GradleVersion myVersion;
    private final Map<String, Integer> myResults = new HashMap<String, Integer>();
    private final Map<String, GradleVersion> myVersionsMap = new HashMap<String, GradleVersion>();

    public GradleVersionComparator(@NotNull GradleVersion gradleVersion) {
        this.myVersion = gradleVersion;
    }

    @Override
    public int compareTo(@NotNull GradleVersion gradleVersion) {
        if (this.myVersion == gradleVersion) {
            return 0;
        }
        String version = gradleVersion.getVersion();
        if (this.myVersion.getVersion().equals(version)) {
            return 0;
        }
        Integer cached = this.myResults.get(version);
        if (cached != null) {
            return cached;
        }
        int result = this.myVersion.compareTo(gradleVersion);
        this.myResults.put(version, result);
        return result;
    }

    public boolean lessThan(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) < 0;
    }

    public boolean lessThan(@NotNull String gradleVersion) {
        return this.lessThan(this.getGradleVersion(gradleVersion));
    }

    public boolean isOrGreaterThan(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) >= 0;
    }

    public boolean isOrGreaterThan(@NotNull String gradleVersion) {
        return this.isOrGreaterThan(this.getGradleVersion(gradleVersion));
    }

    public boolean is(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) == 0;
    }

    public boolean is(@NotNull String gradleVersion) {
        return this.is(this.getGradleVersion(gradleVersion));
    }

    @NotNull
    private GradleVersion getGradleVersion(@NotNull String gradleVersion) {
        GradleVersion version = this.myVersionsMap.get(gradleVersion);
        if (version == null) {
            version = GradleVersion.version((String)gradleVersion);
            this.myVersionsMap.put(gradleVersion, version);
        }
        return version;
    }
}

