/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingSerializer;

public abstract class ModelsHolder<B extends BuildModel, P extends ProjectModel>
implements Serializable {
    @NotNull
    private final B myRootModel;
    @NotNull
    private final Map<String, Object> myModelsById = new LinkedHashMap<String, Object>();
    @Nullable
    private ToolingSerializer mySerializer;
    @Nullable
    private Consumer<Object> myPathsConverter;

    public ModelsHolder(@NotNull B rootModel) {
        this.myRootModel = rootModel;
    }

    @ApiStatus.Internal
    public void initToolingSerializer() {
        this.mySerializer = new ToolingSerializer();
    }

    @ApiStatus.Internal
    void applyPathsConverter(@NotNull Consumer<Object> pathsConverter) {
        this.myPathsConverter = pathsConverter;
    }

    @NotNull
    protected B getRootModel() {
        return this.myRootModel;
    }

    @Nullable
    public <T> T getModel(@NotNull Class<T> modelClazz) {
        return this.getModel((P)this.getRootModel(), modelClazz);
    }

    @Nullable
    public <T> T getModel(@NotNull B build, @NotNull Class<T> modelClazz) {
        String key = this.extractMapKey(modelClazz, build.getBuildIdentifier());
        return this.getModel(modelClazz, key);
    }

    @Nullable
    public <T> T getModel(@NotNull P project, @NotNull Class<T> modelClazz) {
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        String key = this.extractMapKey(modelClazz, projectIdentifier);
        return this.getModel(modelClazz, key);
    }

    @Nullable
    private <T> T getModel(@NotNull Class<T> modelClazz, @NotNull String key) {
        Object model = this.myModelsById.get(key);
        if (model == null) {
            return null;
        }
        if (modelClazz.isInstance(model)) {
            return (T)model;
        }
        this.deserializeAllDataOfTheType(modelClazz);
        return (T)this.myModelsById.get(key);
    }

    private <T> void deserializeAllDataOfTheType(@NotNull Class<T> modelClazz) {
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        Iterator<Map.Entry<String, Object>> iterator = this.myModelsById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            if (!key.startsWith(keyPrefix)) continue;
            if (this.mySerializer == null || !(entry.getValue() instanceof byte[])) {
                iterator.remove();
                continue;
            }
            try {
                T deserializedData = this.mySerializer.read((byte[])entry.getValue(), modelClazz);
                if (modelClazz.isInstance(deserializedData)) {
                    if (this.myPathsConverter != null) {
                        this.myPathsConverter.consume(deserializedData);
                    }
                    this.myModelsById.put(key, deserializedData);
                    continue;
                }
                iterator.remove();
            }
            catch (Exception e) {
                this.reportError(entry.getKey(), e);
                iterator.remove();
            }
        }
    }

    private void reportError(String key, Exception e) {
        System.err.println(e.getMessage());
        this.tryReportingViaIdeaLogger(e, key);
    }

    private void tryReportingViaIdeaLogger(Exception e, String key) {
        try {
            Class<?> aClass = this.getClass();
            Class<?> loggerClazz = aClass.getClassLoader().loadClass("com.intellij.openapi.diagnostic.Logger");
            Method getInstanceMethod = loggerClazz.getMethod("getInstance", Class.class);
            Object logger = getInstanceMethod.invoke(null, aClass);
            Method errorMethod = loggerClazz.getMethod("error", String.class, Throwable.class);
            errorMethod.invoke(logger, "Failed to parse model with key [" + key + "]", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        for (String key : this.myModelsById.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz) {
        this.addModel(model, modelClazz, this.getRootModel());
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull P project) {
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        this.myModelsById.put(this.extractMapKey(modelClazz, projectIdentifier), model);
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull B build) {
        this.myModelsById.put(this.extractMapKey(modelClazz, build.getBuildIdentifier()), model);
    }

    @NotNull
    private static String getModelKeyPrefix(@NotNull Class modelClazz) {
        return modelClazz.getSimpleName() + modelClazz.getName().hashCode();
    }

    @NotNull
    private String extractMapKey(@NotNull Class modelClazz, @NotNull ProjectIdentifier projectIdentifier) {
        String modelKeyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        String buildKeyPrefix = this.getBuildKeyPrefix(projectIdentifier.getBuildIdentifier());
        return modelKeyPrefix + '/' + buildKeyPrefix + projectIdentifier.getProjectPath();
    }

    @NotNull
    private String extractMapKey(@NotNull Class modelClazz, @NotNull BuildIdentifier buildIdentifier) {
        String modelKeyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        String buildKeyPrefix = this.getBuildKeyPrefix(buildIdentifier);
        return modelKeyPrefix + '/' + buildKeyPrefix + ":";
    }

    @NotNull
    protected String getBuildKeyPrefix(@NotNull BuildIdentifier buildIdentifier) {
        String path = buildIdentifier.getRootDir().getPath();
        String systemIndependentName = FileUtilRt.toSystemIndependentName((String)path);
        return String.valueOf(systemIndependentName.hashCode());
    }

    private ProjectIdentifier getProjectIdentifier(@NotNull P project) {
        ProjectIdentifier projectIdentifier = project instanceof IdeaModule ? ((IdeaModule)project).getGradleProject().getProjectIdentifier() : project.getProjectIdentifier();
        return projectIdentifier;
    }

    public String toString() {
        return "Models{rootModel=" + this.myRootModel + ", myModelsById=" + this.myModelsById + '}';
    }

    boolean hasModels() {
        return !this.myModelsById.isEmpty();
    }
}

