/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.stubs;

import com.intellij.dev.psiViewer.stubs.StubViewerPsiBasedTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubDetailsViewer {
    private static final boolean DEFAULT_SHOW_STUB_DETAILS = false;
    private static final String PROPERTY_NAME = "StubDetailsViewer.showPreviewDetails";
    @NotNull
    private final StubViewerPsiBasedTree myStubViewerTree;
    @NotNull
    private final Tree myStubDetailsTree;

    public StubDetailsViewer(@NotNull StubViewerPsiBasedTree tree) {
        this.myStubViewerTree = tree;
        this.myStubDetailsTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myStubDetailsTree.setRootVisible(false);
    }

    public AnAction addComponent(final JBSplitter splitter) {
        this.updateStubDetailsTreeView(PropertiesComponent.getInstance().getBoolean(PROPERTY_NAME, false), splitter);
        return new ToggleAction("Show Stub Details", null, AllIcons.Actions.PreviewDetails){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return PropertiesComponent.getInstance().getBoolean(StubDetailsViewer.PROPERTY_NAME, false);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                PropertiesComponent.getInstance().setValue(StubDetailsViewer.PROPERTY_NAME, state, false);
                StubDetailsViewer.this.updateStubDetailsTreeView(state, splitter);
                if (state) {
                    StubDetailsViewer.this.valueChanged(StubDetailsViewer.this.myStubViewerTree.getSelectedStub());
                    ((AsyncTreeModel)StubDetailsViewer.this.myStubDetailsTree.getModel()).treeStructureChanged(null);
                }
            }
        };
    }

    private void updateStubDetailsTreeView(boolean isShown, JBSplitter splitter) {
        this.myStubDetailsTree.setEnabled(isShown);
        splitter.setSecondComponent(isShown ? ScrollPaneFactory.createScrollPane((Component)this.myStubDetailsTree, (boolean)true) : null);
    }

    public void valueChanged(@Nullable StubElement<?> stub) {
        if (this.myStubDetailsTree.isEnabled()) {
            Disposable treeModelDisposable = this.myStubViewerTree.myTreeModelDisposable;
            StructureTreeModel model = new StructureTreeModel((AbstractTreeStructure)new StubDetailsTreeStructure(stub), null, Invoker.forEventDispatchThread((Disposable)treeModelDisposable), treeModelDisposable);
            AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)model, false, treeModelDisposable);
            this.myStubDetailsTree.setModel((TreeModel)asyncTreeModel);
            this.myStubDetailsTree.expandRow(0);
            this.myStubDetailsTree.treeDidChange();
        }
    }

    private static class StubDetailsRootNode
    extends SimpleNode {
        @NotNull
        private final StubElement<?> myStub;

        private StubDetailsRootNode(@NotNull StubElement<?> stub) {
            this.myStub = stub;
        }

        public SimpleNode @NotNull [] getChildren() {
            return (SimpleNode[])ReflectionUtil.collectFields(this.myStub.getClass()).stream().filter(f -> {
                if (Modifier.isStatic(f.getModifiers())) {
                    return false;
                }
                Class<?> aClass = f.getDeclaringClass();
                return !StubBase.class.equals(aClass) && !ObjectStubBase.class.equals(aClass) && !AtomicReference.class.equals(aClass) && (f.canAccess(this.myStub) || f.trySetAccessible());
            }).map(f -> f.getName() + " = " + ReflectionUtil.getFieldValue((Field)f, this.myStub)).sorted().map(s -> new SimpleNode((String)s){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                public SimpleNode @NotNull [] getChildren() {
                    return NO_CHILDREN;
                }

                public String getName() {
                    return this.val$s;
                }
            }).toArray(SimpleNode[]::new);
        }
    }

    private static class StubDetailsTreeStructure
    extends SimpleTreeStructure {
        private final Object myRoot;

        private StubDetailsTreeStructure(@Nullable StubElement<?> root) {
            this.myRoot = root != null ? new StubDetailsRootNode(root) : new Object();
        }

        @NotNull
        public Object getRootElement() {
            return this.myRoot;
        }
    }
}

