/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class BlockTreeNode
extends SimpleNode {
    private final Block myBlock;

    BlockTreeNode(Block block, BlockTreeNode parent) {
        super((SimpleNode)parent);
        this.myBlock = block;
    }

    public Block getBlock() {
        return this.myBlock;
    }

    public BlockTreeNode @NotNull [] getChildren() {
        return (BlockTreeNode[])ContainerUtil.map2Array((Collection)this.myBlock.getSubBlocks(), BlockTreeNode.class, block -> new BlockTreeNode((Block)block, this));
    }

    protected void update(@NotNull PresentationData presentation) {
        Object name = this.myBlock.getDebugName();
        if (name == null) {
            name = this.myBlock.getClass().getSimpleName();
        }
        if (this.myBlock instanceof DataLanguageBlockWrapper) {
            name = (String)name + " (" + ((DataLanguageBlockWrapper)this.myBlock).getOriginal().getClass().getSimpleName() + ")";
        }
        presentation.addText((String)name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myBlock.getIndent() != null) {
            presentation.addText(" " + String.valueOf(this.myBlock.getIndent()).replaceAll("[<>]", " "), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myBlock.getAlignment() != null) {
            float d = 1.0f * (float)System.identityHashCode(this.myBlock.getAlignment()) / 2.1474836E9f;
            JBColor color = new JBColor(Color.HSBtoRGB(d, 0.3f, 0.7f), Color.HSBtoRGB(d, 0.3f, 0.8f));
            presentation.addText(" " + this.myBlock.getAlignment(), new SimpleTextAttributes(1, (Color)color));
        }
        if (this.myBlock.getWrap() != null) {
            presentation.addText(" " + this.myBlock.getWrap(), new SimpleTextAttributes(2, PlatformColors.BLUE));
        }
    }

    public Object @NotNull [] getEqualityObjects() {
        return new Object[]{this.myBlock};
    }

    public boolean isAlwaysLeaf() {
        return this.myBlock.isLeaf() && this.myBlock.getSubBlocks().isEmpty();
    }
}

