/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.dev.psiViewer.ViewerNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces = true;
    private boolean myShowTreeNodes = true;
    private final Project myProject;
    private PsiElement myRootPsiElement;
    private final Object myRootElement = ObjectUtils.sentinel((String)"Psi Viewer Root");

    ViewerTreeStructure(@NotNull Project project) {
        this.myProject = project;
    }

    void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    @NotNull
    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        if (this.myRootElement == element) {
            if (this.myRootPsiElement == null) {
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            if (!(this.myRootPsiElement instanceof PsiFile)) {
                return new Object[]{this.myRootPsiElement};
            }
            List files = ((PsiFile)this.myRootPsiElement).getViewProvider().getAllFiles();
            return PsiUtilCore.toPsiFileArray((Collection)files);
        }
        return (Object[])ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myShowTreeNodes) {
                ASTNode root;
                ArrayList<ASTNode> list = new ArrayList<ASTNode>();
                Object object = element instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)((PsiElement)element)) : (root = element instanceof ASTNode ? (ASTNode)element : null);
                if (element instanceof Inject) {
                    root = SourceTreeToPsiMap.psiElementToTree((PsiElement)((Inject)element).getPsi());
                }
                if (root != null) {
                    for (ASTNode child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        if (!this.myShowWhiteSpaces && child.getElementType() == TokenType.WHITE_SPACE) continue;
                        PsiElement childElement = child.getPsi();
                        list.add((ASTNode)(childElement == null ? child : childElement));
                    }
                    PsiElement psi = root.getPsi();
                    if (psi instanceof PsiLanguageInjectionHost) {
                        InjectedLanguageManager.getInstance((Project)this.myProject).enumerate(psi, (injectedPsi, places) -> list.add((ASTNode)new Inject(psi, (PsiElement)injectedPsi)));
                    }
                }
                return ArrayUtil.toObjectArray(list);
            }
            Object[] elementChildren = ((PsiElement)element).getChildren();
            if (!this.myShowWhiteSpaces) {
                ArrayList<Object> childrenList = new ArrayList<Object>(elementChildren.length);
                for (Object psiElement : elementChildren) {
                    if (psiElement instanceof PsiWhiteSpace) continue;
                    childrenList.add(psiElement);
                }
                return PsiUtilCore.toPsiElementArray(childrenList);
            }
            return elementChildren;
        });
    }

    public Object getParentElement(@NotNull Object element) {
        PsiLanguageInjectionHost host;
        if (element == this.myRootElement) {
            return null;
        }
        if (element == this.myRootPsiElement) {
            return this.myRootElement;
        }
        if (element instanceof PsiFile && (host = InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element))) != null) {
            return new Inject((PsiElement)host, (PsiElement)element);
        }
        if (element instanceof Inject) {
            return ((Inject)element).getParent();
        }
        if (element instanceof PsiElement) {
            return ((PsiElement)element).getContext();
        }
        return null;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == this.myRootElement) {
            return new NodeDescriptor<Object>(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
        }
        return new ViewerNodeDescriptor(this.myProject, element, parentDescriptor);
    }

    void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }

    static class Inject {
        @NotNull
        private final PsiElement myParent;
        @NotNull
        private final PsiElement myPsi;

        Inject(@NotNull PsiElement parent, @NotNull PsiElement psi) {
            this.myParent = parent;
            this.myPsi = psi;
        }

        @NotNull
        public PsiElement getParent() {
            return this.myParent;
        }

        @NotNull
        public PsiElement getPsi() {
            return this.myPsi;
        }

        public String toString() {
            return "INJECTION " + this.myPsi.getLanguage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inject inject = (Inject)o;
            if (!this.myParent.equals(inject.myParent)) {
                return false;
            }
            return this.myPsi.equals(inject.myPsi);
        }

        public int hashCode() {
            int result = this.myParent.hashCode();
            result = 31 * result + this.myPsi.hashCode();
            return result;
        }
    }
}

