/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.net.HostSpecifier;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlAssistUtils {
    @NotNull
    public static XmlTag createDeepLinkIntentFilter(@NotNull Order order, @NotNull XmlTag activityTag, @NotNull FullUrl fullUrl, @NotNull PathData pathData) {
        String prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        XmlTag intentFilter = activityTag.createChildTag("intent-filter", null, "\n        <action " + prefix + ":name=\"android.intent.action.VIEW\" />\n        <category " + prefix + ":name=\"android.intent.category.DEFAULT\" />\n<category " + prefix + ":name=\"android.intent.category.BROWSABLE\" />\n        <data\n              " + prefix + ":scheme=\"" + fullUrl.getScheme() + "\"\n              " + prefix + ":host=\"" + fullUrl.getHost() + "\"\n" + (String)(fullUrl.getPort() < 0 ? "" : "              " + prefix + ":port=\"" + fullUrl.getPortText() + "\"\n") + (String)(StringUtil.isEmpty((String)fullUrl.getMimeType()) ? "" : "              " + prefix + ":mimeType=\"" + XmlUtil.escape((String)fullUrl.getMimeType()) + "\"\n") + (String)(StringUtil.isEmpty((String)pathData.getPathValue()) ? "" : "              " + prefix + ":" + pathData.getPathType() + "=\"" + XmlUtil.escape((String)pathData.getPathValue()) + "\"") + "/>\n", false);
        if (order.getInteger() != null) {
            intentFilter.setAttribute(prefix + ":order", order.getInteger().toString());
        }
        return activityTag.addSubTag(intentFilter, false);
    }

    public static void openActivityFile(@NotNull Project project, @NotNull ActivityData activityData) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)activityData.getModule());
        if (facet != null && Manifest.getMainManifest((AndroidFacet)facet) != null) {
            List activityList = Manifest.getMainManifest((AndroidFacet)facet).getApplication().getActivities();
            for (Activity activity : activityList) {
                if (!activityData.getActivityName().equals(activity.getActivityClass().getStringValue())) continue;
                PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
                if (activityClass != null) {
                    UrlAssistUtils.openVirtualFile(project, activityClass.getContainingFile().getVirtualFile());
                    break;
                }
                Messages.showMessageDialog((Project)project, (String)UrlAssistantBundle.message("check.url.mapping.activity.file.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
                break;
            }
        }
    }

    public static void openVirtualFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            Messages.showMessageDialog((Project)project, (String)UrlAssistantBundle.message("check.url.mapping.open.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> FileEditorManager.getInstance((Project)project).openFile(virtualFile, true), ModalityState.any());
    }

    public static boolean matchesHost(@NotNull String actualHost, @NotNull String hostRegex) {
        if (hostRegex.contains("*") && hostRegex.indexOf(42) != hostRegex.lastIndexOf(42)) {
            return false;
        }
        return actualHost.matches(hostRegex.replace(".", "\\.").replace("*", ".+"));
    }

    public static boolean matchGlobPattern(@NotNull String pattern, @NotNull String match) {
        int NP = pattern.length();
        if (NP <= 0) {
            return match.length() <= 0;
        }
        int NM = match.length();
        int ip = 0;
        int im = 0;
        char nextChar = pattern.charAt(0);
        while (ip < NP && im < NM) {
            boolean escaped;
            char c = nextChar;
            nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            boolean bl = escaped = c == '\\';
            if (escaped) {
                c = nextChar;
                char c2 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            }
            if (nextChar == '*') {
                if (!escaped && c == '.') {
                    if (ip >= NP - 1) {
                        return true;
                    }
                    if ((nextChar = pattern.charAt(++ip)) == '\\') {
                        char c3 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    }
                    while (match.charAt(im) != nextChar && ++im < NM) {
                    }
                    if (im == NM) {
                        return false;
                    }
                    nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    ++im;
                    continue;
                }
                while (match.charAt(im) == c && ++im < NM) {
                }
                nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                continue;
            }
            if (c != '.' && match.charAt(im) != c) {
                return false;
            }
            ++im;
        }
        if (ip >= NP && im >= NM) {
            return true;
        }
        return ip == NP - 2 && pattern.charAt(ip) == '.' && pattern.charAt(ip + 1) == '*';
    }

    @NotNull
    public static String getFirstValidUrl(@NotNull Module module) {
        DeepLinks deepLinks = new DeepLinks();
        DeepLinkUtils.loadDeepLinks(module, deepLinks, null);
        return !deepLinks.getDeepLinkList().isEmpty() ? ((DeepLinks.DeepLink)deepLinks.getDeepLinkList().get(0)).getUrl().toString() : "";
    }

    @Nullable
    public static ActivityData findAssociatedActivity(@NotNull List<DeepLinks.DeepLink> myDeepLinkList, @NotNull String urlString) throws MalformedURLException {
        if (StringUtil.isEmpty((String)urlString)) {
            throw new MalformedURLException();
        }
        URL url = new URL(urlString);
        if (!HostSpecifier.isValid((String)url.getHost())) {
            throw new MalformedURLException();
        }
        for (DeepLinks.DeepLink link : myDeepLinkList) {
            FullUrl fullUrl = link.getUrl();
            PathData pathData = link.getPath();
            if (!url.getProtocol().equals(fullUrl.getScheme()) || !UrlAssistUtils.matchesHost(url.getHost(), fullUrl.getHost()) || url.getPort() != fullUrl.getPort()) continue;
            if (StringUtil.isEmpty((String)pathData.getPathValue())) {
                return link.getActivityData();
            }
            PathType pathType = pathData.getPathType();
            String wantedPath = url.getPath();
            String pathValue = pathData.getPathValue();
            if (!StringUtil.isNotEmpty((String)wantedPath) || !(pathType == PathType.Path && wantedPath.equals(pathValue) || pathType == PathType.PathPrefix && wantedPath.startsWith(pathValue)) && (pathType != PathType.PathPattern || !UrlAssistUtils.matchGlobPattern(pathValue, wantedPath))) continue;
            return link.getActivityData();
        }
        return null;
    }
}

