/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.InsertCodeHandler;
import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/google/urlassistant/util/InsertJavaCodeHandler;", "Lcom/google/urlassistant/util/InsertCodeHandler;", "activity", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "activityOnCreateMethod", "Lcom/intellij/psi/PsiCodeBlock;", "project", "Lcom/intellij/openapi/project/Project;", "getOnCreate", "hasImportStatement", "", "importList", "Lcom/intellij/psi/PsiImportList;", "className", "", "invoke", "", "maybeAddStatementsToMethod", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "maybeInsertImportList", "shouldInvoke", "Lcom/google/urlassistant/util/InsertCodeHandler$CodeInsertErrorCode;", "Companion", "url-assistant"})
public final class InsertJavaCodeHandler
extends InsertCodeHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiClass activity;
    @NotNull
    private final Project project;
    @Nullable
    private final PsiCodeBlock activityOnCreateMethod;
    @NotNull
    private static final Set<String> ON_CREATE_POSSIBLE_PARAM_TYPES;
    @NotNull
    private static final List<String> STATEMENTS_LIST;

    public InsertJavaCodeHandler(@NotNull PsiClass activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        Project project = this.activity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"activity.project");
        this.project = project;
        this.activityOnCreateMethod = this.getOnCreate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InsertCodeHandler.CodeInsertErrorCode shouldInvoke() {
        void $this$mapTo$iv$iv;
        if (this.activityOnCreateMethod == null) {
            return InsertCodeHandler.CodeInsertErrorCode.NoOnCreateMethod;
        }
        PsiStatement[] psiStatementArray = this.activityOnCreateMethod.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiStatementArray, (String)"activityOnCreateMethod.statements");
        Object[] $this$map$iv = psiStatementArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiStatement psiStatement = (PsiStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        if (((List)destination$iv$iv).containsAll((Collection)STATEMENTS_LIST)) {
            return InsertCodeHandler.CodeInsertErrorCode.AppLinksCodeConflict;
        }
        return InsertCodeHandler.CodeInsertErrorCode.SUCCEED;
    }

    @Override
    public void invoke() {
        if (this.shouldInvoke() != InsertCodeHandler.CodeInsertErrorCode.SUCCEED) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, editor){
            final /* synthetic */ InsertJavaCodeHandler this$0;
            final /* synthetic */ Editor $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
            }

            public final void run() {
                CommandProcessor.getInstance().executeCommand(InsertJavaCodeHandler.access$getProject$p(this.this$0), new Runnable(this.this$0, this.$editor){
                    final /* synthetic */ InsertJavaCodeHandler this$0;
                    final /* synthetic */ Editor $editor;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                    }

                    public final void run() {
                        Pair psiElementPair = InsertJavaCodeHandler.access$maybeAddStatementsToMethod(this.this$0);
                        InsertJavaCodeHandler.access$maybeInsertImportList(this.this$0);
                        if (psiElementPair == null) {
                            return;
                        }
                        this.$editor.getSelectionModel().setSelection(((PsiElement)psiElementPair.first).getTextOffset(), ((PsiElement)psiElementPair.second).getTextRange().getEndOffset());
                        this.$editor.getScrollingModel().scrollTo(this.$editor.offsetToLogicalPosition(((PsiElement)psiElementPair.first).getTextOffset()), ScrollType.CENTER_UP);
                    }
                }, "Add intent filter handling logic", null);
            }
        });
    }

    private final void maybeInsertImportList() {
        PsiFile psiFile = this.activity.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        PsiImportList psiImportList = ((PsiJavaFile)psiFile).getImportList();
        if (psiImportList == null) {
            return;
        }
        PsiImportList importList = psiImportList;
        for (String importClass : InsertCodeHandler.Companion.getIMPORT_CLASSES_LIST$url_assistant()) {
            if (ImportUtils.hasOnDemandImportConflict((String)importClass, (PsiElement)((PsiElement)this.activity)) || !ImportUtils.nameCanBeImported((String)importClass, (PsiElement)((PsiElement)this.activity)) || this.hasImportStatement(importList, importClass)) continue;
            String dummyFileName = "_Dummy_" + importClass + "_." + JavaFileType.INSTANCE.getDefaultExtension();
            PsiFile psiFile2 = PsiFileFactory.getInstance((Project)this.project).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + importClass + ";"));
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
            PsiJavaFile aFile = (PsiJavaFile)psiFile2;
            PsiImportList dummyImportList = aFile.getImportList();
            if (dummyImportList == null) continue;
            PsiImportStatement[] statements = dummyImportList.getImportStatements();
            importList.add((PsiElement)statements[0]);
        }
    }

    private final Pair<PsiElement, PsiElement> maybeAddStatementsToMethod() {
        if (this.activityOnCreateMethod == null) {
            return null;
        }
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)((Language)JavaLanguage.INSTANCE), (Project)this.project);
        if (elementFactory == null) {
            elementFactory = (JVMElementFactory)JavaPsiFacade.getElementFactory((Project)this.project);
        }
        JVMElementFactory jVMElementFactory = elementFactory;
        Intrinsics.checkNotNull((Object)jVMElementFactory, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElementFactory");
        elementFactory = (JVMElementFactory)((PsiElementFactory)jVMElementFactory);
        PsiElement endElement = null;
        PsiComment it = ((PsiElementFactory)elementFactory).createCommentFromText("// ATTENTION: This was auto-generated to handle app links.", null);
        boolean bl = false;
        PsiElement beginElement = this.activityOnCreateMethod.add((PsiElement)it);
        for (String statement : STATEMENTS_LIST) {
            PsiStatement myStatement;
            PsiElement element;
            List<PsiStatement> myStatements;
            Intrinsics.checkNotNullExpressionValue(StatementFilter.filterCodeBlock(statement, this.activityOnCreateMethod), (String)"filterCodeBlock(statement, activityOnCreateMethod)");
            if (!myStatements.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiElementFactory)elementFactory).createStatementFromText(statement, null), (String)"elementFactory.createSta\u2026FromText(statement, null)");
            endElement = element = this.activityOnCreateMethod.add((PsiElement)myStatement);
        }
        return Pair.create((Object)beginElement, endElement);
    }

    private final boolean hasImportStatement(PsiImportList importList, String className) {
        String string = className.substring(0, StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String packageName = string;
        PsiImportStatement singleImport = importList.findSingleClassImportStatement(className);
        PsiImportStatement onDemandImport = importList.findOnDemandImportStatement(packageName);
        return singleImport != null || onDemandImport != null;
    }

    private final PsiCodeBlock getOnCreate() {
        PsiMethod[] psiMethods = this.activity.findMethodsByName("onCreate", false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethods, (String)"psiMethods");
        for (PsiMethod psiMethod : psiMethods) {
            PsiType[] types = psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes();
            if (types.length != 1 || !ON_CREATE_POSSIBLE_PARAM_TYPES.contains(types[0].getCanonicalText())) continue;
            return psiMethod.getBody();
        }
        return null;
    }

    public static final /* synthetic */ Project access$getProject$p(InsertJavaCodeHandler $this) {
        return $this.project;
    }

    public static final /* synthetic */ Pair access$maybeAddStatementsToMethod(InsertJavaCodeHandler $this) {
        return $this.maybeAddStatementsToMethod();
    }

    public static final /* synthetic */ void access$maybeInsertImportList(InsertJavaCodeHandler $this) {
        $this.maybeInsertImportList();
    }

    static {
        Object[] objectArray = new String[]{"android.os.Bundle", "Bundle"};
        ON_CREATE_POSSIBLE_PARAM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"Intent appLinkIntent = getIntent();", "String appLinkAction = appLinkIntent.getAction();", "Uri appLinkData = appLinkIntent.getData();"};
        STATEMENTS_LIST = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/urlassistant/util/InsertJavaCodeHandler$Companion;", "", "()V", "ON_CREATE_POSSIBLE_PARAM_TYPES", "", "", "STATEMENTS_LIST", "", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

