/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models.digitalassetlink;

import com.android.tools.idea.gradle.model.IdeSigningConfig;
import com.google.urlassistant.ui.models.digitalassetlink.ErrorMessageListener;
import com.google.urlassistant.ui.models.digitalassetlink.FingerprintSelectionMethod;
import com.google.urlassistant.ui.models.digitalassetlink.KeystoreAliasModelListener;
import com.google.urlassistant.ui.models.digitalassetlink.ShowKeystorePasswordBoxListener;
import com.google.urlassistant.util.DalUtils;
import com.google.urlassistant.util.Sha256FingerprintUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 F2\u00020\u0001:\u0001FB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0010J\u000e\u0010<\u001a\u00020:2\u0006\u0010;\u001a\u00020 J\u000e\u0010=\u001a\u00020:2\u0006\u0010;\u001a\u000205J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00060?H\u0002J\b\u0010@\u001a\u00020\u0006H\u0002J\u0006\u0010A\u001a\u00020:J\u0006\u0010B\u001a\u00020:J\b\u0010C\u001a\u00020:H\u0002J\u0006\u0010D\u001a\u00020:J\b\u0010E\u001a\u00020:H\u0002R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u000bR\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R7\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R$\u0010*\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\t\"\u0004\b,\u0010\u000bR+\u0010.\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020-8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\r\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0019\u00a8\u0006G"}, d2={"Lcom/google/urlassistant/ui/models/digitalassetlink/FingerprintSelectionModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "<set-?>", "", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "setErrorMessage", "(Ljava/lang/String;)V", "errorMessage$delegate", "Lkotlin/properties/ReadWriteProperty;", "errorMessageListeners", "", "Lcom/google/urlassistant/ui/models/digitalassetlink/ErrorMessageListener;", "fingerprint", "getFingerprint", "setFingerprint", "fingerprintSelectionMethods", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/google/urlassistant/ui/models/digitalassetlink/FingerprintSelectionMethod;", "kotlin.jvm.PlatformType", "getFingerprintSelectionMethods", "()Ljavax/swing/DefaultComboBoxModel;", "keystoreAliases", "getKeystoreAliases", "setKeystoreAliases", "(Ljavax/swing/DefaultComboBoxModel;)V", "keystoreAliases$delegate", "keystoreAliasesListeners", "Lcom/google/urlassistant/ui/models/digitalassetlink/KeystoreAliasModelListener;", "value", "", "keystorePassword", "getKeystorePassword", "()[C", "setKeystorePassword", "([C)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "pathToLocalKeystore", "getPathToLocalKeystore", "setPathToLocalKeystore", "", "showKeystorePasswordBox", "getShowKeystorePasswordBox", "()Z", "setShowKeystorePasswordBox", "(Z)V", "showKeystorePasswordBox$delegate", "showKeystorePasswordBoxListeners", "Lcom/google/urlassistant/ui/models/digitalassetlink/ShowKeystorePasswordBoxListener;", "signingKeyConfigs", "Lcom/android/tools/idea/gradle/model/IdeSigningConfig;", "getSigningKeyConfigs", "addErrorMessageListener", "", "listener", "addKeystoreAliasesListener", "addShowKeystorePasswordBoxListener", "getAliasesOrThrowException", "", "getFingerprintOrThrowException", "onAliasSelection", "onAndroidStudioSigningKeyConfigSelection", "onKeystorePathChange", "onLocalKeystoreSelection", "onPasswordChange", "Companion", "url-assistant"})
public final class FingerprintSelectionModel {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Module module;
    @NotNull
    private final DefaultComboBoxModel<FingerprintSelectionMethod> fingerprintSelectionMethods;
    @NotNull
    private final DefaultComboBoxModel<IdeSigningConfig> signingKeyConfigs;
    @NotNull
    private String pathToLocalKeystore;
    @NotNull
    private char[] keystorePassword;
    @NotNull
    private String fingerprint;
    @NotNull
    private final List<KeystoreAliasModelListener> keystoreAliasesListeners;
    @NotNull
    private final ReadWriteProperty keystoreAliases$delegate;
    @NotNull
    private final List<ErrorMessageListener> errorMessageListeners;
    @NotNull
    private final ReadWriteProperty errorMessage$delegate;
    @NotNull
    private final List<ShowKeystorePasswordBoxListener> showKeystorePasswordBoxListeners;
    @NotNull
    private final ReadWriteProperty showKeystorePasswordBox$delegate;
    @NotNull
    private static final Logger LOGGER;
    private static final String ANDROID_STUDIO_SIGNING_KEY_CONFIG_LABEL;
    private static final String LOCAL_KEYSTORE_LABEL;
    private static final String ENTER_MANUALLY_LABEL;
    @NotNull
    private static final List<FingerprintSelectionMethod> FINGERPRINT_SELECTION_METHOD_OPTIONS;

    public FingerprintSelectionModel(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Collection $this$toTypedArray$iv = FINGERPRINT_SELECTION_METHOD_OPTIONS;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.fingerprintSelectionMethods = new DefaultComboBoxModel<FingerprintSelectionMethod>(thisCollection$iv.toArray(new FingerprintSelectionMethod[0]));
        this.signingKeyConfigs = new DefaultComboBoxModel();
        this.pathToLocalKeystore = "";
        this.keystorePassword = new char[0];
        this.fingerprint = "";
        this.keystoreAliasesListeners = new ArrayList();
        $this$toTypedArray$iv = Delegates.INSTANCE;
        Object initialValue$iv = new DefaultComboBoxModel();
        boolean $i$f$observable = false;
        this.keystoreAliases$delegate = (ReadWriteProperty)new ObservableProperty<DefaultComboBoxModel<String>>(initialValue$iv, this){
            final /* synthetic */ FingerprintSelectionModel this$0;
            {
                this.this$0 = fingerprintSelectionModel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)newValue;
                DefaultComboBoxModel oldValue2 = (DefaultComboBoxModel)oldValue;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldValue2, (Object)newValue2)) {
                    Iterable $this$forEach$iv = FingerprintSelectionModel.access$getKeystoreAliasesListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KeystoreAliasModelListener it = (KeystoreAliasModelListener)element$iv;
                        boolean bl2 = false;
                        it.onChange(newValue2);
                    }
                }
            }
        };
        this.errorMessageListeners = new ArrayList();
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = "";
        $i$f$observable = false;
        this.errorMessage$delegate = (ReadWriteProperty)new ObservableProperty<String>(initialValue$iv, this){
            final /* synthetic */ FingerprintSelectionModel this$0;
            {
                this.this$0 = fingerprintSelectionModel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                String string = (String)newValue;
                String oldValue2 = (String)oldValue;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldValue2, (Object)newValue2)) {
                    Iterable $this$forEach$iv = FingerprintSelectionModel.access$getErrorMessageListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ErrorMessageListener it = (ErrorMessageListener)element$iv;
                        boolean bl2 = false;
                        it.onChange(newValue2);
                    }
                }
            }
        };
        this.showKeystorePasswordBoxListeners = new ArrayList();
        this_$iv = Delegates.INSTANCE;
        initialValue$iv = false;
        $i$f$observable = false;
        this.showKeystorePasswordBox$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>(initialValue$iv, this){
            final /* synthetic */ FingerprintSelectionModel this$0;
            {
                this.this$0 = fingerprintSelectionModel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean oldValue2 = (Boolean)oldValue;
                boolean bl2 = false;
                if (oldValue2 != newValue2) {
                    Iterable $this$forEach$iv = FingerprintSelectionModel.access$getShowKeystorePasswordBoxListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ShowKeystorePasswordBoxListener it = (ShowKeystorePasswordBoxListener)element$iv;
                        boolean bl3 = false;
                        it.onChange((boolean)newValue2);
                    }
                }
            }
        };
        this.signingKeyConfigs.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void intervalRemoved(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void contentsChanged(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                try {
                    Object object = this.getSigningKeyConfigs().getSelectedItem();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.model.IdeSigningConfig");
                    IdeSigningConfig signingConfig = (IdeSigningConfig)object;
                    File file = signingConfig.getStoreFile();
                    String string = Sha256FingerprintUtils.generateFingerprints(file != null ? file.getAbsolutePath() : null, signingConfig.getKeyAlias(), signingConfig.getStorePassword());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateFingerprints(sig\u2026ningConfig.storePassword)");
                    this.setFingerprint(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.getKeystoreAliases().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void intervalRemoved(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void contentsChanged(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.onAliasSelection();
            }
        });
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final DefaultComboBoxModel<FingerprintSelectionMethod> getFingerprintSelectionMethods() {
        return this.fingerprintSelectionMethods;
    }

    @NotNull
    public final DefaultComboBoxModel<IdeSigningConfig> getSigningKeyConfigs() {
        return this.signingKeyConfigs;
    }

    @NotNull
    public final String getPathToLocalKeystore() {
        return this.pathToLocalKeystore;
    }

    public final void setPathToLocalKeystore(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.pathToLocalKeystore, (Object)value)) {
            this.pathToLocalKeystore = value;
            this.onKeystorePathChange();
        }
    }

    @NotNull
    public final char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public final void setKeystorePassword(@NotNull char[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.keystorePassword, (Object)value)) {
            this.keystorePassword = value;
            this.onPasswordChange();
        }
    }

    @NotNull
    public final String getFingerprint() {
        return this.fingerprint;
    }

    public final void setFingerprint(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fingerprint = string;
    }

    @NotNull
    public final DefaultComboBoxModel<String> getKeystoreAliases() {
        return (DefaultComboBoxModel)this.keystoreAliases$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setKeystoreAliases(DefaultComboBoxModel<String> defaultComboBoxModel) {
        this.keystoreAliases$delegate.setValue((Object)this, $$delegatedProperties[0], defaultComboBoxModel);
    }

    @NotNull
    public final String getErrorMessage() {
        return (String)this.errorMessage$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setErrorMessage(String string) {
        this.errorMessage$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    public final boolean getShowKeystorePasswordBox() {
        return (Boolean)this.showKeystorePasswordBox$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setShowKeystorePasswordBox(boolean bl) {
        this.showKeystorePasswordBox$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    public final void onAndroidStudioSigningKeyConfigSelection() {
        this.setErrorMessage("");
        this.fingerprint = "";
        List signingConfigs = new ArrayList();
        try {
            DalUtils.loadSigningConfigsFromGradle(this.module, signingConfigs);
            this.signingKeyConfigs.removeAllElements();
            this.signingKeyConfigs.addAll(signingConfigs);
            if (!((Collection)signingConfigs).isEmpty()) {
                this.signingKeyConfigs.setSelectedItem(this.signingKeyConfigs.getElementAt(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void onLocalKeystoreSelection() {
        this.setErrorMessage("");
        this.fingerprint = "";
        if (!StringsKt.isBlank((CharSequence)this.pathToLocalKeystore)) {
            this.onKeystorePathChange();
            this.onAliasSelection();
        }
    }

    private final void onKeystorePathChange() {
        this.setKeystoreAliases(new DefaultComboBoxModel<String>(new String[0]));
        boolean shouldShowKeystorePasswordBox = !(this.keystorePassword.length == 0);
        try {
            List<String> aliases = this.getAliasesOrThrowException();
            Collection $this$toTypedArray$iv = aliases;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.setKeystoreAliases(new DefaultComboBoxModel<String>(thisCollection$iv.toArray(new String[0])));
            this.onAliasSelection();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.not.found\")");
            this.setErrorMessage(string);
        }
        catch (Sha256FingerprintUtils.WrongPasswordException e) {
            shouldShowKeystorePasswordBox = true;
            String string = UrlAssistantBundle.message("dal.keystore.check.password", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.check.password\")");
            this.setErrorMessage(string);
        }
        catch (Exception e) {
            String string = UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.generate.fingerprint.fail\")");
            this.setErrorMessage(string);
        }
        this.setShowKeystorePasswordBox(shouldShowKeystorePasswordBox);
    }

    public final void onAliasSelection() {
        boolean shouldShowKeystorePasswordBox = !(this.keystorePassword.length == 0);
        try {
            this.fingerprint = this.getFingerprintOrThrowException();
            this.setErrorMessage("");
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.not.found\")");
            this.setErrorMessage(string);
        }
        catch (Sha256FingerprintUtils.WrongPasswordException e) {
            shouldShowKeystorePasswordBox = true;
            String string = UrlAssistantBundle.message("dal.keystore.check.password", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.check.password\")");
            this.setErrorMessage(string);
        }
        catch (Exception e) {
            String string = UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.generate.fingerprint.fail\")");
            this.setErrorMessage(string);
        }
        this.setShowKeystorePasswordBox(shouldShowKeystorePasswordBox);
    }

    private final void onPasswordChange() {
        try {
            this.fingerprint = this.getFingerprintOrThrowException();
            this.setErrorMessage("");
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.not.found\")");
            this.setErrorMessage(string);
        }
        catch (Sha256FingerprintUtils.WrongPasswordException e) {
            String string = UrlAssistantBundle.message("dal.keystore.check.password", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.check.password\")");
            this.setErrorMessage(string);
        }
        catch (Exception e) {
            String string = UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dal.keystore.generate.fingerprint.fail\")");
            this.setErrorMessage(string);
        }
    }

    private final List<String> getAliasesOrThrowException() {
        List<String> list;
        try {
            List<String> list2 = Sha256FingerprintUtils.getAliasesOrThrowException(this.pathToLocalKeystore, null);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n      Sha256Fingerprin\u2026ocalKeystore, null)\n    }");
            list = list2;
        }
        catch (Sha256FingerprintUtils.WrongPasswordException e) {
            List<String> list3 = Sha256FingerprintUtils.getAliasesOrThrowException(this.pathToLocalKeystore, this.keystorePassword);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"{\n      Sha256Fingerprin\u2026, keystorePassword)\n    }");
            list = list3;
        }
        return list;
    }

    private final String getFingerprintOrThrowException() {
        String string;
        try {
            Object object = this.getKeystoreAliases().getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = Sha256FingerprintUtils.generateFingerprintsOrThrowException(this.pathToLocalKeystore, (String)object, null);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      Sha256Fingerprin\u2026em as String, null)\n    }");
        }
        catch (Sha256FingerprintUtils.WrongPasswordException e) {
            Object object = this.getKeystoreAliases().getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = Sha256FingerprintUtils.generateFingerprintsOrThrowException(this.pathToLocalKeystore, (String)object, new String(this.keystorePassword));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      Sha256Fingerprin\u2026(keystorePassword))\n    }");
            string = string2;
        }
        return string;
    }

    public final void addKeystoreAliasesListener(@NotNull KeystoreAliasModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.keystoreAliasesListeners.add(listener);
    }

    public final void addErrorMessageListener(@NotNull ErrorMessageListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.errorMessageListeners.add(listener);
    }

    public final void addShowKeystorePasswordBoxListener(@NotNull ShowKeystorePasswordBoxListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.showKeystorePasswordBoxListeners.add(listener);
    }

    public static final /* synthetic */ List access$getKeystoreAliasesListeners$p(FingerprintSelectionModel $this) {
        return $this.keystoreAliasesListeners;
    }

    public static final /* synthetic */ List access$getErrorMessageListeners$p(FingerprintSelectionModel $this) {
        return $this.errorMessageListeners;
    }

    public static final /* synthetic */ List access$getShowKeystorePasswordBoxListeners$p(FingerprintSelectionModel $this) {
        return $this.showKeystorePasswordBoxListeners;
    }

    static {
        Object[] objectArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FingerprintSelectionModel.class, "keystoreAliases", "getKeystoreAliases()Ljavax/swing/DefaultComboBoxModel;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FingerprintSelectionModel.class, "errorMessage", "getErrorMessage()Ljava/lang/String;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FingerprintSelectionModel.class, "showKeystorePasswordBox", "getShowKeystorePasswordBox()Z", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FingerprintSelectionModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FingerprintSelectionModel::class.java)");
        LOGGER = logger;
        ANDROID_STUDIO_SIGNING_KEY_CONFIG_LABEL = UrlAssistantBundle.message("dal.android.studio.signing.key.config", new Object[0]);
        LOCAL_KEYSTORE_LABEL = UrlAssistantBundle.message("dal.local.keystore", new Object[0]);
        ENTER_MANUALLY_LABEL = UrlAssistantBundle.message("dal.enter.manually", new Object[0]);
        objectArray = new FingerprintSelectionMethod[3];
        String string = ANDROID_STUDIO_SIGNING_KEY_CONFIG_LABEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_STUDIO_SIGNING_KEY_CONFIG_LABEL");
        objectArray[0] = new FingerprintSelectionMethod(string, CollectionsKt.emptyList());
        String string2 = LOCAL_KEYSTORE_LABEL;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LOCAL_KEYSTORE_LABEL");
        objectArray[1] = new FingerprintSelectionMethod(string2, CollectionsKt.emptyList());
        String string3 = ENTER_MANUALLY_LABEL;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ENTER_MANUALLY_LABEL");
        objectArray[2] = new FingerprintSelectionMethod(string3, CollectionsKt.emptyList());
        FINGERPRINT_SELECTION_METHOD_OPTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/urlassistant/ui/models/digitalassetlink/FingerprintSelectionModel$Companion;", "", "()V", "ANDROID_STUDIO_SIGNING_KEY_CONFIG_LABEL", "", "kotlin.jvm.PlatformType", "ENTER_MANUALLY_LABEL", "FINGERPRINT_SELECTION_METHOD_OPTIONS", "", "Lcom/google/urlassistant/ui/models/digitalassetlink/FingerprintSelectionMethod;", "getFINGERPRINT_SELECTION_METHOD_OPTIONS", "()Ljava/util/List;", "LOCAL_KEYSTORE_LABEL", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FingerprintSelectionMethod> getFINGERPRINT_SELECTION_METHOD_OPTIONS() {
            return FINGERPRINT_SELECTION_METHOD_OPTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

