/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\"\u0010*\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020,H\u0016R\u001a\u0010\f\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/google/urlassistant/ui/UrlAssistantWindowWithHeader;", "Ljavax/swing/JPanel;", "Lcom/google/urlassistant/editor/UrlAssistantWindowBase;", "Ljavax/swing/Scrollable;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "description", "stepNumber", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;I)V", "contentPanel", "getContentPanel", "()Ljavax/swing/JPanel;", "setContentPanel", "(Ljavax/swing/JPanel;)V", "defaultSpaceAmount", "getDefaultSpaceAmount", "()I", "grayTextColor", "Lcom/intellij/ui/JBColor;", "rootPanel", "getRootPanel", "setRootPanel", "stepToIcon", "", "Ljavax/swing/ImageIcon;", "verticalInsets", "Ljava/awt/Insets;", "asPanel", "Ljavax/swing/JComponent;", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableBlockIncrement", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableTracksViewportHeight", "", "getScrollableTracksViewportWidth", "getScrollableUnitIncrement", "selectNotify", "", "url-assistant"})
public class UrlAssistantWindowWithHeader
extends JPanel
implements UrlAssistantWindowBase,
Scrollable {
    @NotNull
    private final Project project;
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    private final int stepNumber;
    @NotNull
    private JPanel rootPanel;
    @NotNull
    private JPanel contentPanel;
    @NotNull
    private final Insets verticalInsets;
    @NotNull
    private final JBColor grayTextColor;
    @NotNull
    private final Map<Integer, ImageIcon> stepToIcon;

    public UrlAssistantWindowWithHeader(@NotNull Project project, @NotNull String title, @NotNull String description, int stepNumber) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(new BorderLayout());
        this.project = project;
        this.title = title;
        this.description = description;
        this.stepNumber = stepNumber;
        this.rootPanel = new JPanel(new GridBagLayout());
        this.contentPanel = new JPanel(new GridBagLayout());
        this.verticalInsets = new Insets(this.getDefaultSpaceAmount(), 0, this.getDefaultSpaceAmount(), 0);
        this.grayTextColor = new JBColor((Color)Gray._80, (Color)Gray._156);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_one.png"))), TuplesKt.to((Object)3, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_three.png"))), TuplesKt.to((Object)4, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_four.png")))};
        this.stepToIcon = MapsKt.mapOf((Pair[])pairArray);
        this.rootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.rootPanel.setFocusCycleRoot(true);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        JBLabel titleLabel = new JBLabel(this.title);
        titleLabel.setFont(titleLabel.getFont().deriveFont(22.0f));
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
        JBTextArea descriptionTextArea = UiUtils.INSTANCE.createMultilineText(this.description, color);
        JBLabel smallTitleLabel = new JBLabel(UrlAssistantBundle.message("url.assistant.toolwindow.smalltitle", new Object[0]));
        smallTitleLabel.setFont(smallTitleLabel.getFont().deriveFont(12.0f));
        smallTitleLabel.setForeground((Color)this.grayTextColor);
        JBLabel stepIcon = new JBLabel("");
        stepIcon.setIcon((Icon)this.stepToIcon.get(this.stepNumber));
        stepIcon.setIconTextGap(6);
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 30, 30));
        this.add(this.rootPanel);
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component = headerPanel;
        JPanel jPanel = this.rootPanel;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.gridy = 0;
        $this$_init__u24lambda_u2d0.gridx = 0;
        $this$_init__u24lambda_u2d0.anchor = 11;
        $this$_init__u24lambda_u2d0.fill = 2;
        $this$_init__u24lambda_u2d0.weightx = 1.0;
        Unit unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d0 = gridBagConstraints = new GridBagConstraints();
        component = (Component)stepIcon;
        jPanel = headerPanel;
        boolean bl2 = false;
        $this$_init__u24lambda_u2d1.gridy = 0;
        $this$_init__u24lambda_u2d1.gridx = 0;
        $this$_init__u24lambda_u2d1.gridheight = 2;
        $this$_init__u24lambda_u2d1.insets = new Insets(0, 0, 0, this.getDefaultSpaceAmount());
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d1 = gridBagConstraints = new GridBagConstraints();
        component = (Component)smallTitleLabel;
        jPanel = headerPanel;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d2.gridy = 0;
        $this$_init__u24lambda_u2d2.gridx = 1;
        $this$_init__u24lambda_u2d2.anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d2 = gridBagConstraints = new GridBagConstraints();
        component = (Component)titleLabel;
        jPanel = headerPanel;
        boolean bl4 = false;
        $this$_init__u24lambda_u2d3.gridy = 1;
        $this$_init__u24lambda_u2d3.gridx = 1;
        $this$_init__u24lambda_u2d3.anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d3 = gridBagConstraints = new GridBagConstraints();
        component = (Component)new Spacer();
        jPanel = headerPanel;
        boolean bl5 = false;
        $this$_init__u24lambda_u2d4.gridy = 0;
        $this$_init__u24lambda_u2d4.gridx = 2;
        $this$_init__u24lambda_u2d4.gridheight = 2;
        $this$_init__u24lambda_u2d4.fill = 2;
        $this$_init__u24lambda_u2d4.weightx = 1.0;
        $this$_init__u24lambda_u2d4.weighty = 1.0;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d4 = gridBagConstraints = new GridBagConstraints();
        component = (Component)descriptionTextArea;
        jPanel = headerPanel;
        boolean bl6 = false;
        $this$_init__u24lambda_u2d5.gridy = 3;
        $this$_init__u24lambda_u2d5.gridx = 0;
        $this$_init__u24lambda_u2d5.gridwidth = 3;
        $this$_init__u24lambda_u2d5.anchor = 17;
        $this$_init__u24lambda_u2d5.fill = 2;
        $this$_init__u24lambda_u2d5.weightx = 1.0;
        $this$_init__u24lambda_u2d5.weighty = 0.5;
        $this$_init__u24lambda_u2d5.insets = this.verticalInsets;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u2d5 = gridBagConstraints = new GridBagConstraints();
        component = new JSeparator();
        jPanel = headerPanel;
        boolean bl7 = false;
        $this$_init__u24lambda_u2d6.gridy = 5;
        $this$_init__u24lambda_u2d6.gridx = 0;
        $this$_init__u24lambda_u2d6.gridwidth = 3;
        $this$_init__u24lambda_u2d6.fill = 2;
        $this$_init__u24lambda_u2d6.weightx = 0.5;
        $this$_init__u24lambda_u2d6.weighty = 0.5;
        $this$_init__u24lambda_u2d6.insets = this.verticalInsets;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        this.rootPanel.add((Component)this.contentPanel, UiUtils.INSTANCE.createConstraintsForExpander(1, 0));
    }

    @NotNull
    protected final JPanel getRootPanel() {
        return this.rootPanel;
    }

    protected final void setRootPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.rootPanel = jPanel;
    }

    @NotNull
    protected final JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected final void setContentPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.contentPanel = jPanel;
    }

    private final int getDefaultSpaceAmount() {
        return JBUIScale.scale((int)10);
    }

    @Override
    public void selectNotify() {
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.rootPanel.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"rootPanel.preferredSize");
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return JBUIScale.scale((int)10);
    }

    @Override
    public int getScrollableBlockIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return JBUIScale.scale((int)10);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

