/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.editor;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlAssistantVirtualFile
extends LightVirtualFile {
    private Project myProject;

    public UrlAssistantVirtualFile(@NotNull Project project, @NotNull String name) {
        super(name);
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        return UrlAssistantVirtualFileBaseType.INSTANCE;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    public static UrlAssistantVirtualFile createVirtualFile(Project project, String name) {
        return new UrlAssistantVirtualFile(project, name);
    }

    private static class UrlAssistantVirtualFileBaseType
    extends FakeFileType {
        public static final UrlAssistantVirtualFileBaseType INSTANCE = new UrlAssistantVirtualFileBaseType();

        private UrlAssistantVirtualFileBaseType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            return file.getFileType() instanceof UrlAssistantVirtualFileBaseType;
        }

        @NotNull
        public String getName() {
            return "UrlAssistantVirtualFileType";
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return StudioIcons.Common.LINK;
        }
    }
}

