/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.google.urlassistant.editor.UrlAssistantVirtualFile;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.AppLinkTestingWindow;
import com.google.urlassistant.ui.DigitalAssetLinkWindow;
import com.google.urlassistant.ui.DigitalAssetLinkWindowLegacy;
import com.google.urlassistant.ui.UrlAssistantWindow;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlAssistantFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final UrlAssistantVirtualFile myFile;
    private JLayer<JBScrollPane> myJLayer;
    private UrlAssistantWindowBase myMainWindow;
    private final Project myProject;

    public UrlAssistantFileEditor(@NotNull Project project, @NotNull UrlAssistantVirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myMainWindow = this.createWindow();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myMainWindow.asPanel());
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.myJLayer = new JLayer<JBScrollPane>(scrollPane, new WheelScrollLayerUI());
    }

    private UrlAssistantWindowBase createWindow() {
        String fileName = this.myFile.getName();
        if (UrlAssistantBundle.message("test.url.launch.url.panel.title", new Object[0]).equals(fileName)) {
            return new AppLinkTestingWindow(this.myProject, (Disposable)this);
        }
        if (UrlAssistantBundle.message("dal.title", new Object[0]).equals(fileName)) {
            if (((Boolean)StudioFlags.WEBSITE_ASSOCIATION_GENERATOR_V2.get()).booleanValue()) {
                return new DigitalAssetLinkWindow(this.myProject, (Disposable)this);
            }
            return new DigitalAssetLinkWindowLegacy(this.myProject, (Disposable)this);
        }
        if (UrlAssistantBundle.message("url.assistant.editor.title", new Object[0]).equals(fileName)) {
            return new UrlAssistantWindow(this.myProject, (Disposable)this);
        }
        throw new AssertionError((Object)("Invalid name of Url Assistant Window: " + fileName));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myJLayer;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myJLayer;
    }

    @NotNull
    public String getName() {
        return UrlAssistantBundle.message("url.assistant.editor.title", new Object[0]);
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel fileEditorStateLevel) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myMainWindow.selectNotify();
    }

    public void deselectNotify() {
        this.myMainWindow.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public void dispose() {
        this.myMainWindow.dispose();
    }

    static class WheelScrollLayerUI
    extends LayerUI<JBScrollPane> {
        WheelScrollLayerUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(131072L);
            }
        }

        @Override
        public void uninstallUI(JComponent c) {
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(0L);
            }
            super.uninstallUI(c);
        }

        @Override
        protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends JBScrollPane> l) {
            Component c = e.getComponent();
            int direction = e.getWheelRotation();
            JBScrollPane main = l.getView();
            if (c instanceof JBScrollPane && !c.equals(main)) {
                JBScrollPane child = (JBScrollPane)c;
                BoundedRangeModel m = child.getVerticalScrollBar().getModel();
                int extent = m.getExtent();
                int minimum = m.getMinimum();
                int maximum = m.getMaximum();
                int value = m.getValue();
                if (direction > 0 && value >= maximum - extent || direction < 0 && value <= minimum) {
                    main.dispatchEvent((AWTEvent)SwingUtilities.convertMouseEvent(c, e, (Component)main));
                }
            }
        }
    }
}

