#ifndef HEXAGON_TCG_FUNCS_H
#define HEXAGON_TCG_FUNCS_H

static void generate_J2_jump(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jump(cpu_env, tcgv_riV);
}

static void generate_J2_jumpr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    gen_helper_J2_jumpr(cpu_env, RsV);
}

static void generate_J2_jumpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumpt(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_jumpf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumpf(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_jumptpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumptpt(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_jumpfpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumpfpt(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_jumprt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprt(cpu_env, PuV, RsV);
}

static void generate_J2_jumprf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprf(cpu_env, PuV, RsV);
}

static void generate_J2_jumprtpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprtpt(cpu_env, PuV, RsV);
}

static void generate_J2_jumprfpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprfpt(cpu_env, PuV, RsV);
}

static void generate_J2_jumptnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumptnew(cpu_env, PuN, tcgv_riV);
}

static void generate_J2_jumpfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumpfnew(cpu_env, PuN, tcgv_riV);
}

static void generate_J2_jumptnewpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumptnewpt(cpu_env, PuN, tcgv_riV);
}

static void generate_J2_jumpfnewpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumpfnewpt(cpu_env, PuN, tcgv_riV);
}

static void generate_J2_jumprtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprtnew(cpu_env, PuN, RsV);
}

static void generate_J2_jumprfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprfnew(cpu_env, PuN, RsV);
}

static void generate_J2_jumprtnewpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprtnewpt(cpu_env, PuN, RsV);
}

static void generate_J2_jumprfnewpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_jumprfnewpt(cpu_env, PuN, RsV);
}

static void generate_J4_hintjumpr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    gen_helper_J4_hintjumpr(cpu_env, RsV);
}

static void generate_J2_jumprz(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprz(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprnz(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprnz(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprzpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprzpt(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprnzpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprnzpt(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprgtez(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprgtez(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprgtezpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprgtezpt(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprltez(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprltez(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_jumprltezpt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_jumprltezpt(cpu_env, RsV, tcgv_riV);
}

static void generate_J4_cmpeqi_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_tp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_fp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_tp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_fp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_tp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_fp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_tp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqi_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqi_fp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_tp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_fp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_tp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_fp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_tp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_fp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_tp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgti_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgti_fp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_tp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_fp0_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_tp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_fp0_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_tp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_fp1_jump_nt(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_tp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpgtui_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtui_fp1_jump_t(cpu_env, RsV, tcgv_UiV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_tp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_fp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_tp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_fp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_tp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_fp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_tp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeqn1_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeqn1_fp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_tp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_fp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_tp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_fp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_tp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_fp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_tp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpgtn1_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtn1_fp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_tp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_fp0_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_tp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_fp0_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_tp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_fp1_jump_nt(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_tp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_tstbit0_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_tstbit0_fp1_jump_t(cpu_env, RsV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_tp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_fp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_tp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_fp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_tp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_fp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_tp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpeq_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpeq_fp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_tp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_fp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_tp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_fp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_tp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_fp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_tp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgt_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgt_fp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_tp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_tp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_fp0_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_fp0_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_tp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_tp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_fp0_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_fp0_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_tp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_tp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_fp1_jump_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_fp1_jump_nt(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_tp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_tp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_cmpgtu_fp1_jump_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv part1 = tcg_constant_tl(insn->part1);
    gen_helper_J4_cmpgtu_fp1_jump_t(cpu_env, RsV, RtV, tcgv_riV, part1);
}

static void generate_J4_jumpseti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J4_jumpseti(RdV, cpu_env, tcgv_UiV, tcgv_riV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_J4_jumpsetr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J4_jumpsetr(RdV, cpu_env, RsV, tcgv_riV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_J4_cmpeqi_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqi_t_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpeqi_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqi_t_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpeqi_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqi_f_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpeqi_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqi_f_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgti_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgti_t_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgti_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgti_t_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgti_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgti_f_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgti_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgti_f_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgtui_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtui_t_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgtui_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtui_t_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgtui_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtui_f_jumpnv_t(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpgtui_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtui_f_jumpnv_nt(cpu_env, NsN, tcgv_UiV, tcgv_riV, slot);
}

static void generate_J4_cmpeqn1_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqn1_t_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpeqn1_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqn1_t_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpeqn1_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqn1_f_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpeqn1_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeqn1_f_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpgtn1_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtn1_t_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpgtn1_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtn1_t_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpgtn1_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtn1_f_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpgtn1_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtn1_f_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_tstbit0_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_tstbit0_t_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_tstbit0_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_tstbit0_t_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_tstbit0_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_tstbit0_f_jumpnv_t(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_tstbit0_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_tstbit0_f_jumpnv_nt(cpu_env, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpeq_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeq_t_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpeq_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeq_t_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgt_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgt_t_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgt_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgt_t_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgtu_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtu_t_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgtu_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtu_t_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmplt_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmplt_t_jumpnv_t(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmplt_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmplt_t_jumpnv_nt(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpltu_t_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpltu_t_jumpnv_t(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpltu_t_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpltu_t_jumpnv_nt(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpeq_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeq_f_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpeq_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpeq_f_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgt_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgt_f_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgt_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgt_f_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgtu_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtu_f_jumpnv_t(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmpgtu_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv NsN = hex_new_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpgtu_f_jumpnv_nt(cpu_env, NsN, RtV, tcgv_riV, slot);
}

static void generate_J4_cmplt_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmplt_f_jumpnv_t(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmplt_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmplt_f_jumpnv_nt(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpltu_f_jumpnv_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpltu_f_jumpnv_t(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J4_cmpltu_f_jumpnv_nt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RtV = hex_gpr[insn->regno[0]];
    TCGv NsN = hex_new_value[insn->regno[1]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_J4_cmpltu_f_jumpnv_nt(cpu_env, RtV, NsN, tcgv_riV, slot);
}

static void generate_J2_call(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_call(cpu_env, tcgv_riV);
}

static void generate_J2_callt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_callt(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_callf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_callf(cpu_env, PuV, tcgv_riV);
}

static void generate_J2_callr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    gen_helper_J2_callr(cpu_env, RsV);
}

static void generate_J2_callrt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_callrt(cpu_env, PuV, RsV);
}

static void generate_J2_callrf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_J2_callrf(cpu_env, PuV, RsV);
}

static void generate_J2_loop0r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_loop0r(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_loop1r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_loop1r(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_loop0i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_J2_loop0i(cpu_env, tcgv_riV, tcgv_UiV);
}

static void generate_J2_loop1i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_J2_loop1i(cpu_env, tcgv_riV, tcgv_UiV);
}

static void generate_J2_ploop1sr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_ploop1sr(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_ploop1si(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_J2_ploop1si(cpu_env, tcgv_riV, tcgv_UiV);
}

static void generate_J2_ploop2sr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_ploop2sr(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_ploop2si(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_J2_ploop2si(cpu_env, tcgv_riV, tcgv_UiV);
}

static void generate_J2_ploop3sr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RsV = hex_gpr[insn->regno[0]];
    int riV = insn->immed[0];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    gen_helper_J2_ploop3sr(cpu_env, RsV, tcgv_riV);
}

static void generate_J2_ploop3si(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_riV = tcg_constant_tl(riV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_J2_ploop3si(cpu_env, tcgv_riV, tcgv_UiV);
}

static void generate_J2_endloop01(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    gen_helper_J2_endloop01(cpu_env);
}

static void generate_J2_endloop0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    gen_helper_J2_endloop0(cpu_env);
}

static void generate_J2_endloop1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    gen_helper_J2_endloop1(cpu_env);
}

static void generate_L2_loadrub_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrub_io(RdV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrub_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrub_ur(RdV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrub_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadrub_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,1,u,EA,RdV); ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadrub_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrub_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,1,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrub_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrub_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,1,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrub_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrub_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,1,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrub_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrub_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrub_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrub_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrb_io(RdV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrb_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrb_ur(RdV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrb_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadrb_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,1,s,EA,RdV); ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadrb_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrb_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,1,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrb_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrb_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,1,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrb_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrb_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,1,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrb_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrb_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrb_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrb_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadruh_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadruh_io(RdV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadruh_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadruh_ur(RdV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadruh_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadruh_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,2,u,EA,RdV); ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadruh_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadruh_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,2,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadruh_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadruh_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,2,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadruh_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadruh_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,2,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadruh_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadruh_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadruh_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadruh_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrh_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrh_io(RdV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrh_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrh_ur(RdV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrh_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadrh_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,2,s,EA,RdV); ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadrh_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrh_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,2,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrh_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrh_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,2,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrh_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrh_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,2,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrh_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrh_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrh_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrh_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,s,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadri_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadri_io(RdV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadri_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadri_ur(RdV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadri_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadri_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,4,u,EA,RdV); ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadri_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadri_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,4,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadri_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadri_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,4,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadri_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadri_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,4,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadri_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadri_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,4,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadri_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadri_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fLOAD(1,4,u,EA,RdV);});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrd_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrd_io(RddV, cpu_env, RsV, tcgv_siV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadrd_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrd_ur(RddV, cpu_env, RtV, tcgv_uiV, tcgv_UiV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadrd_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadrd_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); fLOAD(1,8,u,EA,RddV); ReV=UiV; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadrd_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrd_pr({fEA_REG(RxV); fPM_M(RxV,MuV); fLOAD(1,8,u,EA,RddV);});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrd_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrd_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fLOAD(1,8,u,EA,RddV);});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrd_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrd_pi({fEA_REG(RxV); fPM_I(RxV,siV); fLOAD(1,8,u,EA,RddV);});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrd_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrd_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,8,u,EA,RddV);});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadrd_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadrd_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fLOAD(1,8,u,EA,RddV);});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw2_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    fGEN_TCG_L2_loadbzw2_io({fIMMEXT(siV); fEA_RI(RsV,siV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadbzw2_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbzw2_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadbzw2_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbzw2_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadbzw2_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw2_pr({fEA_REG(RxV); fPM_M(RxV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw2_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw2_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw2_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw2_pi({fEA_REG(RxV); fPM_I(RxV,siV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw2_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw2_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw2_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw2_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw4_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    fGEN_TCG_L2_loadbzw4_io({fIMMEXT(siV); fEA_RI(RsV,siV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadbzw4_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbzw4_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadbzw4_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbzw4_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadbzw4_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw4_pr({fEA_REG(RxV); fPM_M(RxV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw4_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw4_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw4_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw4_pi({fEA_REG(RxV); fPM_I(RxV,siV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw4_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw4_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbzw4_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbzw4_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw2_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    fGEN_TCG_L2_loadbsw2_io({fIMMEXT(siV); fEA_RI(RsV,siV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadbsw2_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbsw2_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadbsw2_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbsw2_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; ReV=UiV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadbsw2_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw2_pr({fEA_REG(RxV); fPM_M(RxV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw2_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw2_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw2_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw2_pi({fEA_REG(RxV); fPM_I(RxV,siV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw2_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw2_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw2_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw2_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {fHIDE(size2u_t tmpV; int i;) fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw4_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    fGEN_TCG_L2_loadbsw4_io({fIMMEXT(siV); fEA_RI(RsV,siV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadbsw4_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbsw4_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_loadbsw4_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    fGEN_TCG_L4_loadbsw4_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; ReV=UiV; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadbsw4_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw4_pr({fEA_REG(RxV); fPM_M(RxV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw4_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw4_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw4_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw4_pi({fEA_REG(RxV); fPM_I(RxV,siV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw4_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw4_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadbsw4_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadbsw4_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {fHIDE(size4u_t tmpV; int i;) fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignh_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L2_loadalignh_io({fIMMEXT(siV); fEA_RI(RsV,siV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; });
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
}

static void generate_L4_loadalignh_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L4_loadalignh_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
}

static void generate_L4_loadalignh_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L4_loadalignh_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; ReV=UiV; });
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadalignh_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignh_pr({fEA_REG(RxV); fPM_M(RxV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignh_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignh_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignh_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignh_pi({fEA_REG(RxV); fPM_I(RxV,siV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignh_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignh_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignh_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignh_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L2_loadalignb_io({fIMMEXT(siV); fEA_RI(RsV,siV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; });
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
}

static void generate_L4_loadalignb_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L4_loadalignb_ur({fMUST_IMMEXT(UiV); fEA_IRs(UiV,RtV,uiV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
}

static void generate_L4_loadalignb_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[1];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    fGEN_TCG_L4_loadalignb_ap({fMUST_IMMEXT(UiV); fEA_IMM(UiV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; ReV=UiV; });
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(ReV);
}

static void generate_L2_loadalignb_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignb_pr({fEA_REG(RxV); fPM_M(RxV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignb_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignb_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignb_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignb_pi({fEA_REG(RxV); fPM_I(RxV,siV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignb_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignb_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_L2_loadalignb_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RyyV = tcg_temp_local_new_i64();
    const int RyyN = insn->regno[0];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    const int MuN = insn->regno[2];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    tcg_gen_concat_i32_i64(RyyV, hex_gpr[RyyN],
                                 hex_gpr[RyyN + 1]);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_loadalignb_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); { fHIDE(size8u_t tmpV;) fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };});
    gen_log_reg_write_pair(RyyN, RyyV);
    ctx_log_reg_write_pair(ctx, RyyN);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RyyV);
    tcg_temp_free(RxV);
}

static void generate_S2_storerb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerb_io(cpu_env, RsV, RtV, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerb_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerb_pi(RxV, cpu_env, RxV, RtV, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerb_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerb_ap(ReV, cpu_env, RtV, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerb_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerb_pr(RxV, cpu_env, RxV, MuV, RtV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerb_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerb_ur(cpu_env, RuV, RtV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerb_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerb_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerb_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerb_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerb_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerb_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerh_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerh_io(cpu_env, RsV, RtV, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerh_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerh_pi(RxV, cpu_env, RxV, RtV, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerh_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerh_ap(ReV, cpu_env, RtV, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerh_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerh_pr(RxV, cpu_env, RxV, MuV, RtV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerh_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerh_ur(cpu_env, RuV, RtV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerh_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerh_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV)); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerh_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerh_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerh_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerh_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerf_io(cpu_env, RsV, RtV, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerf_pi(RxV, cpu_env, RxV, RtV, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerf_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerf_ap(ReV, cpu_env, RtV, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerf_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerf_pr(RxV, cpu_env, RxV, MuV, RtV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerf_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerf_ur(cpu_env, RuV, RtV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerf_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerf_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV)); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerf_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerf_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerf_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerf_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storeri_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storeri_io(cpu_env, RsV, RtV, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storeri_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storeri_pi(RxV, cpu_env, RxV, RtV, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storeri_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeri_ap(ReV, cpu_env, RtV, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storeri_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storeri_pr(RxV, cpu_env, RxV, MuV, RtV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storeri_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeri_ur(cpu_env, RuV, RtV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storeri_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storeri_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,4,EA,RtV); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storeri_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storeri_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,RtV);});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storeri_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storeri_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,RtV);});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerd_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerd_io(cpu_env, RsV, RttV, tcgv_siV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerd_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerd_pi(RxV, cpu_env, RxV, RttV, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_storerd_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerd_ap(ReV, cpu_env, RttV, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerd_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerd_pr(RxV, cpu_env, RxV, MuV, RttV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_storerd_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerd_ur(cpu_env, RuV, RttV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerd_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_S2_storerd_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,8,EA,RttV); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerd_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_S2_storerd_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,8,EA,RttV);});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerd_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_S2_storerd_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fSTORE(1,8,EA,RttV);});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerinew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerinew_io(cpu_env, RsV, NtN, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerinew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerinew_pi(RxV, cpu_env, RxV, NtN, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerinew_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerinew_ap(ReV, cpu_env, NtN, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerinew_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerinew_pr(RxV, cpu_env, RxV, MuV, NtN, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerinew_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerinew_ur(cpu_env, RuV, NtN, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerinew_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerinew_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerinew_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerinew_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerinew_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerinew_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerbnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerbnew_io(cpu_env, RsV, NtN, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerbnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerbnew_pi(RxV, cpu_env, RxV, NtN, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerbnew_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerbnew_ap(ReV, cpu_env, NtN, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerbnew_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerbnew_pr(RxV, cpu_env, RxV, MuV, NtN, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerbnew_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerbnew_ur(cpu_env, RuV, NtN, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerbnew_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerbnew_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerbnew_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerbnew_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerbnew_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerbnew_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerhnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerhnew_io(cpu_env, RsV, NtN, tcgv_siV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerhnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerhnew_pi(RxV, cpu_env, RxV, NtN, tcgv_siV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerhnew_ap(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv ReV = tcg_temp_local_new();
    const int ReN = insn->regno[0];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int UiV = insn->immed[1];
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerhnew_ap(ReV, cpu_env, NtN, tcgv_UiV, slot);
    gen_log_reg_write(ReN, ReV);
    ctx_log_reg_write(ctx, ReN);
    tcg_temp_free(EA);
    tcg_temp_free(ReV);
}

static void generate_S2_storerhnew_pr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerhnew_pr(RxV, cpu_env, RxV, MuV, NtN, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_storerhnew_ur(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RuV = hex_gpr[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerhnew_ur(cpu_env, RuV, NtN, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerhnew_pbr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerhnew_pbr({fEA_BREVR(RxV); fPM_M(RxV,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerhnew_pci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerhnew_pci({fEA_REG(RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_storerhnew_pcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    const int MuN = insn->regno[1];
    TCGv MuV = hex_gpr[MuN + HEX_REG_M0];
    TCGv NtN = hex_new_value[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_S2_storerhnew_pcr({fEA_REG(RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_allocframe(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_allocframe(RxV, cpu_env, RxV, tcgv_uiV, slot);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_L2_deallocframe(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_deallocframe(RddV, cpu_env, RsV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return(RddV, cpu_env, RsV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_t(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_t(RddV, cpu_env, PvV, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_f(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_f(RddV, cpu_env, PvV, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_tnew_pt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_tnew_pt(RddV, cpu_env, PvN, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_fnew_pt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_fnew_pt(RddV, cpu_env, PvN, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_tnew_pnt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_tnew_pnt(RddV, cpu_env, PvN, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_return_fnew_pnt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_return_fnew_pnt(RddV, cpu_env, PvN, RsV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_loadw_locked(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_L2_loadw_locked({ fEA_REG(RsV); fLOAD_LOCKED(1,4,u,EA,RdV) });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_S2_storew_locked(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_S2_storew_locked({ fEA_REG(RsV); fSTORE_LOCKED(1,4,EA,RtV,PdV) });
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(EA);
    tcg_temp_free(PdV);
}

static void generate_L4_loadd_locked(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_L4_loadd_locked({ fEA_REG(RsV); fLOAD_LOCKED(1,8,u,EA,RddV) });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_S4_stored_locked(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_S4_stored_locked({ fEA_REG(RsV); fSTORE_LOCKED(1,8,EA,RttV,PdV) });
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(EA);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RttV);
}

static void generate_L4_loadrub_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrub_rr(RdV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrubt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrubt_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrubt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrubt_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrubf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrubf_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrubf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrubf_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrubtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrubtnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrubfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrubfnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubt_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubf_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubtnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubfnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrubtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrubtnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrubfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrubfnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadrubt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubt_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubf_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubtnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrubfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrubfnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrb_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrb_rr(RdV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrbt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrbt_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrbt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrbt_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrbf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrbf_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrbf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrbf_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrbtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrbtnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrbfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrbfnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbt_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbf_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbtnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbfnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrbtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrbtnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrbfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrbfnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadrbt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbt_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbf_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbtnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrbfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrbfnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadruh_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadruh_rr(RdV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadruht_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadruht_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadruht_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadruht_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadruhf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadruhf_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadruhf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadruhf_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadruhtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadruhtnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadruhfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadruhfnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruht_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruht_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhf_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhtnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhfnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadruhtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadruhtnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadruhfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadruhfnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadruht_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruht_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhf_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhtnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadruhfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadruhfnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrh_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrh_rr(RdV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrht_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrht_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrht_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrht_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrhf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrhf_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrhf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrhf_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrhtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrhtnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrhfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrhfnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrht_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrht_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhf_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhtnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhfnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrhtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrhtnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrhfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrhfnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadrht_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrht_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhf_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhtnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrhfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrhfnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadri_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadri_rr(RdV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrit_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrit_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrit_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrit_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrif_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrif_io(RdV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrif_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrif_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadritnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadritnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadrifnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrifnew_io(RdV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrit_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrit_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrif_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrif_rr(RdV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadritnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadritnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrifnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrifnew_rr(RdV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_ploadritnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadritnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrifnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrifnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadrit_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrit_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrif_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrif_abs(RdV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadritnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadritnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_ploadrifnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrifnew_abs(RdV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L4_loadrd_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_loadrd_rr(RddV, cpu_env, RsV, RtV, tcgv_uiV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_ploadrdt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrdt_io(RddV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_ploadrdt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrdt_pi({fEA_REG(RxV); if(fLSBOLD(PtV)){ fPM_I(RxV,siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrdf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrdf_io(RddV, cpu_env, PtV, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_ploadrdf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrdf_pi({fEA_REG(RxV); if(fLSBOLDNOT(PtV)){ fPM_I(RxV,siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrdtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrdtnew_io(RddV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_ploadrdfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_ploadrdfnew_io(RddV, cpu_env, PtN, RsV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdt_rr(RddV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdf_rr(RddV, cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdtnew_rr(RddV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdfnew_rr(RddV, cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L2_ploadrdtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrdtnew_pi({fEA_REG(RxV); if(fLSBNEW(PtN)){ fPM_I(RxV,siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L2_ploadrdfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[2];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_L2_ploadrdfnew_pi({fEA_REG(RxV); if(fLSBNEWNOT(PtN)){ fPM_I(RxV,siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}});
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(RxV);
}

static void generate_L4_ploadrdt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdt_abs(RddV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdf_abs(RddV, cpu_env, PtV, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdtnew_abs(RddV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_L4_ploadrdfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PtN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ploadrdfnew_abs(RddV, cpu_env, PtN, tcgv_uiV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_S4_storerb_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerb_rr(cpu_env, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbt_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbt_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerbf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbf_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbf_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerbt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbt_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbf_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbtnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbfnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbtnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbfnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbtnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerbfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbfnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerbt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbt_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbf_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbtnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbfnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storerh_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerh_rr(cpu_env, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerht_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerht_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerht_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerht_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerhf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhf_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhf_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerht_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerht_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhf_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhtnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhfnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhtnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhfnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhtnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerhfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhfnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerht_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerht_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhf_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhtnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhfnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storerf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerf_rr(cpu_env, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerft_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerft_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerft_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerft_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerff_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerff_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerff_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerff_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerft_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerft_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerff_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerff_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerftnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerftnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerffnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerffnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerftnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerftnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerffnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerffnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerftnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerftnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerffnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerffnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerft_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerft_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerff_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerff_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerftnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerftnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerffnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerffnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeri_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeri_rr(cpu_env, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerit_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerit_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerit_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerit_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerif_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerif_io(cpu_env, PvV, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerif_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerif_pi(RxV, cpu_env, PvV, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerit_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerit_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerif_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerif_rr(cpu_env, PvV, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstoreritnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstoreritnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerifnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerifnew_io(cpu_env, PvN, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstoreritnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstoreritnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerifnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerifnew_rr(cpu_env, PvN, RsV, RuV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstoreritnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstoreritnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerifnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerifnew_pi(RxV, cpu_env, PvN, RxV, RtV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerit_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerit_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerif_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerif_abs(cpu_env, PvV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstoreritnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstoreritnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerifnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerifnew_abs(cpu_env, PvN, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storerd_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerd_rr(cpu_env, RsV, RuV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdt_io(cpu_env, PvV, RsV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdt_pi(RxV, cpu_env, PvV, RxV, RttV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdf_io(cpu_env, PvV, RsV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdf_pi(RxV, cpu_env, PvV, RxV, RttV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdt_rr(cpu_env, PvV, RsV, RuV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdf_rr(cpu_env, PvV, RsV, RuV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdtnew_io(cpu_env, PvN, RsV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdfnew_io(cpu_env, PvN, RsV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdtnew_rr(cpu_env, PvN, RsV, RuV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdfnew_rr(cpu_env, PvN, RsV, RuV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdtnew_pi(RxV, cpu_env, PvN, RxV, RttV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_pstorerdfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerdfnew_pi(RxV, cpu_env, PvN, RxV, RttV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdt_abs(cpu_env, PvV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdf_abs(cpu_env, PvV, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdtnew_abs(cpu_env, PvN, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_pstorerdfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerdfnew_abs(cpu_env, PvN, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_storerinew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerinew_rr(cpu_env, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerinewt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewt_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerinewt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewt_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerinewf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewf_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerinewf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewf_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerinewt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewt_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewf_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewtnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewfnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewtnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewfnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerinewtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewtnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerinewfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerinewfnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerinewt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewt_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewf_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewtnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerinewfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerinewfnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storerbnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerbnew_rr(cpu_env, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbnewt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewt_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbnewt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewt_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerbnewf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewf_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbnewf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewf_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerbnewt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewt_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewf_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewtnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewfnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewtnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewfnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerbnewtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewtnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerbnewfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerbnewfnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerbnewt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewt_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewf_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewtnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerbnewfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerbnewfnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storerhnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storerhnew_rr(cpu_env, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhnewt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewt_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhnewt_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewt_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerhnewf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewf_io(cpu_env, PvV, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhnewf_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewf_pi(RxV, cpu_env, PvV, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerhnewt_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewt_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewf_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewf_rr(cpu_env, PvV, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewtnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv NtN = hex_new_value[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewfnew_io(cpu_env, PvN, RsV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewtnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewtnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewfnew_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    TCGv NtN = hex_new_value[insn->regno[3]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewfnew_rr(cpu_env, PvN, RsV, RuV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_pstorerhnewtnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewtnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S2_pstorerhnewfnew_pi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[1];
    if (!is_preloaded(ctx, RxN)) {
        tcg_gen_mov_tl(hex_new_value[RxN], hex_gpr[RxN]);
    }
    TCGv NtN = hex_new_value[insn->regno[2]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_pstorerhnewfnew_pi(RxV, cpu_env, PvN, RxV, NtN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RxN, RxV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(EA);
    tcg_temp_free(RxV);
}

static void generate_S4_pstorerhnewt_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewt_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewf_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewf_abs(cpu_env, PvV, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewtnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewtnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_pstorerhnewfnew_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv NtN = hex_new_value[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_pstorerhnewfnew_abs(cpu_env, PvN, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_add_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_add_memopw_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_add_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_add_memopb_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_add_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_add_memoph_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_sub_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_sub_memopw_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_sub_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_sub_memopb_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_sub_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_sub_memoph_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_and_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_and_memopw_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_and_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_and_memopb_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_and_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_and_memoph_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_or_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_or_memopw_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_or_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_or_memopb_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_or_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_or_memoph_io(cpu_env, RsV, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iadd_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iadd_memopw_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iadd_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iadd_memopb_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iadd_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iadd_memoph_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_isub_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_isub_memopw_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_isub_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_isub_memopb_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_isub_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_isub_memoph_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iand_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iand_memopw_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iand_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iand_memopb_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_iand_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_iand_memoph_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_ior_memopw_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ior_memopw_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_ior_memopb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ior_memopb_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_L4_ior_memoph_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L4_ior_memoph_io(cpu_env, RsV, tcgv_uiV, tcgv_UiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirbt_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirbt_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirbf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirbf_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirbtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirbtnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirbfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirbfnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirht_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirht_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirhf_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirhf_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirhtnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirhtnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirhfnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirhfnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirit_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirit_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirif_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvV = hex_pred[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirif_io(cpu_env, PvV, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeiritnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeiritnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirifnew_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv PvN = hex_new_pred_value[insn->regno[0]];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirifnew_io(cpu_env, PvN, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirb_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirb_io(cpu_env, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeirh_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeirh_io(cpu_env, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_S4_storeiri_io(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RsV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S4_storeiri_io(cpu_env, RsV, tcgv_uiV, tcgv_SiV, slot);
    tcg_temp_free(EA);
}

static void generate_L2_loadrubgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrubgp(RdV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_loadrbgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrbgp(RdV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_loadruhgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadruhgp(RdV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_loadrhgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrhgp(RdV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_loadrigp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrigp(RdV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(EA);
    tcg_temp_free(RdV);
}

static void generate_L2_loadrdgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_local_new();
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_L2_loadrdgp(RddV, cpu_env, tcgv_uiV, slot);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_storerbgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RtV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerbgp(cpu_env, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerhgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RtV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerhgp(cpu_env, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerfgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RtV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerfgp(cpu_env, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerigp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv RtV = hex_gpr[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerigp(cpu_env, RtV, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerdgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[0];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerdgp(cpu_env, RttV, tcgv_uiV, slot);
    tcg_temp_free(EA);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_storerinewgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv NtN = hex_new_value[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerinewgp(cpu_env, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerbnewgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv NtN = hex_new_value[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerbnewgp(cpu_env, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_S2_storerhnewgp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv EA = tcg_temp_new();
    TCGv NtN = hex_new_value[insn->regno[0]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_S2_storerhnewgp(cpu_env, NtN, tcgv_uiV, slot);
    tcg_temp_free(EA);
}

static void generate_C2_cmpeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C2_cmpeq(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C2_cmpgt(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C2_cmpgtu(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpeqp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_C2_cmpeqp(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_C2_cmpgtp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_C2_cmpgtp(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_C2_cmpgtup(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_C2_cmpgtup(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_rcmpeqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_rcmpeqi(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_rcmpneqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_rcmpneqi(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_rcmpeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_rcmpeq(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_rcmpneq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_rcmpneq(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_bitsset(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C2_bitsset(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_bitsclr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C2_bitsclr(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_nbitsset(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C4_nbitsset(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_nbitsclr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C4_nbitsclr(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpeqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C2_cmpeqi(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C2_cmpgti(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_cmpgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_C2_cmpgtui(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_bitsclri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_C2_bitsclri(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_nbitsclri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_C4_nbitsclri(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmpneqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C4_cmpneqi(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmpltei(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C4_cmpltei(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmplteui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_C4_cmplteui(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmpneq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C4_cmpneq(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmplte(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C4_cmplte(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_cmplteu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_C4_cmplteu(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PtV = hex_pred[insn->regno[1]];
    TCGv PsV = hex_pred[insn->regno[2]];
    gen_helper_C2_and(PdV, cpu_env, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PtV = hex_pred[insn->regno[1]];
    TCGv PsV = hex_pred[insn->regno[2]];
    gen_helper_C2_or(PdV, cpu_env, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    gen_helper_C2_xor(PdV, cpu_env, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PtV = hex_pred[insn->regno[1]];
    TCGv PsV = hex_pred[insn->regno[2]];
    gen_helper_C2_andn(PdV, cpu_env, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_not(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    gen_helper_C2_not(PdV, cpu_env, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_orn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PtV = hex_pred[insn->regno[1]];
    TCGv PsV = hex_pred[insn->regno[2]];
    gen_helper_C2_orn(PdV, cpu_env, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_and_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_and_and(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_and_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_and_or(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_or_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_or_and(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_or_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_or_or(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_and_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_and_andn(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_and_orn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_and_orn(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_or_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_or_andn(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_or_orn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    gen_helper_C4_or_orn(PdV, cpu_env, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_any8(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    gen_helper_C2_any8(PdV, cpu_env, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_all8(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    gen_helper_C2_all8(PdV, cpu_env, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C2_vitpack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    gen_helper_C2_vitpack(RdV, cpu_env, PsV, PtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_mux(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PuV = hex_pred[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    gen_helper_C2_mux(RdV, cpu_env, PuV, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_cmovenewit(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_cmovenewit(RdV, cpu_env, PuN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_cmovenewif(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_cmovenewif(RdV, cpu_env, PuN, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_cmoveit(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_cmoveit(RdV, cpu_env, PuV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_cmoveif(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_cmoveif(RdV, cpu_env, PuV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_ccombinewnewt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_ccombinewnewt(RddV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_C2_ccombinewnewf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_ccombinewnewf(RddV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_C2_ccombinewt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_ccombinewt(RddV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_C2_ccombinewf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[1];
    if (!is_preloaded(ctx, RddN)) {
        tcg_gen_mov_tl(hex_new_value[RddN], hex_gpr[RddN]);
    }
    if (!is_preloaded(ctx, RddN + 1)) {
        tcg_gen_mov_tl(hex_new_value[RddN + 1], hex_gpr[RddN + 1]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_C2_ccombinewf(RddV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write_pair(RddN, RddV, insn->slot);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_C2_muxii(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PuV = hex_pred[insn->regno[1]];
    int siV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_C2_muxii(RdV, cpu_env, PuV, tcgv_siV, tcgv_SiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_muxir(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PuV = hex_pred[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C2_muxir(RdV, cpu_env, PuV, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_muxri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PuV = hex_pred[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_C2_muxri(RdV, cpu_env, PuV, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_vmux(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv PuV = hex_pred[insn->regno[1]];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_C2_vmux(RddV, cpu_env, PuV, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_C2_mask(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv PtV = hex_pred[insn->regno[1]];
    gen_helper_C2_mask(RddV, cpu_env, PtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A2_vcmpbeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpbeq(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_vcmpbeqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_vcmpbeqi(PdV, cpu_env, RssV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmpbeq_any(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A4_vcmpbeq_any(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A6_vcmpbeq_notany(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A6_vcmpbeq_notany(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vcmpbgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpbgtu(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_vcmpbgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_vcmpbgtui(PdV, cpu_env, RssV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmpbgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A4_vcmpbgt(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_vcmpbgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_vcmpbgti(PdV, cpu_env, RssV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_cmpbeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmpbeq(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpbeqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_cmpbeqi(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpbgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmpbgtu(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpbgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_cmpbgtui(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpbgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmpbgt(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpbgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_cmpbgti(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A2_vcmpheq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpheq(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vcmphgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmphgt(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vcmphgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmphgtu(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_vcmpheqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_vcmpheqi(PdV, cpu_env, RssV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmphgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_vcmphgti(PdV, cpu_env, RssV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmphgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_vcmphgtui(PdV, cpu_env, RssV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_cmpheq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmpheq(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmphgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmphgt(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmphgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cmphgtu(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmpheqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_cmpheqi(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmphgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_cmphgti(PdV, cpu_env, RsV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A4_cmphgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_cmphgtui(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_A2_vcmpweq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpweq(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vcmpwgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpwgt(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vcmpwgtu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vcmpwgtu(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_vcmpweqi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_vcmpweqi(PdV, cpu_env, RssV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmpwgti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_vcmpwgti(PdV, cpu_env, RssV, tcgv_siV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vcmpwgtui(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_vcmpwgtui(PdV, cpu_env, RssV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_boundscheck_hi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A4_boundscheck_hi(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_boundscheck_lo(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A4_boundscheck_lo(PdV, cpu_env, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_tlbmatch(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_tlbmatch(PdV, cpu_env, RssV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_C2_tfrpr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    gen_helper_C2_tfrpr(RdV, cpu_env, PsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C2_tfrrp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_C2_tfrrp(PdV, cpu_env, RsV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_fastcorner9(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    gen_helper_C4_fastcorner9(PdV, cpu_env, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_C4_fastcorner9_not(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv PsV = hex_pred[insn->regno[1]];
    TCGv PtV = hex_pred[insn->regno[2]];
    gen_helper_C4_fastcorner9_not(PdV, cpu_env, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_M2_mpy_acc_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_acc_sat_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_acc_sat_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_nac_sat_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpy_nac_sat_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpy_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_hh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_hh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_hl_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_hl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_lh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_lh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_ll_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_ll_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_hh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_hh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_hl_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_hl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_lh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_lh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_ll_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_ll_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_hh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_hh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_hl_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_hl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_lh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_lh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_ll_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_rnd_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_rnd_ll_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_hh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_hh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_hl_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_hl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_lh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_lh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_ll_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_sat_rnd_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_sat_rnd_ll_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyd_acc_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_hh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_hh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_hl_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_hl_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_lh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_lh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_ll_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_acc_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_acc_ll_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_hh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_hh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_hl_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_hl_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_lh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_lh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_ll_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_nac_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyd_nac_ll_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyd_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_hh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_hh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_hl_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_hl_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_lh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_lh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_ll_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_ll_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_hh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_hh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_hl_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_hl_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_lh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_lh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_ll_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyd_rnd_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyd_rnd_ll_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyu_acc_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_acc_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_acc_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_hh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_hh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_hl_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_hl_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_lh_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_lh_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_ll_s0(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_nac_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mpyu_nac_ll_s1(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyu_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_hh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_hh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_hl_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_hl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_lh_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_lh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_ll_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_ll_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyud_acc_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_hh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_hh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_hl_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_hl_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_lh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_lh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_ll_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_acc_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_acc_ll_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_hh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_hh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_hl_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_hl_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_lh_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_lh_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_ll_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_nac_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_mpyud_nac_ll_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpyud_hh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_hh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_hh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_hh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_hl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_hl_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_hl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_hl_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_lh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_lh_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_lh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_lh_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_ll_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_ll_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpyud_ll_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyud_ll_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_mpysip(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M2_mpysip(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpysin(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M2_mpysin(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_macsip(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M2_macsip(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_macsin(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M2_macsin(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_dpmpyss_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_dpmpyss_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_dpmpyss_acc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_dpmpyss_acc_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_dpmpyss_nac_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_dpmpyss_nac_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_dpmpyuu_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_dpmpyuu_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_dpmpyuu_acc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_dpmpyuu_acc_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_dpmpyuu_nac_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_dpmpyuu_nac_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_mpy_up(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_up(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_up_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_up_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpy_up_s1_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpy_up_s1_sat(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpyu_up(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyu_up(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mpysu_up(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpysu_up(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_dpmpyss_rnd_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_dpmpyss_rnd_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M4_mac_up_s1_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_mac_up_s1_sat(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_nac_up_s1_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_nac_up_s1_sat(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mpyi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_mpyi(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_maci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_maci(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_mnaci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_mnaci(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_acci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_acci(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_accii(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_M2_accii(RxV, cpu_env, RxV, RsV, tcgv_siV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_nacci(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_nacci(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_naccii(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_M2_naccii(RxV, cpu_env, RxV, RsV, tcgv_siV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M2_subacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_subacc(RxV, cpu_env, RxV, RtV, RsV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_mpyrr_addr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RyV = tcg_temp_local_new();
    const int RyN = insn->regno[0];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RyV, hex_gpr[RyN]);
    gen_helper_M4_mpyrr_addr(RyV, cpu_env, RyV, RuV, RsV);
    gen_log_reg_write(RyN, RyV);
    ctx_log_reg_write(ctx, RyN);
    tcg_temp_free(RyV);
}

static void generate_M4_mpyri_addr_u2(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M4_mpyri_addr_u2(RdV, cpu_env, RuV, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M4_mpyri_addr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RuV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M4_mpyri_addr(RdV, cpu_env, RuV, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M4_mpyri_addi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_M4_mpyri_addi(RdV, cpu_env, RsV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M4_mpyrr_addi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_M4_mpyrr_addi(RdV, cpu_env, RsV, RtV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_vmpy2s_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2s_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_vmpy2s_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2s_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_vmac2s_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_vmac2s_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vmac2s_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_vmac2s_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vmpy2su_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2su_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_vmpy2su_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2su_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_vmac2su_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_vmac2su_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vmac2su_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_vmac2su_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vmpy2s_s0pack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2s_s0pack(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_vmpy2s_s1pack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_vmpy2s_s1pack(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_vmac2(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_vmac2(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vmpy2es_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vmpy2es_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vmpy2es_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vmpy2es_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vmac2es_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vmac2es_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vmac2es_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vmac2es_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vmac2es(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vmac2es(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrmac_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrmac_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrmpy_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrmpy_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmpyrs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmpyrs_s0(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmpyrs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmpyrs_s1(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vrmpybuu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vrmpybuu(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vrmacbuu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vrmacbuu(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vrmpybsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vrmpybsu(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vrmacbsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vrmacbsu(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vmpybuu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M5_vmpybuu(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M5_vmpybsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M5_vmpybsu(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M5_vmacbuu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M5_vmacbuu(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M5_vmacbsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M5_vmacbsu(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M5_vdmpybsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vdmpybsu(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M5_vdmacbsu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M5_vdmacbsu(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmacs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmacs_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmacs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmacs_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmpys_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmpys_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vdmpys_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vdmpys_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_cmpyrs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyrs_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_cmpyrs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyrs_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_cmpyrsc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyrsc_s0(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_cmpyrsc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyrsc_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_cmacs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmacs_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cmacs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmacs_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cmacsc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmacsc_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cmacsc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmacsc_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cmpys_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpys_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_cmpys_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpys_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_cmpysc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpysc_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_cmpysc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpysc_s1(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_cnacs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cnacs_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cnacs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cnacs_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cnacsc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cnacsc_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cnacsc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cnacsc_s1(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vrcmpys_s1_h(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_s1_h(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpys_s1_l(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_s1_l(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpys_acc_s1_h(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_acc_s1_h(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpys_acc_s1_l(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_acc_s1_l(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpys_s1rp_h(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_s1rp_h(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpys_s1rp_l(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpys_s1rp_l(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacls_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacls_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacls_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacls_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmachs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmachs_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmachs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmachs_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyl_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyl_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyl_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyh_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyh_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacls_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacls_rs0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacls_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacls_rs1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmachs_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmachs_rs0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmachs_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmachs_rs1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyl_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyl_rs0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyl_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyl_rs1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyh_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyh_rs0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyh_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyh_rs1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyeh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyeh_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyeh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyeh_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyeh_acc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyeh_acc_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyeh_acc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyeh_acc_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyoh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyoh_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyoh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyoh_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyoh_acc_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyoh_acc_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M4_vrmpyoh_acc_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_vrmpyoh_acc_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_hmmpyl_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_hmmpyl_rs1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_hmmpyh_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_hmmpyh_rs1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_hmmpyl_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_hmmpyl_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_hmmpyh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_hmmpyh_s1(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_mmaculs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmaculs_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmaculs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmaculs_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacuhs_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacuhs_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacuhs_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacuhs_s1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyul_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyul_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyul_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyul_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyuh_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyuh_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyuh_s1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyuh_s1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmaculs_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmaculs_rs0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmaculs_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmaculs_rs1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacuhs_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacuhs_rs0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmacuhs_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmacuhs_rs1(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyul_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyul_rs0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyul_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyul_rs1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyuh_rs0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyuh_rs0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_mmpyuh_rs1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_mmpyuh_rs1(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmaci_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmaci_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmacr_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmacr_s0(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmaci_s0c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmaci_s0c(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmacr_s0c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmacr_s0c(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_cmaci_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmaci_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_cmacr_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M2_cmacr_s0(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M2_vrcmpyi_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpyi_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpyr_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpyr_s0(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpyi_s0c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpyi_s0c(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vrcmpyr_s0c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vrcmpyr_s0c(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_cmpyi_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyi_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M2_cmpyr_s0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M2_cmpyr_s0(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M4_cmpyi_wh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M4_cmpyi_wh(RdV, cpu_env, RssV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_M4_cmpyr_wh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M4_cmpyr_wh(RdV, cpu_env, RssV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_M4_cmpyi_whc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M4_cmpyi_whc(RdV, cpu_env, RssV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_M4_cmpyr_whc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M4_cmpyr_whc(RdV, cpu_env, RssV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_M2_vcmpy_s0_sat_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmpy_s0_sat_i(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vcmpy_s0_sat_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmpy_s0_sat_r(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vcmpy_s1_sat_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmpy_s1_sat_i(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vcmpy_s1_sat_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmpy_s1_sat_r(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vcmac_s0_sat_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmac_s0_sat_i(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vcmac_s0_sat_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vcmac_s0_sat_r(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vcrotate(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vcrotate(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_vrcrotate_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S4_vrcrotate_acc(RxxV, cpu_env, RxxV, RssV, RtV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_vrcrotate(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S4_vrcrotate(RddV, cpu_env, RssV, RtV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vcnegh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vcnegh(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vrcnegh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vrcnegh(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_M4_pmpyw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M4_pmpyw(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M4_vpmpyh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_M4_vpmpyh(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_M4_pmpyw_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M4_pmpyw_acc(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M4_vpmpyh_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    gen_helper_M4_vpmpyh_acc(RxxV, cpu_env, RxxV, RsV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
}

static void generate_M7_dcmpyrw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyrw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyrw_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyrw_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyrwc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyrwc(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyrwc_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyrwc_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyiw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyiw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyiw_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyiw_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyiwc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyiwc(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_dcmpyiwc_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_dcmpyiwc_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyrw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrw(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyrwc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrwc(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyiw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiw(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyiwc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiwc(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyrw_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrw_rnd(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyrwc_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrwc_rnd(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyiw_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiw_rnd(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M7_wcmpyiwc_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiwc_rnd(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_add(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_add(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_sub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_sub(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddt(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddf(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddtnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddfnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_psubt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    TCGv RsV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_psubt(RdV, cpu_env, PuV, RtV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_psubf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    TCGv RsV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_psubf(RdV, cpu_env, PuV, RtV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_psubtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    TCGv RsV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_psubtnew(RdV, cpu_env, PuN, RtV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_psubfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RtV = hex_gpr[insn->regno[2]];
    TCGv RsV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_psubfnew(RdV, cpu_env, PuN, RtV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddit(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddit(RdV, cpu_env, PuV, RsV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddif(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddif(RdV, cpu_env, PuV, RsV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_padditnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_padditnew(RdV, cpu_env, PuN, RsV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_paddifnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_paddifnew(RdV, cpu_env, PuN, RsV, tcgv_siV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pxort(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pxort(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pxorf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pxorf(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pxortnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pxortnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pxorfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pxorfnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pandt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pandt(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pandf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pandf(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pandtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pandtnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_pandfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_pandfnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_port(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_port(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_porf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_porf(RdV, cpu_env, PuV, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_portnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_portnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_porfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A2_porfnew(RdV, cpu_env, PuN, RsV, RtV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxtbt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxtbt(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxtbf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxtbf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxtbtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxtbtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxtbfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxtbfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxtbt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxtbt(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxtbf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxtbf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxtbtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxtbtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxtbfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxtbfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxtht(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxtht(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxthf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxthf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxthtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxthtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_psxthfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_psxthfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxtht(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxtht(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxthf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxthf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxthtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxthtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pzxthfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pzxthfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_paslht(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_paslht(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_paslhf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_paslhf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_paslhtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_paslhtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_paslhfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_paslhfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pasrht(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pasrht(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pasrhf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuV = hex_pred[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pasrhf(RdV, cpu_env, PuV, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pasrhtnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pasrhtnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_pasrhfnew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PuN = hex_new_pred_value[insn->regno[0]];
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[1];
    if (!is_preloaded(ctx, RdN)) {
        tcg_gen_mov_tl(hex_new_value[RdN], hex_gpr[RdN]);
    }
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv slot = tcg_constant_tl(insn->slot);
    gen_helper_A4_pasrhfnew(RdV, cpu_env, PuN, RsV, slot);
    gen_log_predicated_reg_write(RdN, RdV,
                                 insn->slot);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addsat(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subsat(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A2_addi(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_C4_addipc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_C4_addipc(RdV, cpu_env, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_l16_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_l16_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_l16_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_l16_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_l16_sat_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_l16_sat_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_l16_sat_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_l16_sat_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_l16_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_l16_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_l16_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_l16_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_l16_sat_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_l16_sat_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_l16_sat_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_l16_sat_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_lh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_lh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_hh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_hh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_sat_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_sat_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_sat_lh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_sat_lh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_sat_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_sat_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addh_h16_sat_hh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_addh_h16_sat_hh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_lh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_lh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_hh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_hh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_sat_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_sat_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_sat_lh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_sat_lh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_sat_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_sat_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_subh_h16_sat_hh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_subh_h16_sat_hh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_aslh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_aslh(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_asrh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_asrh(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_addp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_addp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_addpsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_addpsat(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_addspl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_addspl(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_addsph(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_addsph(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_subp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_subp(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_addp_c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    TCGv PxV = tcg_temp_local_new();
    const int PxN = insn->regno[3];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_mov_tl(PxV, hex_pred[PxN]);
    fGEN_TCG_A4_addp_c({ RddV = RssV + RttV + fLSBOLD(PxV); PxV = f8BITSOF(fCARRY_FROM_ADD(RssV,RttV,fLSBOLD(PxV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_pred_write(ctx, PxN, PxV);
    ctx_log_pred_write(ctx, PxN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free(PxV);
}

static void generate_A4_subp_c(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    TCGv PxV = tcg_temp_local_new();
    const int PxN = insn->regno[3];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_mov_tl(PxV, hex_pred[PxN]);
    fGEN_TCG_A4_subp_c({ RddV = RssV + ~RttV + fLSBOLD(PxV); PxV = f8BITSOF(fCARRY_FROM_ADD(RssV,~RttV,fLSBOLD(PxV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_pred_write(ctx, PxN, PxV);
    ctx_log_pred_write(ctx, PxN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free(PxV);
}

static void generate_A2_negsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_negsat(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_abs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_abs(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_abssat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_abssat(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_vconj(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vconj(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_negp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_negp(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_absp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_absp(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_max(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_max(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_maxu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_maxu(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_min(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_min(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_minu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_minu(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_maxp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_maxp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_maxup(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_maxup(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_minp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_minp(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_minup(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_minup(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_nop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    gen_helper_A2_nop(cpu_env);
}

static void generate_A4_ext(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_ext(cpu_env, tcgv_uiV);
}

static void generate_A2_tfr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_tfr(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_tfrsi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A2_tfrsi(RdV, cpu_env, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_sxtb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_sxtb(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_zxth(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_zxth(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_sxth(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_sxth(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_combinew(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_combinew(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A4_combineri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_combineri(RddV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A4_combineir(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A4_combineir(RddV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A2_combineii(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    int siV = insn->immed[0];
    int SiV = insn->immed[1];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_A2_combineii(RddV, cpu_env, tcgv_siV, tcgv_SiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A4_combineii(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    int siV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_A4_combineii(RddV, cpu_env, tcgv_siV, tcgv_UiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A2_combine_hh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_combine_hh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_combine_hl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_combine_hl(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_combine_lh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_combine_lh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_combine_ll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_combine_ll(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_tfril(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A2_tfril(RxV, cpu_env, RxV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_A2_tfrih(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A2_tfrih(RxV, cpu_env, RxV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_A2_tfrcrr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv CsV = tcg_temp_local_new();
    const int CsN = insn->regno[1] + HEX_REG_SA0;
    gen_read_ctrl_reg(ctx, CsN, CsV);
    gen_helper_A2_tfrcrr(RdV, cpu_env, CsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free(CsV);
}

static void generate_A2_tfrrcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv CdV = tcg_temp_local_new();
    const int CdN = insn->regno[0] + HEX_REG_SA0;
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_tfrrcr(CdV, cpu_env, RsV);
    gen_write_ctrl_reg(ctx, CdN, CdV);
    tcg_temp_free(CdV);
}

static void generate_A4_tfrcpp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 CssV = tcg_temp_local_new_i64();
    const int CssN = insn->regno[1] + HEX_REG_SA0;
    gen_read_ctrl_reg_pair(ctx, CssN, CssV);
    gen_helper_A4_tfrcpp(RddV, cpu_env, CssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(CssV);
}

static void generate_A4_tfrpcp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 CddV = tcg_temp_local_new_i64();
    const int CddN = insn->regno[0] + HEX_REG_SA0;
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_tfrpcp(CddV, cpu_env, RssV);
    gen_write_ctrl_reg_pair(ctx, CddN, CddV);
    tcg_temp_free_i64(CddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_and(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_or(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_xor(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M2_xor_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M2_xor_xacc(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_xor_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M4_xor_xacc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A4_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A4_andn(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_orn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A4_orn(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_andnp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_andnp(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_ornp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_ornp(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_addaddi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_addaddi(RdV, cpu_env, RsV, RuV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S4_subaddi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RuV = hex_gpr[insn->regno[2]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_subaddi(RdV, cpu_env, RsV, RuV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_M4_and_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_and_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_and_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_and_andn(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_and_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_and_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_and_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_and_xor(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_or_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_or_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_or_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_or_andn(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_or_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_or_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_or_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_or_xor(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_or_andix(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RuV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_or_andix(RxV, cpu_env, RxV, RuV, tcgv_siV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_or_andi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_or_andi(RxV, cpu_env, RxV, RsV, tcgv_siV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_or_ori(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_or_ori(RxV, cpu_env, RxV, RsV, tcgv_siV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_xor_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_xor_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_xor_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_xor_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_M4_xor_andn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_M4_xor_andn(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_A2_subri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A2_subri(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_andir(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A2_andir(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_orir(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_A2_orir(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_andp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_andp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_orp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_orp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_xorp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_xorp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_notp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_notp(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_sxtw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_sxtw(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A2_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_sat(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_roundsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_roundsat(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_sath(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_sath(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_satuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_satuh(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_satub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_satub(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_satb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_satb(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_vaddub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddub(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vaddubs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddubs(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vaddh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vaddhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddhs(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vadduhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vadduhs(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A5_vaddhubs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A5_vaddhubs(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vaddw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vaddws(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vaddws(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxaddsubw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxaddsubw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxsubaddw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxsubaddw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxaddsubh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxaddsubh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxsubaddh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxsubaddh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxaddsubhr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxaddsubhr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_vxsubaddhr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_vxsubaddhr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_svavgh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svavgh(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svavghs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svavghs(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svnavgh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svnavgh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svaddh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svaddh(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svaddhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svaddhs(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svadduhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svadduhs(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svsubh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svsubh(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svsubhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svsubhs(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_svsubuhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    gen_helper_A2_svsubuhs(RdV, cpu_env, RtV, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A2_vraddub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vraddub(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vraddub_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vraddub_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vraddh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vraddh(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_M2_vradduh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_M2_vradduh(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vsubub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubub(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsububs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsububs(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsubh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsubhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubhs(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsubuhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubuhs(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsubw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vsubws(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vsubws(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vabsh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vabsh(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vabshsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vabshsat(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vabsw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vabsw(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vabswsat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vabswsat(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_M2_vabsdiffw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M2_vabsdiffw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_M2_vabsdiffh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M2_vabsdiffh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_M6_vabsdiffb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M6_vabsdiffb(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_M6_vabsdiffub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_M6_vabsdiffub(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vrsadub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vrsadub(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vrsadub_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vrsadub_acc(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavgub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgub(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavguh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavguh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavgh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavgh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavgh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vavgw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavgw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavgw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vavgwr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgwr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavgwr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavgwr(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vavgwcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgwcr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavgwcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavgwcr(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vavghcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavghcr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavghcr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavghcr(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vavguw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavguw(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavguwr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavguwr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavgubr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavgubr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavguhr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavguhr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vavghr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_A2_vavghr(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A2_vnavghr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vnavghr(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_round_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_round_ri(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_round_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_round_rr(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_round_ri_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_round_ri_sat(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_round_rr_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_round_rr_sat(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_cround_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_cround_ri(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A4_cround_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_cround_rr(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A7_croundd_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A7_croundd_ri(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A7_croundd_rr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A7_croundd_rr(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A7_clip(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A7_clip(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_A7_vclip(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A7_vclip(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrminh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrminh(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrmaxh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrmaxh(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrminuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrminuh(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrmaxuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrmaxuh(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrminw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrminw(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrmaxw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrmaxw(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrminuw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrminuw(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_vrmaxuw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RuV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A4_vrmaxuw(RxxV, cpu_env, RxxV, RssV, RuV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminb(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxb(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminub(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxub(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminuh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxuh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vminuw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vminuw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A2_vmaxuw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_A2_vmaxuw(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A5_ACS(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv PeV = tcg_temp_local_new();
    const int PeN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[3];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_A5_ACS({ fHIDE(int i;) fHIDE(int xv;) fHIDE(int sv;) fHIDE(int tv;) for (i = 0; i < 4; i++) { xv = (int) fGETHALF(i,RxxV); sv = (int) fGETHALF(i,RssV); tv = (int) fGETHALF(i,RttV); xv = xv + tv; sv = sv - tv; fSETBIT(i*2, PeV, (xv > sv)); fSETBIT(i*2+1,PeV, (xv > sv)); fSETHALF(i, RxxV, fSATH(fMAX(xv,sv))); } });
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    gen_log_pred_write(ctx, PeN, PeV);
    ctx_log_pred_write(ctx, PeN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free(PeV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_A6_vminub_RdP(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv PeV = tcg_temp_local_new();
    const int PeN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[3];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_A6_vminub_RdP({ fHIDE(int i;) for (i = 0; i < 8; i++) { fSETBIT(i, PeV, (fGETUBYTE(i,RttV) > fGETUBYTE(i,RssV))); fSETBYTE(i,RddV,fMIN(fGETUBYTE(i,RttV),fGETUBYTE(i,RssV))); } });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    gen_log_pred_write(ctx, PeN, PeV);
    ctx_log_pred_write(ctx, PeN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free(PeV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_A4_modwrapu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_modwrapu(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfadd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfadd({ RdV=fUNFLOAT(fFLOAT(RsV)+fFLOAT(RtV));});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfsub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfsub({ RdV=fUNFLOAT(fFLOAT(RsV)-fFLOAT(RtV));});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfmpy(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfmpy({ RdV=fUNFLOAT(fSFMPY(fFLOAT(RsV),fFLOAT(RtV)));});
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sffma(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_F2_sffma({ RxV=fUNFLOAT(fFMAF(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV)));});
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_F2_sffma_sc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    TCGv PuV = hex_pred[insn->regno[3]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_F2_sffma_sc({ fHIDE(size4s_t tmp;) fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAFX(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV),PuV)); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_F2_sffms(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_F2_sffms({ RxV=fUNFLOAT(fFMAF(-fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_F2_sffma_lib(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_F2_sffma_lib({ fFPSETROUND_NEAREST(); fHIDE(int infinp; int infminusinf; size4s_t tmp;) infminusinf = ((isinf(fFLOAT(RxV))) && (fISINFPROD(fFLOAT(RsV),fFLOAT(RtV))) && (fGETBIT(31,RsV ^ RxV ^ RtV) != 0)); infinp = (isinf(fFLOAT(RxV))) || (isinf(fFLOAT(RtV))) || (isinf(fFLOAT(RsV))); fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAF(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; fFPCANCELFLAGS(); if (isinf(fFLOAT(RxV)) && !infinp) RxV = RxV - 1; if (infminusinf) RxV = 0; });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_F2_sffms_lib(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    fGEN_TCG_F2_sffms_lib({ fFPSETROUND_NEAREST(); fHIDE(int infinp; int infminusinf; size4s_t tmp;) infminusinf = ((isinf(fFLOAT(RxV))) && (fISINFPROD(fFLOAT(RsV),fFLOAT(RtV))) && (fGETBIT(31,RsV ^ RxV ^ RtV) == 0)); infinp = (isinf(fFLOAT(RxV))) || (isinf(fFLOAT(RtV))) || (isinf(fFLOAT(RsV))); fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAF(-fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; fFPCANCELFLAGS(); if (isinf(fFLOAT(RxV)) && !infinp) RxV = RxV - 1; if (infminusinf) RxV = 0; });
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_F2_sfcmpeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfcmpeq({PdV=f8BITSOF(fFLOAT(RsV)==fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_F2_sfcmpgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfcmpgt({PdV=f8BITSOF(fFLOAT(RsV)>fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_F2_sfcmpge(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfcmpge({PdV=f8BITSOF(fFLOAT(RsV)>=fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_F2_sfcmpuo(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfcmpuo({PdV=f8BITSOF(isunordered(fFLOAT(RsV),fFLOAT(RtV)));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_F2_sfmax(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfmax({ RdV = fUNFLOAT(fSF_MAX(fFLOAT(RsV),fFLOAT(RtV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfmin(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfmin({ RdV = fUNFLOAT(fSF_MIN(fFLOAT(RsV),fFLOAT(RtV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfclass(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    fGEN_TCG_F2_sfclass({ fHIDE(int class;) PdV = 0; class = fpclassify(fFLOAT(RsV)); if (fGETBIT(0,uiV) && (class == FP_ZERO)) PdV = 0xff; if (fGETBIT(1,uiV) && (class == FP_NORMAL)) PdV = 0xff; if (fGETBIT(2,uiV) && (class == FP_SUBNORMAL)) PdV = 0xff; if (fGETBIT(3,uiV) && (class == FP_INFINITE)) PdV = 0xff; if (fGETBIT(4,uiV) && (class == FP_NAN)) PdV = 0xff; fFPCANCELFLAGS(); });
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_F2_sfimm_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_F2_sfimm_p(RdV, cpu_env, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfimm_n(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_F2_sfimm_n(RdV, cpu_env, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfrecipa(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PeV = tcg_temp_local_new();
    const int PeN = insn->regno[1];
    TCGv RsV = hex_gpr[insn->regno[2]];
    TCGv RtV = hex_gpr[insn->regno[3]];
    fGEN_TCG_F2_sfrecipa({ fHIDE(int idx;) fHIDE(int adjust;) fHIDE(int mant;) fHIDE(int exp;) if (fSF_RECIP_COMMON(RsV,RtV,RdV,adjust)) { PeV = adjust; idx = (RtV >> 16) & 0x7f; mant = (fSF_RECIP_LOOKUP(idx) << 15) | 1; exp = fSF_BIAS() - (fSF_GETEXP(RtV) - fSF_BIAS()) - 1; RdV = fMAKESF(fGETBIT(31,RtV),exp,mant); } });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_pred_write(ctx, PeN, PeV);
    ctx_log_pred_write(ctx, PeN);
    tcg_temp_free(RdV);
    tcg_temp_free(PeV);
}

static void generate_F2_sffixupn(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sffixupn({ fHIDE(int adjust;) fSF_RECIP_COMMON(RsV,RtV,RdV,adjust); RdV = RsV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sffixupd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sffixupd({ fHIDE(int adjust;) fSF_RECIP_COMMON(RsV,RtV,RdV,adjust); RdV = RtV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_sfinvsqrta(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv PeV = tcg_temp_local_new();
    const int PeN = insn->regno[1];
    TCGv RsV = hex_gpr[insn->regno[2]];
    fGEN_TCG_F2_sfinvsqrta({ fHIDE(int idx;) fHIDE(int adjust;) fHIDE(int mant;) fHIDE(int exp;) if (fSF_INVSQRT_COMMON(RsV,RdV,adjust)) { PeV = adjust; idx = (RsV >> 17) & 0x7f; mant = (fSF_INVSQRT_LOOKUP(idx) << 15); exp = fSF_BIAS() - ((fSF_GETEXP(RsV) - fSF_BIAS()) >> 1) - 1; RdV = fMAKESF(fGETBIT(31,RsV),exp,mant); } });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    gen_log_pred_write(ctx, PeN, PeV);
    ctx_log_pred_write(ctx, PeN);
    tcg_temp_free(RdV);
    tcg_temp_free(PeV);
}

static void generate_F2_sffixupr(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_sffixupr({ fHIDE(int adjust;) fSF_INVSQRT_COMMON(RsV,RdV,adjust); RdV = RsV; });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_dfadd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfadd({ RddV=fUNDOUBLE(fDOUBLE(RssV)+fDOUBLE(RttV));});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfsub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfsub({ RddV=fUNDOUBLE(fDOUBLE(RssV)-fDOUBLE(RttV));});
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmax(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmax({ RddV = fUNDOUBLE(fDF_MAX(fDOUBLE(RssV),fDOUBLE(RttV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmin(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmin({ RddV = fUNDOUBLE(fDF_MIN(fDOUBLE(RssV),fDOUBLE(RttV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmpyfix(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmpyfix({ if (fDF_ISDENORM(RssV) && fDF_ISBIG(RttV) && fDF_ISNORMAL(RttV)) RddV = fUNDOUBLE(fDOUBLE(RssV) * 0x1.0p52); else if (fDF_ISDENORM(RttV) && fDF_ISBIG(RssV) && fDF_ISNORMAL(RssV)) RddV = fUNDOUBLE(fDOUBLE(RssV) * 0x1.0p-52); else RddV = RssV; });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmpyll(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_F2_dfmpyll(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmpylh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_F2_dfmpylh(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfmpyhh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmpyhh({ RxxV = fUNDOUBLE(fDF_MPY_HH(fDOUBLE(RssV),fDOUBLE(RttV),RxxV)); });
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfcmpeq(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpeq({PdV=f8BITSOF(fDOUBLE(RssV)==fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfcmpgt(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpgt({PdV=f8BITSOF(fDOUBLE(RssV)>fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfcmpge(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpge({PdV=f8BITSOF(fDOUBLE(RssV)>=fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfcmpuo(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpuo({PdV=f8BITSOF(isunordered(fDOUBLE(RssV),fDOUBLE(RttV)));});
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_F2_dfclass(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_dfclass({ fHIDE(int class;) PdV = 0; class = fpclassify(fDOUBLE(RssV)); if (fGETBIT(0,uiV) && (class == FP_ZERO)) PdV = 0xff; if (fGETBIT(1,uiV) && (class == FP_NORMAL)) PdV = 0xff; if (fGETBIT(2,uiV) && (class == FP_SUBNORMAL)) PdV = 0xff; if (fGETBIT(3,uiV) && (class == FP_INFINITE)) PdV = 0xff; if (fGETBIT(4,uiV) && (class == FP_NAN)) PdV = 0xff; fFPCANCELFLAGS(); });
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_dfimm_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_F2_dfimm_p(RddV, cpu_env, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_dfimm_n(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_F2_dfimm_n(RddV, cpu_env, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_sf2df(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2df({ RddV = fUNDOUBLE(conv_sf_to_df(fFLOAT(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_df2sf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2sf({ RdV = fUNFLOAT(conv_df_to_sf(fDOUBLE(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_uw2sf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_uw2sf({ RdV = fUNFLOAT(conv_4u_to_sf(fCAST4u(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_uw2df(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_uw2df({ RddV = fUNDOUBLE(conv_4u_to_df(fCAST4u(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_w2sf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_w2sf({ RdV = fUNFLOAT(conv_4s_to_sf(fCAST4s(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_w2df(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_w2df({ RddV = fUNDOUBLE(conv_4s_to_df(fCAST4s(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_ud2sf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_ud2sf({ RdV = fUNFLOAT(conv_8u_to_sf(fCAST8u(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_ud2df(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_ud2df({ RddV = fUNDOUBLE(conv_8u_to_df(fCAST8u(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_d2sf(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_d2sf({ RdV = fUNFLOAT(conv_8s_to_sf(fCAST8s(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_d2df(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_d2df({ RddV = fUNDOUBLE(conv_8s_to_df(fCAST8s(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_sf2uw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2uw({ RdV = fCAST4u(conv_sf_to_4u(fFLOAT(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_sf2w(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2w({ RdV = fCAST4s(conv_sf_to_4s(fFLOAT(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_sf2ud(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2ud({ RddV = fCAST8u(conv_sf_to_8u(fFLOAT(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_sf2d(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2d({ RddV = fCAST8s(conv_sf_to_8s(fFLOAT(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_df2uw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2uw({ RdV = fCAST4u(conv_df_to_4u(fDOUBLE(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2w(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2w({ RdV = fCAST4s(conv_df_to_4s(fDOUBLE(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2ud(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2ud({ RddV = fCAST8u(conv_df_to_8u(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2d(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2d({ RddV = fCAST8s(conv_df_to_8s(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_sf2uw_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2uw_chop({ fFPSETROUND_CHOP(); RdV = fCAST4u(conv_sf_to_4u(fFLOAT(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_sf2w_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2w_chop({ fFPSETROUND_CHOP(); RdV = fCAST4s(conv_sf_to_4s(fFLOAT(RsV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_F2_conv_sf2ud_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2ud_chop({ fFPSETROUND_CHOP(); RddV = fCAST8u(conv_sf_to_8u(fFLOAT(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_sf2d_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    fGEN_TCG_F2_conv_sf2d_chop({ fFPSETROUND_CHOP(); RddV = fCAST8s(conv_sf_to_8s(fFLOAT(RsV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_F2_conv_df2uw_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2uw_chop({ fFPSETROUND_CHOP(); RdV = fCAST4u(conv_df_to_4u(fDOUBLE(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2w_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2w_chop({ fFPSETROUND_CHOP(); RdV = fCAST4s(conv_df_to_4s(fDOUBLE(RssV))); });
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2ud_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2ud_chop({ fFPSETROUND_CHOP(); RddV = fCAST8u(conv_df_to_8u(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_F2_conv_df2d_chop(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2d_chop({ fFPSETROUND_CHOP(); RddV = fCAST8s(conv_df_to_8s(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_asr_r_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asl_r_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_asl_r_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_lsr_r_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_lsr_r_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_lsl_r_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_lsl_r_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_r_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asr_r_r_acc(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_r_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asl_r_r_acc(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_r_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsr_r_r_acc(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsl_r_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsl_r_r_acc(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_r_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p_acc(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p_acc(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p_acc(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p_acc(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asr_r_r_nac(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_r_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asl_r_r_nac(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_r_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsr_r_r_nac(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsl_r_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsl_r_r_nac(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_r_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p_nac(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p_nac(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p_nac(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p_nac(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asr_r_r_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_r_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asl_r_r_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_r_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsr_r_r_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsl_r_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsl_r_r_and(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_r_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asr_r_r_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_r_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_asl_r_r_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_r_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsr_r_r_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsl_r_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    gen_helper_S2_lsl_r_r_or(RxV, cpu_env, RxV, RsV, RtV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_r_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p_and(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p_and(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p_and(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p_and(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p_or(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p_or(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p_or(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p_or(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_p_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_p_xor(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_p_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_p_xor(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_p_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_p_xor(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_p_xor(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_p_xor(RxxV, cpu_env, RxxV, RssV, RtV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_r_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_asr_r_r_sat(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asl_r_r_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_asl_r_r_sat(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_i_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_lsr_i_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asl_i_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S6_rol_i_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_i_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r_acc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_i_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r_acc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_i_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_acc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S6_rol_i_r_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r_acc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_i_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p_acc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p_acc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p_acc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p_acc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p_acc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r_nac(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_i_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r_nac(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_i_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_nac(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S6_rol_i_r_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r_nac(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_i_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p_nac(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p_nac(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p_nac(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p_nac(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p_nac(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_r_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r_xacc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_i_r_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_xacc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S6_rol_i_r_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r_xacc(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_i_p_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p_xacc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p_xacc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p_xacc(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p_xacc(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r_and(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_i_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r_and(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_i_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_and(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S6_rol_i_r_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r_and(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_i_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r_or(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_lsr_i_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_r_or(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asl_i_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_or(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S6_rol_i_r_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_r_or(RxV, cpu_env, RxV, RsV, tcgv_uiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_asr_i_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p_and(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p_and(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p_and(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p_and(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p_and(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p_or(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_p_or(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_p_or(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_rol_i_p_or(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S6_rol_i_p_or(RxxV, cpu_env, RxxV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_r_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_r_sat(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_i_r_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_r_rnd(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_i_p_rnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_p_rnd(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_lsli(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_lsli(RdV, cpu_env, RtV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_addasl_rrri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RtV = hex_gpr[insn->regno[1]];
    TCGv RsV = hex_gpr[insn->regno[2]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_addasl_rrri(RdV, cpu_env, RtV, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S4_andi_asl_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_andi_asl_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_ori_asl_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_ori_asl_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_addi_asl_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_addi_asl_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_subi_asl_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_subi_asl_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_andi_lsr_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_andi_lsr_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_ori_lsr_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_ori_lsr_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_addi_lsr_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_addi_lsr_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S4_subi_lsr_ri(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_subi_lsr_ri(RxV, cpu_env, RxV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_valignib(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_valignib(RddV, cpu_env, RttV, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_valignrb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    TCGv PuV = hex_pred[insn->regno[3]];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_valignrb(RddV, cpu_env, RttV, RssV, PuV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vspliceib(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_vspliceib(RddV, cpu_env, RssV, RttV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vsplicerb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    TCGv PuV = hex_pred[insn->regno[3]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_vsplicerb(RddV, cpu_env, RssV, RttV, PuV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vsplatrh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vsplatrh(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_vsplatrb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vsplatrb(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S6_vsplatrbp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S6_vsplatrbp(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_insert(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S2_insert(RxV, cpu_env, RxV, RsV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_tableidxb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_S2_tableidxb(RxV, cpu_env, RxV, RsV, tcgv_uiV, tcgv_SiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_tableidxh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_S2_tableidxh(RxV, cpu_env, RxV, RsV, tcgv_uiV, tcgv_SiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_tableidxw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_S2_tableidxw(RxV, cpu_env, RxV, RsV, tcgv_uiV, tcgv_SiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_S2_tableidxd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_SiV = tcg_constant_tl(SiV);
    gen_helper_S2_tableidxd(RxV, cpu_env, RxV, RsV, tcgv_uiV, tcgv_SiV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
}

static void generate_A4_bitspliti(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_A4_bitspliti(RddV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A4_bitsplit(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_A4_bitsplit(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S4_extract(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_extract(RdV, cpu_env, RsV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_extractu(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S2_extractu(RdV, cpu_env, RsV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_insertp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S2_insertp(RxxV, cpu_env, RxxV, RssV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_extractp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S4_extractp(RddV, cpu_env, RssV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_extractup(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S2_extractup(RddV, cpu_env, RssV, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_mask(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    TCGv tcgv_UiV = tcg_constant_tl(UiV);
    gen_helper_S2_mask(RdV, cpu_env, tcgv_uiV, tcgv_UiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_insert_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RxV = tcg_temp_local_new();
    const int RxN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_insert_rp(RxV, cpu_env, RxV, RsV, RttV);
    gen_log_reg_write(RxN, RxV);
    ctx_log_reg_write(ctx, RxN);
    tcg_temp_free(RxV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_extract_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_extract_rp(RdV, cpu_env, RsV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_extractu_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_extractu_rp(RdV, cpu_env, RsV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_insertp_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RxxV = tcg_temp_local_new_i64();
    const int RxxN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RxxV, hex_gpr[RxxN],
                                 hex_gpr[RxxN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_insertp_rp(RxxV, cpu_env, RxxV, RssV, RttV);
    gen_log_reg_write_pair(RxxN, RxxV);
    ctx_log_reg_write_pair(ctx, RxxN);
    tcg_temp_free_i64(RxxV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S4_extractp_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S4_extractp_rp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_extractup_rp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_extractup_rp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_tstbit_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_tstbit_i(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_S4_ntstbit_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S4_ntstbit_i(PdV, cpu_env, RsV, tcgv_uiV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_S2_setbit_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_setbit_i(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_togglebit_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_togglebit_i(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_clrbit_i(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int uiV = insn->immed[0];
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_clrbit_i(RdV, cpu_env, RsV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_tstbit_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_tstbit_r(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_S4_ntstbit_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv PdV = tcg_temp_local_new();
    const int PdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S4_ntstbit_r(PdV, cpu_env, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
    ctx_log_pred_write(ctx, PdN);
    tcg_temp_free(PdV);
}

static void generate_S2_setbit_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_setbit_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_togglebit_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_togglebit_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_clrbit_r(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_clrbit_r(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_asr_i_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_vh(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_vh(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_vh(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_vh(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S5_asrhub_rnd_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S5_asrhub_rnd_sat(RdV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S5_asrhub_sat(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S5_asrhub_sat(RdV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S5_vasrhrnd(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S5_vasrhrnd(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_vh(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_vh(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_vh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_vh(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_vw(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_i_svw_trun(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asr_i_svw_trun(RdV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_svw_trun(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_svw_trun(RdV, cpu_env, RssV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_i_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_lsr_i_vw(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_i_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int uiV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_uiV = tcg_constant_tl(uiV);
    gen_helper_S2_asl_i_vw(RddV, cpu_env, RssV, tcgv_uiV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asr_r_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asr_r_vw(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_asl_r_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_asl_r_vw(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsr_r_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsr_r_vw(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_lsl_r_vw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv RtV = hex_gpr[insn->regno[2]];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_lsl_r_vw(RddV, cpu_env, RssV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vrndpackwh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vrndpackwh(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vrndpackwhs(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vrndpackwhs(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vsxtbh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vsxtbh(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_vzxtbh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vzxtbh(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_vsathub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsathub(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_svsathub(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_svsathub(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_svsathb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_svsathb(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_vsathb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsathb(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vtrunohb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vtrunohb(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vtrunewh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_vtrunewh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vtrunowh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_vtrunowh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vtrunehb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vtrunehb(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S6_vtrunehb_ppp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S6_vtrunehb_ppp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S6_vtrunohb_ppp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S6_vtrunohb_ppp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_vsxthw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vsxthw(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_vzxthw(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_vzxthw(RddV, cpu_env, RsV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_S2_vsatwh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsatwh(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vsatwuh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsatwuh(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_packhl(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S2_packhl(RddV, cpu_env, RsV, RtV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
}

static void generate_A2_swiz(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_A2_swiz(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_vsathub_nopack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsathub_nopack(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vsathb_nopack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsathb_nopack(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vsatwh_nopack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsatwh_nopack(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_vsatwuh_nopack(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_vsatwuh_nopack(RddV, cpu_env, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_shuffob(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_shuffob(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_shuffeb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_shuffeb(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_shuffoh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[2];
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_shuffoh(RddV, cpu_env, RttV, RssV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RttV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_shuffeh(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_shuffeh(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S5_popcountp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S5_popcountp(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_parity(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    TCGv RtV = hex_gpr[insn->regno[2]];
    gen_helper_S4_parity(RdV, cpu_env, RsV, RtV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_parityp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_parityp(RdV, cpu_env, RssV, RttV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_lfsp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_lfsp(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_clbnorm(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_clbnorm(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S4_clbaddi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    int siV = insn->immed[0];
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_clbaddi(RdV, cpu_env, RsV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S4_clbpnorm(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S4_clbpnorm(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S4_clbpaddi(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    int siV = insn->immed[0];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    TCGv tcgv_siV = tcg_constant_tl(siV);
    gen_helper_S4_clbpaddi(RdV, cpu_env, RssV, tcgv_siV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_cabacdecbin(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv_i64 RddV = tcg_temp_local_new_i64();
    const int RddN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_local_new_i64();
    const int RttN = insn->regno[2];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    tcg_gen_concat_i32_i64(RttV, hex_gpr[RttN],
                                 hex_gpr[RttN + 1]);
    gen_helper_S2_cabacdecbin(RddV, cpu_env, RssV, RttV);
    gen_log_reg_write_pair(RddN, RddV);
    ctx_log_reg_write_pair(ctx, RddN);
    tcg_temp_free_i64(RddV);
    tcg_temp_free_i64(RssV);
    tcg_temp_free_i64(RttV);
}

static void generate_S2_clb(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_clb(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_cl0(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_cl0(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_cl1(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv RsV = hex_gpr[insn->regno[1]];
    gen_helper_S2_cl1(RdV, cpu_env, RsV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
}

static void generate_S2_clbp(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
                Packet *pkt)
{
    TCGv RdV = tcg_temp_local_new();
    const int RdN = insn->regno[0];
    TCGv_i64 RssV = tcg_temp_local_new_i64();
    const int RssN = insn->regno[1];
    tcg_gen_concat_i32_i64(RssV, hex_gpr[RssN],
                                 hex_gpr[RssN + 1]);
    gen_helper_S2_clbp(RdV, cpu_env, RssV);
    gen_log_reg_write(RdN, RdV);
    ctx_log_reg_write(ctx, RdN);
    tcg_temp_free(RdV);
    tcg_temp_free_i64(RssV);
}

static void generate_S2_cl0p(
                CPUHexagonState *env,
                DisasContext *ctx,
                Insn *insn,
      