/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.app.Activity;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.os.Environment;
import android.view.OrientationEventListener;
import java.io.File;

public class QtMultimediaUtils {
    private static Activity m_activity = null;
    private static OrientationListener m_orientationListener = null;

    public static void setActivity(Activity activity, Object object) {
        m_activity = activity;
        m_orientationListener = new OrientationListener((Context)activity);
    }

    static void enableOrientationListener(boolean bl) {
        if (bl) {
            m_orientationListener.enable();
        } else {
            m_orientationListener.disable();
        }
    }

    static int getDeviceOrientation() {
        return OrientationListener.deviceOrientation;
    }

    static String getDefaultMediaDirectory(int n) {
        String string = new String();
        switch (n) {
            case 0: {
                string = Environment.DIRECTORY_MUSIC;
                break;
            }
            case 1: {
                string = Environment.DIRECTORY_MOVIES;
                break;
            }
            case 2: {
                string = Environment.DIRECTORY_DCIM;
                break;
            }
        }
        File file = new File("");
        file = n == 3 ? new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Sounds") : Environment.getExternalStoragePublicDirectory((String)string);
        file.mkdirs();
        return file.getAbsolutePath();
    }

    static void registerMediaFile(String string) {
        MediaScannerConnection.scanFile((Context)m_activity, (String[])new String[]{string}, null, null);
    }

    private static class OrientationListener
    extends OrientationEventListener {
        public static int deviceOrientation = 0;

        public OrientationListener(Context context) {
            super(context);
        }

        public void onOrientationChanged(int n) {
            if (n == -1) {
                return;
            }
            deviceOrientation = n;
        }
    }
}

