/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.purchasing;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import java.util.ArrayList;
import java.util.List;
import org.qtproject.qt5.android.purchasing.Security;

public class QtInAppPurchase
implements PurchasesUpdatedListener {
    private Context m_context = null;
    private String m_publicKey = null;
    private final long m_nativePointer;
    private int requestCode;
    private BillingClient billingClient;
    public static final int RESULT_OK = 0;
    public static final int RESULT_USER_CANCELED = 1;
    public static final int RESULT_BILLING_UNAVAILABLE = 3;
    public static final int RESULT_ITEM_UNAVAILABLE = 4;
    public static final int RESULT_DEVELOPER_ERROR = 5;
    public static final int RESULT_ERROR = 6;
    public static final int RESULT_ITEM_ALREADY_OWNED = 7;
    public static final int RESULT_ITEM_NOT_OWNED = 8;
    public static final int RESULT_QTPURCHASING_ERROR = 9;
    public static final String TAG = "QtInAppPurchase";
    public static final String TYPE_INAPP = "inapp";
    public static final int IAP_VERSION = 3;
    public static final int FAILUREREASON_NOFAILURE = 0;
    public static final int FAILUREREASON_USERCANCELED = 1;
    public static final int FAILUREREASON_ERROR = 2;

    public QtInAppPurchase(Context context, long l) {
        this.m_context = context;
        this.m_nativePointer = l;
    }

    public void initializeConnection() {
        this.billingClient = BillingClient.newBuilder((Context)this.m_context).enablePendingPurchases().setListener((PurchasesUpdatedListener)this).build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                if (billingResult.getResponseCode() == 0) {
                    QtInAppPurchase.this.queryPurchasedProducts();
                }
            }

            public void onBillingServiceDisconnected() {
                Log.w((String)QtInAppPurchase.TAG, (String)"Billing service disconnected");
            }
        });
    }

    public void onPurchasesUpdated(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
        int n = billingResult.getResponseCode();
        if (list == null) {
            this.purchaseFailed(this.requestCode, 2, "Data missing from result");
            return;
        }
        if (n == 1) {
            this.purchaseFailed(this.requestCode, 1, "");
            return;
        }
        if (n != 0) {
            String string;
            switch (n) {
                case 3: {
                    string = "Billing unavailable";
                    break;
                }
                case 4: {
                    string = "Item unavailable";
                    break;
                }
                case 5: {
                    string = "Developer error";
                    break;
                }
                case 6: {
                    string = "Fatal error occurred";
                    break;
                }
                case 7: {
                    string = "Item already owned";
                    break;
                }
                default: {
                    string = "Unknown billing error " + n;
                }
            }
            this.purchaseFailed(this.requestCode, 2, string);
            return;
        }
        for (Purchase purchase : list) {
            try {
                if (this.m_publicKey != null && !Security.verifyPurchase(this.m_publicKey, purchase.getOriginalJson(), purchase.getSignature())) {
                    this.purchaseFailed(this.requestCode, 2, "Signature could not be verified");
                    return;
                }
                int n2 = purchase.getPurchaseState();
                if (n2 != 1) {
                    this.purchaseFailed(this.requestCode, 2, "Unexpected purchase state in result");
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.purchaseFailed(this.requestCode, 2, exception.getMessage());
            }
            this.purchaseSucceeded(this.requestCode, purchase.getSignature(), purchase.getOriginalJson(), purchase.getPurchaseToken(), purchase.getOrderId(), purchase.getPurchaseTime());
        }
    }

    private void queryPurchasedProducts() {
        if (this.billingClient == null) {
            Log.e((String)TAG, (String)"queryPurchasedProducts: Client not initialized");
            return;
        }
        Object var1_1 = null;
        this.billingClient.queryPurchasesAsync(TYPE_INAPP, new PurchasesResponseListener(){

            public void onQueryPurchasesResponse(@NonNull BillingResult billingResult, @NonNull List<Purchase> list) {
                int n = billingResult.getResponseCode();
                if (n != 0) {
                    Log.e((String)QtInAppPurchase.TAG, (String)"queryPurchasedProducts: Failed to query purchase");
                    return;
                }
                for (Purchase purchase : list) {
                    String string = purchase.getSignature();
                    if (string == null) {
                        Log.e((String)QtInAppPurchase.TAG, (String)"queryPurchasedProducts: No Signature in purchase");
                        continue;
                    }
                    QtInAppPurchase.registerPurchased(QtInAppPurchase.this.m_nativePointer, (String)purchase.getSkus().get(0), string, purchase.getOriginalJson(), purchase.getPurchaseToken(), purchase.getOrderId(), purchase.getPurchaseTime());
                }
                QtInAppPurchase.purchasedProductsQueried(QtInAppPurchase.this.m_nativePointer);
            }
        });
    }

    public void queryDetails(String[] stringArray) {
        ArrayList<String> arrayList;
        final ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; i += arrayList.size()) {
            arrayList = new ArrayList<String>();
            for (int j = i; j < Math.min(i + 20, stringArray.length); ++j) {
                arrayList.add(stringArray[j]);
                arrayList2.add(stringArray[j]);
            }
            SkuDetailsParams.Builder builder = SkuDetailsParams.newBuilder();
            builder.setSkusList(arrayList).setType(TYPE_INAPP);
            this.billingClient.querySkuDetailsAsync(builder.build(), new SkuDetailsResponseListener(){

                public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> list) {
                    int n = billingResult.getResponseCode();
                    if (n != 0) {
                        Log.e((String)QtInAppPurchase.TAG, (String)"queryDetails: Couldn't retrieve sku details.");
                        return;
                    }
                    if (list == null) {
                        Log.e((String)QtInAppPurchase.TAG, (String)"queryDetails: No details list in response.");
                        return;
                    }
                    for (SkuDetails skuDetails : list) {
                        try {
                            if (skuDetails.getSku() == null || skuDetails.getPrice() == null || skuDetails.getTitle() == null || skuDetails.getDescription() == null) {
                                Log.e((String)QtInAppPurchase.TAG, (String)"Data missing from product details.");
                            } else {
                                arrayList2.remove(skuDetails.getSku());
                                String string = skuDetails.getSku();
                                String string2 = skuDetails.getPrice();
                                String string3 = skuDetails.getTitle();
                                String string4 = skuDetails.getDescription();
                                QtInAppPurchase.registerProduct(QtInAppPurchase.this.m_nativePointer, string, string2, string3, string4);
                            }
                            if (list.size() != list.indexOf(skuDetails) + 1) continue;
                            for (String string2 : arrayList2) {
                                QtInAppPurchase.queryFailed(QtInAppPurchase.this.m_nativePointer, string2);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public void setPublicKey(String string) {
        this.m_publicKey = string;
    }

    public void launchBillingFlow(String string, int n) {
        this.requestCode = n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        SkuDetailsParams.Builder builder = SkuDetailsParams.newBuilder();
        builder.setSkusList(arrayList).setType(TYPE_INAPP);
        this.billingClient.querySkuDetailsAsync(builder.build(), new SkuDetailsResponseListener(){

            public void onSkuDetailsResponse(@NonNull BillingResult billingResult, @Nullable List<SkuDetails> list) {
                int n = billingResult.getResponseCode();
                if (n != 0) {
                    String string;
                    Log.e((String)QtInAppPurchase.TAG, (String)("Unable to launch the purchase flow. Response code: " + n));
                    switch (n) {
                        case 3: {
                            string = "Billing unavailable";
                            break;
                        }
                        case 4: {
                            string = "Item unavailable";
                            break;
                        }
                        case 5: {
                            string = "Developer error";
                            break;
                        }
                        case 6: {
                            string = "Fatal error occurred";
                            break;
                        }
                        case 7: {
                            string = "Item already owned";
                            break;
                        }
                        default: {
                            string = "Unknown billing error " + n;
                        }
                    }
                    QtInAppPurchase.this.purchaseFailed(QtInAppPurchase.this.requestCode, 2, string);
                    return;
                }
                if (list == null) {
                    QtInAppPurchase.this.purchaseFailed(QtInAppPurchase.this.requestCode, 2, "Data missing from result");
                    return;
                }
                BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(list.get(0)).build();
                QtInAppPurchase.this.billingClient.launchBillingFlow((Activity)QtInAppPurchase.this.m_context, billingFlowParams);
            }
        });
    }

    public void consumePurchase(String string) {
        ConsumeResponseListener consumeResponseListener = new ConsumeResponseListener(){

            public void onConsumeResponse(BillingResult billingResult, String string) {
                if (billingResult.getResponseCode() != 0) {
                    Log.e((String)QtInAppPurchase.TAG, (String)("Unable to consume purchase. Response code: " + billingResult.getResponseCode()));
                    return;
                }
            }
        };
        ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(string).build();
        this.billingClient.consumeAsync(consumeParams, consumeResponseListener);
    }

    public void acknowledgePurchase(String string) {
        AcknowledgePurchaseParams acknowledgePurchaseParams = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(string).build();
        AcknowledgePurchaseResponseListener acknowledgePurchaseResponseListener = new AcknowledgePurchaseResponseListener(){

            public void onAcknowledgePurchaseResponse(BillingResult billingResult) {
                if (billingResult.getResponseCode() != 0) {
                    Log.e((String)QtInAppPurchase.TAG, (String)("Unable to acknowledge purchase. Response code: " + billingResult.getResponseCode()));
                    return;
                }
            }
        };
        this.billingClient.acknowledgePurchase(acknowledgePurchaseParams, acknowledgePurchaseResponseListener);
    }

    private void purchaseFailed(int n, int n2, String string) {
        QtInAppPurchase.purchaseFailed(this.m_nativePointer, n, n2, string);
    }

    private void purchaseSucceeded(int n, String string, String string2, String string3, String string4, long l) {
        QtInAppPurchase.purchaseSucceeded(this.m_nativePointer, n, string, string2, string3, string4, l);
    }

    private static native void queryFailed(long var0, String var2);

    private static native void purchasedProductsQueried(long var0);

    private static native void registerProduct(long var0, String var2, String var3, String var4, String var5);

    private static native void purchaseFailed(long var0, int var2, int var3, String var4);

    private static native void purchaseSucceeded(long var0, int var2, String var3, String var4, String var5, String var6, long var7);

    private static native void registerPurchased(long var0, String var2, String var3, String var4, String var5, String var6, long var7);
}

