--
-- Copyright (C) 2021  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with interfaces.c;

package globals is

	use interfaces.c;

	screenwidth : constant integer := 80;
	screenheight : constant integer := 24;

	playerwidth : constant integer := 5;
	playerposy : constant integer := screenheight-2; -- 22

	bunkerwidth: constant integer := screenwidth;
	bunkerheight: constant integer := 4;
	bunkerX: constant integer := 0;
	bunkerY: constant integer := screenheight-8; -- 16


	ufowidth : constant integer := 5;
	ufoposy : constant integer :=  0;

	myshoot, death, gameover, ufoloop,
	mykill,myUfoKill,vad1,vad2,vad3,vad4, intro : interfaces.c.int := -1;

	shootThreshold,
	weite, level,
	lives, score: integer := 0;

	vad: integer := 3; -- cycles within 0..3
	missedShots, shipnum: integer := 0;

	alienshot_counter : integer := 0;


	---------- game timing parameters: ----------

	-- Redrawing every time tick causes screen-flicker...
	-- Number of time ticks to skip between calls to draw
	-- Note that this must be coordinated/conformal with:
	-- missileMoveTics, weite, & deltaWeite.
	skip : constant integer := 3; -- increase IF flicker

	-- bounds for parm that controls alien move-speed.
	-- # ticks between alien steps; conformal with skip:
	--weiteHi: constant integer := 36; --starting weite
	weiteHi: constant integer := skip*12; --starting weite (36)
	weiteLo: constant integer := skip*2; --6 ending weite
	deltaRow: constant integer := skip; --28sep21 (was skip*2)
	deltaLevel: constant integer := skip*2; --28sep21 (was skip*2)
	-- note: weite = weiteHi - level * deltaWeite (at row 0)
	--       weite := weite - deltaWeite (at end of each row)

-- tick=0.025: works Ok with weite=20, skip=1
-- tick=0.02:  works Ok with weite=30, skip=3 (flicker@skip=1)

	-- loosely speaking, "tick" controls simulation speed;
	-- seconds between logical tests; critical gameplay setting...
	tick : constant duration := 0.02; -- 1/50 sec (50 fps)
	-- aliens should move about once each second @ level 1,
	-- with the sound to match, BUT the tick is much smaller.
	-- "globals.weite" defines number of ticks between alien steps.
	-- Finally, weite is reduced each step down (closer)
	-- to increase the alien speed.

	-- Next parm controls speed of all missiles...
	-- number of ticks between missile moves up/down...
	-- should be conformal with [multiple of] skip:
	playermissileTics : constant integer := skip*1; -- now 3, was 5
	alienmissileTics  : constant integer := skip*2; -- now 6, was 5

	-- per-tic-increment of alienshot_counter;
	-- when alienshot_counter exceeds shootThreshold
	-- then another missile is fired, bigger=>quicker:
	alienshotInc: constant integer := skip*3; --9 (was 10)

	-- control number of alien missiles fired; lower=>more.
	-- shootHi/alienshotInc (99/9=11 @ level=1) is the 
	-- number of ticks between alien missile shots,
	-- (decreases with level):
	shootHi: constant integer := skip*33; -- 99
	shootLo: constant integer := shootHi/3;
	shootInc: constant integer := skip*6; -- 18 (was 9)

procedure myassert( condition : boolean;  flag: integer:=0 );

end globals;

