separate(gameutils)

procedure InitGlfwFs( name: string; wid,hit,fwd,fht: in out glint ) is

	use system;
	use ada.strings.fixed;

	title : interfaces.c.strings.chars_ptr := new_string(name&ascii.nul);

	refrate, maj,min,rev : aliased glint;

	axs, ays : aliased float;
	awwid,awhit, afwid, afhit : aliased glint;

	redhatKin: boolean := false;
	idfilestr: constant string := "/etc/os-release";
	ifile: file_type;
	last: natural;
	linestr: string(1..255);

begin

	if linux 
	and then ada.directories.Exists(idfilestr) 
	then

		text_io.open(ifile, in_file, idfilestr);

		search: loop
			linestr:=(others=>' ');
			text_io.get_line(ifile,linestr,last);
			exit search when end_of_file(ifile);
			if index(linestr(1..last),"ID_LIKE",1) > 0 then
				if index(linestr(1..last),"rhel",1)>0 then redhatKin:=true; end if;
				if index(linestr(1..last),"centos",1)>0 then redhatKin:=true; end if;
				if index(linestr(1..last),"fedora",1)>0 then redhatKin:=true; end if;
				if index(linestr(1..last),"suse",1)>0 then redhatKin:=true; end if;
				if index(linestr(1..last),"opensuse",1)>0 then redhatKin:=true; end if;
				exit search;
			end if;
		end loop search;

		text_io.close(ifile);

	end if;



	put_line("...using fastrgv's Jan2020 Ada Binding to GLFW331...");

	GlfwGetVersion(maj'access,min'access,rev'access); --naturals
	put("GLFW ver: ");
	put(glint'image(maj));
	put(":"&glint'image(min));
	put(":"&glint'image(rev));
	New_Line;



	if GlfwInit /= gl_true then
		new_line;
		put_line("glfwInit failed");
		raise program_error;
	end if;

	-- use version here that your graphics card would support:
	GlfwWindowHint( glfw_context_version_major, 3);
	GlfwWindowHint( glfw_context_version_minor, 3);
	GlfwWindowHint( glfw_opengl_forward_compat, gl_true);
	GlfwWindowHint( glfw_opengl_profile, glfw_opengl_core_profile);

	GlfwWindowHint( glfw_samples, 4);
	GlfwWindowHint( glfw_client_api, glfw_opengl_api);




	declare
		vmode: access constant glfwVidMode 
			:= glfwGetVideoMode(glfwGetPrimaryMonitor);
	begin

		--get current video mode size [full screen]
		wid:=vmode.width;
		hit:=vmode.height;
		refrate:=vmode.refreshRate;

	end;


	if redhatKin then

		put_line("using RedHat glfw fullscreen workaround");
		mainWindow := glfwcreatewindow(
			wid, hit, title, null, null ); 

	else

		mainWindow := glfwcreatewindow(
			wid, hit, title, glfwGetPrimaryMonitor, null );

	end if;

--put("prelim Wid x Hit: ");
--put(glint'image(wid)); -- 1920
--put(" x ");
--put(glint'image(hit)); -- 1080 !!!
--put(" x ");
--put(glint'image(refrate)); --
--new_line;



		

	if mainWindow = null then
		new_line;
		put_line("glfwCreateWindow failed");
		raise program_error;
	end if;

	glfwmakecontextcurrent( mainWindow );


--HiDpi queries:
	glfwGetWindowSize(mainWindow, awwid'access, awhit'access);
	glfwGetFramebufferSize(mainWindow, afwid'access,afhit'access);
	glfwGetWindowContentScale(mainWindow, axs'access,ays'access);

	--assign out parms:
	Fwd:=afwid;
	Fht:=afhit;
	wid:=awwid;
	hit:=awhit;


	put_line("HighDpi Queries:");
	put_line("Wsize: "&glint'image(awwid)&","&glint'image(awhit));
	put_line("FrmBuf: "&glint'image(afwid)&","&glint'image(afhit));
	put_line("Scale: "&float'image(axs)&","&float'image(ays));

	if axs>1.5 or ays>1.5 then
		hidpi:=true;
	else
		hidpi:=false;
	end if;


	if glfwJoystickPresent(glfw_joystick_1)=glfw_true then

		if glfwJoystickIsGamepad(glfw_joystick_1)=glfw_true then
			put_line("Gamepad is present");
			gamepad:=true;
		else
			put_line("Joystick is present");
			joystik:=true;
		end if;

	end if;

	glfwSetInputMode(mainWindow, glfw_cursor, glfw_cursor_disabled);

	-- I don't think this code is needed:
	--if glfwRawMouseMotionSupported=glfw_true then
	--	put_line("setting RAW mouse motion");
	--	glfwSetInputMode(mainWindow,glfw_raw_mouse_motion, glfw_true);
	--else
	--	put_line("RAW mouse motion NOT supported");
	--end if;


	if    linux then put_line("system is linux");
	elsif mswin then put_line("system is MsWin");
	elsif   osx then put_line("system is OSX");
	end if;
	if hidpi then
		put_line("HiDpi");
	else
		put_line("NOT HiDpi");
	end if;

end InitGlfwFs;





