
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with matutils;  use matutils;
with gametypes;  use gametypes;


-- here is the latest Ada binding to SDL2-v2.0.9:
with sdl_h;  use sdl_h;
with sdl_scancode_inc; use sdl_scancode_inc;
with sdl_keyboard_h; use sdl_keyboard_h;
with sdl_mouse_h; use sdl_mouse_h;
with sdl_joystick_h; use sdl_joystick_h;
with sdl_gamecontroller_h; use sdl_gamecontroller_h;
with sdl_video_h; use sdl_video_h;
with sdl_hints_h; use sdl_hints_h;
with sdl_events_h; use sdl_events_h;
with sdl_timer_h; use sdl_timer_h;
with sdl_stdinc_h; use sdl_stdinc_h;
with sdl_version_h; use sdl_version_h;




with interfaces.c;
with interfaces.c.strings;
with glext;
with glext.pointers;
with glext.binding;
with gl;
with gl.binding;
with gl.pointers;





package gameutils is


	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;



	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");


	function odd( i: integer ) return boolean;

	function sqr( x: float ) return float;
	function min( x,y: float ) return float;
	function mini( i,j: integer ) return integer;



	function hordistance( x1,y1, x2,y2 : float ) return float;

	procedure moveforward( currenttime: float );
	procedure movebackward( currenttime: float );

	procedure first_prep;

	procedure InitSDL(  name: string );



	procedure updategamestate;
	procedure updateCamera(init: boolean := false);

	procedure updateMVPs( et, wid,hit : float; upd8: boolean:=false );

	procedure slewToAvLook;
	procedure slewToAv;




	procedure handle_mouse_move( nowTime : float );

	procedure handle_gc_look(gcx,gcy:sint16);
	procedure handle_gc_move(nowTime:float; gcx,gcy:sint16);


	function bitmatch( x,y : integer ) return boolean;


	procedure zeroBtns;

	procedure liftmaze;
	procedure slidelab;
	procedure liftlion;
	procedure liftgate( n: integer );



	function land_alt( x,z : float ) return float;

	procedure sendBat;
	procedure drawbat( et: float );
	procedure drawRdragon( et: float );
	procedure drawBdragon( et: float );
	procedure drawMinotaur( et: float );
	function angl( x1,y1,z1, x2,y2,z2 : float ) return float;

	procedure initializeNewMazes;


	function snakehiss return boolean;
	function nearsnake return boolean;

	procedure drawspider( et: float );


	procedure sort( 
		f2n: in out sortarray;  -- output permutations
		ox,oz : limarray;       -- pos of each object
		lo, hi : integer;       -- bounds of sort
		eyex,eyez : float       -- xme, zme
		);


	procedure emptyGLerrorQueue;

	function dumpGLerrorQueue(id: string) return integer;


	function atThreshold(	
		timenow: float; 
		str: string;
		sene: integer ) return boolean;


	procedure showWhatIsHeld;


	procedure insertgate( k: integer );


procedure updateBull( --28may18
	mytime, xme,zme: float;
	xm,ym,zm,am: in out float;
	idir: out integer;
	collide: out boolean
	);
procedure drawBull( 
	mytime, xb,yb,zb,hang : float;
	idir: integer
	);

procedure writeState;
procedure readState;
procedure setState;

end gameutils;
