#!/bin/sh
#
# Mac OS-X compile script for AdaVenture assuming the
# presence of GNAT2017, as well as
# Xcode and its g++ compiler.
#
# This script maximizes usage of static libs on OS-X
# using static SDL2,SFML, OpenAL libs
#
# with libopenal.a [v1.17.3] built from src from 
# https://github.com/kcat/openal-soft
#
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the 2015 GNU Ada compiler, gnatmake, is installed.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#====================================================================



# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi

# Xcode g++ compiler...
# prepare snd4ada.o file prior to gnatmake
g++ adabindings/sfmlAudio/snd4ada.cpp \
-c -Werror -fPIC -I$PWD/incSFML250

mv snd4ada.o ./obj/



##################################################
# Now, we use AdaCore2018:
export PATH=$HOME/opt/GNAT/2019/bin:$PATH


gnatmake  adaventure -O3  \
-o adaventure_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libglfw3.a \
$PWD/libs/osx/libiconv.a \
$PWD/libs/osx/libopenal.a \
$PWD/libs/osx/libsfml250-audio-s.a \
$PWD/libs/osx/libsfml250-system-s.a \
$PWD/libs/osx/libogg.a \
$PWD/libs/osx/libvorbis.a \
$PWD/libs/osx/libvorbisenc.a \
$PWD/libs/osx/libvorbisfile.a \
$PWD/libs/osx/libFLAC-static.a \
$PWD/libs/osx/libfreetype.a \
$PWD/libs/osx/libpng16.a \
$PWD/libs/osx/libbz2.a \
\
$PWD/obj/snd4ada.o \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-pthread

#mv ./obj/adaventure_osx_ss .
#cp adaventure_osx_ss adaventure_osx



# -- Copyright (C) 2018  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

