separate(gameutils)

procedure InitGlfwFs( name: string; wid,hit,fwd,fht: in out glint ) is

	use system;

	title : interfaces.c.strings.chars_ptr := new_string(name&ascii.nul);

	maj,min,rev : aliased glint;

	axs, ays : aliased float;
	awwid,awhit, afwid, afhit : aliased glint;

begin

	put_line("...using fastrgv's Jan2020 Ada Binding to GLFW331...");

	GlfwGetVersion(maj'access,min'access,rev'access); --naturals
	put("GLFW ver: ");
	put(glint'image(maj));
	put(":"&glint'image(min));
	put(":"&glint'image(rev));
	New_Line;



	if GlfwInit /= gl_true then
		new_line;
		put_line("glfwInit failed");
		raise program_error;
	end if;

	-- use version here that your graphics card would support:
	GlfwWindowHint( glfw_context_version_major, 3);
	GlfwWindowHint( glfw_context_version_minor, 3);
	GlfwWindowHint( glfw_opengl_forward_compat, gl_true);
	GlfwWindowHint( glfw_opengl_profile, glfw_opengl_core_profile);

	GlfwWindowHint( glfw_samples, 4);
	GlfwWindowHint( glfw_client_api, glfw_opengl_api);




	declare
		vmode: access constant glfwVidMode 
			:= glfwGetVideoMode(glfwGetPrimaryMonitor);
	begin

		--get current video mode size [full screen]
		wid:=vmode.width;
		hit:=vmode.height;

	end;

	mainWindow := glfwcreatewindow(
		wid, hit,	title, 
		glfwGetPrimaryMonitor, null );

--put("Wid x Hit: ");
--put(glint'image(wid)); --
--put(" x ");
--put(glint'image(hit)); --
--new_line;



		

	if mainWindow = null then
		new_line;
		put_line("glfwCreateWindow failed");
		raise program_error;
	end if;

	glfwmakecontextcurrent( mainWindow );


--HiDpi queries:
	glfwGetWindowSize(mainWindow, awwid'access, awhit'access);
	glfwGetFramebufferSize(mainWindow, afwid'access,afhit'access);
	glfwGetWindowContentScale(mainWindow, axs'access,ays'access);

	--assign out parms:
	Fwd:=afwid;
	Fht:=afhit;
	wid:=awwid;
	hit:=awhit;


	put_line("HighDpi Queries:");
	put_line("Wsize: "&glint'image(awwid)&","&glint'image(awhit));
	put_line("FrmBuf: "&glint'image(afwid)&","&glint'image(afhit));
	put_line("Scale: "&float'image(axs)&","&float'image(ays));

	if axs>1.5 or ays>1.5 then
		hidpi:=true;
	else
		hidpi:=false;
	end if;


	if glfwJoystickPresent(glfw_joystick_1)=glfw_true then

		if glfwJoystickIsGamepad(glfw_joystick_1)=glfw_true then
			put_line("Gamepad is present");
			gamepad:=true;
		else
			put_line("Joystick is present");
			joystik:=true;
		end if;

	end if;

	glfwSetInputMode(mainWindow, glfw_cursor, glfw_cursor_disabled);

	-- I don't think this code is needed:
	--if glfwRawMouseMotionSupported=glfw_true then
	--	put_line("setting RAW mouse motion");
	--	glfwSetInputMode(mainWindow,glfw_raw_mouse_motion, glfw_true);
	--else
	--	put_line("RAW mouse motion NOT supported");
	--end if;


	if    linux then put_line("system is linux");
	elsif mswin then put_line("system is MsWin");
	elsif   osx then put_line("system is OSX");
	end if;
	if hidpi then
		put_line("HiDpi");
	else
		put_line("NOT HiDpi");
	end if;

end InitGlfwFs;





