#!/bin/sh
#
# Mac compile script for AdaVenture
#
# Using sfml framework version 2.5.0
#
# The preferred, one-step script is ocmpss.sh
# uses mostly static libraries,  but an
# alternate system is this 2-step script:
# ocmp0.sh & ocmp1.sh and this is
# the 2nd of the two scripts.
#
# This uses local frameworks for freetype & sound.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#====================================================================



# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi

# we assume user has run ocmp0.sh BEFORE this script
# so that libsnd4ada.dylib is already in the
# ~/Frameworks directory...

# NOTE:  freetype.framework & libfreetype.dylib
# are under the local ~/Frameworks/ directory
###################################

##################################################
# Now, we use AdaCore2018:
export PATH=$HOME/opt/GNAT/2018/bin:$PATH

gnatmake  adaventure -O3  \
-o adaventure_osx_s \
--subdirs=./obj \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/sdl208ada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-I$PWD/adabindings/text \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libSDL2-208x.a \
$PWD/libs/osx/libiconv.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-pthread \
\
-Xlinker -rpath -Xlinker @loader_path/adaventure.app/Contents/Frameworks \
-Xlinker -rpath -Xlinker @loader_path/../Frameworks \
\
$PWD/adaventure.app/Contents/Frameworks/libsnd4ada.dylib \
-F$PWD/adaventure.app/Contents/Frameworks/ \
-framework freetype -framework OpenAL \
-framework sfml-audio -framework sfml-system \
-framework FLAC -framework ogg \
-framework vorbis -framework vorbisenc -framework vorbisfile




mv ./obj/adaventure_osx_s .
cp adaventure_osx_s adaventure_osx




# -- Copyright (C) 2018  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.


