
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------

-- here is the latest Ada binding to SDL2-v2.0.9:
with sdl_h;  use sdl_h;
with sdl_scancode_h; use sdl_scancode_h;
with sdl_keyboard_h; use sdl_keyboard_h;
with sdl_mouse_h; use sdl_mouse_h;
with sdl_joystick_h; use sdl_joystick_h;
with sdl_gamecontroller_h; use sdl_gamecontroller_h;
with sdl_video_h; use sdl_video_h;
with sdl_hints_h; use sdl_hints_h;
with sdl_events_h; use sdl_events_h;
with sdl_timer_h; use sdl_timer_h;
with sdl_stdinc_h; use sdl_stdinc_h;
with sdl_version_h; use sdl_version_h;


---------------------------

with ada.unchecked_conversion;
with ada.text_io; use ada.text_io;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

----------------------------------------------------------------


with shader;  use shader;

with cylobj;
with droomobj;
--with troomobj;
with bugobj;
with rectobj;
with rectxobj;
with rectxfineobj;
with rectsurfobj;
with avatarolay;
with pictobj;
with twictobj;
with xtreeobj;
--with wxtreeobj;
with w3treeobj;
with ztubeobj;


with cubemapobj;
with itemobj;
with ellipsoid;

with text_io;  use text_io;

with Tables;







package gametypes is


	type mazeRec is record
		x,z,dir: float;
	end record;
	package maze_table is new Tables(mazeRec);

	mtab: maze_table.Table;


	use gl;
	use matutils;
	use type interfaces.c.c_float;




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	thirdpi : constant float   := onepi/3.0;
	fourthpi : constant float  := onepi/4.0;
	eighthpi : constant float  := onepi/8.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;



package ellobj is new ellipsoid(20,20);
jupit : ellobj.eloid;



---------- begin game controller ----------------------------------------

cfgfile : string := "settings.txt";

Lsens, Rsens, -- paddle/joystick sensitivities
	Jsens : float := 0.8; --1.0; -- default

gshtl,gshtr,gjmp,
jshtl,jshtr,jjmp,  -- read from cfg file
jbak,jfor : glint; -- button maps

gamepad, joystik : boolean; --flags presence of game controllers
jsa : access SDL_JoyStick;
ctrl : access SDL_GameController;

axis_lx, axis_ly, axis_rx, axis_ry : Sint16;

--btn_2, btn_3, btn_4, btn_5, 
--btn_6, btn_7, btn_8, btn_9,
--btn_0, btn_1 : Uint8;


btn_pic1, btn_pic2,
btn_bak, btn_for, btn_slf, btn_srt: Uint8;


---------- end game controller ----------------------------------------



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright : integer;



	oldTimeKb : float := 0.0;
	mousestate : Uint32;
	deltaT : float;



	normbuff,
	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;











----- time variables ---------------------------------------------------
	currentTime,
	deltabtntime, lasttime,
	foldtime, boldtime, jumptime : float := -20.0;
----- time variables ---------------------------------------------------


	winwidth, winheight : interfaces.c.int := 500;







	bmvp, bmm,
	satmm, satmvp, satmv,
	pm,mv,imv,  mmvp, imvp :  mat44 := identity;



	nearpedestal: constant float := 0.8; --0.5;
	nearchalice: constant float := 1.0;

	rsword : constant float := 0.2;
	nearsword : constant float := 0.7; --0.5; --0.8;

	htobj: constant float := 0.02;
	rkey : constant float := 0.1;
	nearkey : constant float := 0.7; --0.5; --0.8;

	--signals nearby KO number if >0
	insertable: integer := 0;

	-- note that maze walls are composed of cubes
	-- of exactly 1 unit per side.  We don't want 
	-- to allow pickability of gateway when we are
	-- too close to center of cube.
	nearpgate : constant float :=1.2;
	toonearpgate : constant float := 0.6;

	-- closer than this to wall allows inserting gateway:
	mazeThreshold: constant float := 1.0;
	-- perhaps need a symbol to indicate insertability?

	neargate : constant float := 1.0;



	schalice : integer := 4;


	--associate gateway with KO#, scene#, row,col:
	kgate: integer := 0; -- => inactive, on ground
	sgate, rgate, cgate: integer := 0; --invalid values


	sgkey,
	sbkey,
	ssword,
	swkey: integer := 1; -- scene # that contains object

	xgate, ygate, zgate, -- purple gateway
	xgkey, ygkey, zgkey, -- green key to maze
	xbkey, ybkey, zbkey, -- black key to temple
	xsword,ysword,zsword,
	xwkey, ywkey, zwkey, -- white key to castle
	xme,yme,zme, 
	oxme,oyme,ozme: float := 0.0; -- virtual position


	fovrad : constant float := fourthpi;
	fovdeg : constant float := fourthpi*rad2deg;


	margin     : constant float := 0.2; --0.20; 18sep16
	aheight    : constant float := 0.5; --AvatarHeight

	oldstateExists,
	usersave,
	userexit : boolean := false;

	repassage: constant float := 2.0; --seconds between door crossings

	-- this must greater than margin
	here: constant float := 0.25;
	step: constant float := 0.28; --just beyond "here" threshold
	--threshold distance from maze transitions

	eps : constant float := 0.02; --dist maze gate from wall

	-- scene parms

	-- exterior dimensions
	xmax : constant float := 20.0;
	ymax : constant float := 20.0;
	zmax : constant float := 20.0;

	-- exterior User domain of (xme,zme), somewhat more limited
	-- so we don't encounter the edge of our flat world.
	xmaxu: constant float := 18.0;
	zmaxu: constant float := 18.0;

	ixmax : constant float :=10.0;
	iymax : constant float := 3.0; --1.5; -- 18nov19 (was 3.0;)
	izmax : constant float :=10.0;

	hmax: constant float := 0.0;
	wlev: constant float := 0.0;
	r1 : constant float := 10.0;
	r2 : constant float := 20.0;
	r3 : constant float := 30.0;



	skybox: cubemapobj.cubemap;



	hcup: constant float := 0.14;
	wcup: constant float := 0.07;

	xped,zped, yped : float;
	xchalice,ychalice,zchalice : float; --glfloat; 28oct19



	--fixed bug parms:
	beetrr: constant float := 0.1; -- x/z radius of 1 bug
	mxbo: constant integer := 60;
	mzbo: constant integer := 25;
	beetleobj : bugobj.bugsurf; -- 1 object for many bugs
	bugspeed : constant float := 0.5; --slow enough for eye to focus bugs





	jumping : boolean := false;
	pyjump : float := -ymax+aheight;
	vyjump : float := 0.0;



	roq,roz : pictobj.pictangle; --skylite (frame) 24nov19
	rox: rectxobj.rectx; --maze-ceiling uses fancy frag.shader

	mz: integer := 0; -- # maze walls defined
	
	mxbloks : constant integer := 25;  -- to build castle, maze
	mwall, wallblok : array(1..mxbloks) of rectobj.rectangle; --wall

	--avatar,
	zpwall,zmwall,xpwall,xmwall,
	lfloor,mfloor,tfloor,floor, rceil,
	wallxp, wallxm, wallzp, wallzm : rectobj.rectangle;

	chalice: xtreeobj.treeangle;
	tree: w3treeobj.treeangle;

	ixtmpl,iytmpl,iztmpl,
	 xtmpl, ytmpl, ztmpl : float;

	hwdoor: constant float := 0.8; --halfWidth
	fhdoor: constant float := 1.8; --fullHeight

	ymaze: float;
	xmaze: constant float := 7.0; --5.0;
	zmaze: constant float := 5.0; --4.4; --5.0-0.61;

	iymaze: constant float := -iymax+fhdoor/2.0;
	ixmaze: constant float :=  0.0;
	izmaze: constant float := -izmax;

	dmaze: constant float := 0.7; -- nearness defining "at-maze"
	ddoor: constant float := 0.4; -- nearness "atdoor"
	dtmpl: constant float := 0.9; -- nearness "attemple"



	xlab,ylab,zlab,
	xlion, ylion, zlion,
	ixdoor, iydoor, izdoor,
	xdoor,ydoor,zdoor: float;

	-- scene #5
	doorc, doord, doore, doorf, doorg,
	doory, doorz, doorv, doorw, doorx, ex5,

	-- scene #6
	doora1,doora2, doorb1, doorb2,
	doorv6,doorw6,doorx6,doory6,doorz6,
	doorc6,doord6,doore6,doorf6,doorg6,

	-- scene #7
	al7,ar7,bl7,br7,cl7,cr7,dl7,dr7,el7,er7,fl7,fr7, g7, h7,
	lg7,lh7, ex7, 
	
	-- scene #9
	lg9,

	-- scene #8
	g8,h8, eg8,eh8,

	-- scene #9
	al9,ar9, bl9,br9, cl9,cr9, fl9, fr9,
	dt9,db9, et9,eb9,

	imaze9door, imazedoor: pictobj.pictangle;

	beam12,
	dungdoor, sh7, --sg7,
	beam34,
	rsafe, rdoor,
	wallmoor,
	idung,
	omazedoor,
	bdragon,
	rdragon,

	minotaur,

	sword,
	pedestal,
	rug, ceil,
	porch, key1, key2, key3,
	gatem1,gatem2, gateway,
	gatexp, gatexm, gatezp, gatezm, zoro : pictobj.pictangle;

	korla: twictobj.twictangle;

	zpmural,
	ihallway, ohallway : pictobj.pictangle;



	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	axis : vec3 := ( others => 0.0 );




	rotx,roty,rotz : float := 0.0;

	maxnko : constant integer := 599;
	nko, level, oldlevel : integer := 0;


	korow, kocol,
	koscene: array(1..maxnko) of integer := (others=>100); --100 denotes undefined
	mazewall: array(1..maxnko) of boolean := (others=>false);

	koxlo, koxhi, koylo,koyhi, kozlo,kozhi : array(1..maxnko) of float;
	onledge : array(1..maxnko) of boolean;



------------------------ begin stuff from main -----------------------------

	mainWindow :  SDL_Window;
	mainGLContext : SDL_GLContext;




	contextFlags : sdl_windowflags;
	current : aliased SDL_DisplayMode;
	should_be_zero : glint;
	cursor : access SDL_Cursor;

	Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;


	--subtype keyindex is interfaces.c.int range 0..511;
	--type keyarraytype is array(keyindex) of Uint8;
	key_map : access keyarraytype;






	use gl;
	use matutils;
	use type interfaces.c.c_float;



	iskylight,
	pillar5, pillar6, pillar7,
	pillar8, pillar9, pillar10,
	pillar3, pillar4,
	pillar1, pillar2 : cylobj.cylinder;


	tfile: text_io.file_type;


	intro: boolean := true;

	hissbeat,
	drawchalice, chalicegone: boolean := false;


---------- begin texture pointers --------------------------------
	skylite_texid,
	sgate_texid,
	bull_texid,
	pool_texid,
	ball_texid,
	gleaves_texid, fern_texid, sand_texid, -- 29dec17

	moss_texid,
	keyhole_texid,
	slime_texid, 
	roots_texid,

	korla_texid,
	exit_texid,
	lab_texid,
	dmaze_texid,

	avatar_texid,
	snake_texid,

	tree1_texid, tree2_texid, tree3_texid,
	tree4_texid, tree5_texid, tree8_texid,
	spalm_texid, tpalm_texid,

	mural_texid,
	greekey_texid,
	adobe_texid,
	lion_texid,
	greenrockwall_texid,
	gmarble_texid,
	bmarble_texid,
	moorwall_texid,
	mazeouter_texid,
	mazeouter9_texid,
	mazex_texid,
	frame_texid,
	doort_texid,
	doortw_texid,
	hedge_texid,
	deadbdragon_texid,
	deadrdragon_texid,
	deadminotaur_texid,
	bat1_texid, bat2_texid,
	chalice_texid, sword_texid,
	cherry_texid, room_texid, ceil_texid, floor_texid, 
	rug_texid, bug_texid,
	wood_texid, 
	key_texid, 
	gkey_texid, bkey_texid,	gate_texid, zoro_texid,
	darkcubemap_texid, 
	sunnycubemap_texid,
	cloudycubemap_texid,
	mooncubemap_texid,
	grass1_texid,
	ava_texid,
	jup_texid,
	grass_texid, stone_texid : gluint := 0;

	atree2_texid: array(0..3) of gluint;

------------ end texture pointers ------------------------------------




	playSecs : float;

	package myint_io is new text_io.integer_io(integer);







-- begin string pointers for getUniformLocation: ---------------------

	phrad  : chars_ptr := new_string("hrad"&ascii.nul);
	phpos  : chars_ptr := new_string("hole"&ascii.nul);

	phang : chars_ptr := new_string("horiAng"&ascii.nul);

	psand : chars_ptr := new_string("sandLevel"&ascii.nul);
	ppid : chars_ptr := new_string("palmID"&ascii.nul);
	pmytime : chars_ptr := new_string("mytime"&ascii.nul);

	pmyfade : chars_ptr := new_string("fade"&ascii.nul);
	pmydir : chars_ptr := new_string("direction"&ascii.nul);

	pwPos : chars_ptr := new_string("wPos"&ascii.nul);
	pwRad : chars_ptr := new_string("wRad"&ascii.nul);

	--pnm : chars_ptr := new_string("NormalMatrix"&ascii.nul); --NOT needed

	pmv : chars_ptr := new_string("MV"&ascii.nul);
	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pdark : chars_ptr := new_string("darkness"&ascii.nul);

	pmylev : chars_ptr := new_string("foglevl"&ascii.nul);
	pmyclr : chars_ptr := new_string("fogcolr"&ascii.nul);

	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);
	popac : chars_ptr := new_string("NormalOpacity"&ascii.nul);
	pcubemap : chars_ptr := new_string("CubeMap"&ascii.nul);

	ptime : chars_ptr := new_string("time"&ascii.nul);
	presol : chars_ptr := new_string("resolution"&ascii.nul);


	prad  : chars_ptr := new_string("rad"&ascii.nul);
	pangl : chars_ptr := new_string("angl"&ascii.nul);
	pwvel : chars_ptr := new_string("wvel"&ascii.nul);
	pwamp : chars_ptr := new_string("wamp"&ascii.nul);


---------- addendum for lighting

	pflag : chars_ptr := new_string("lightFlag"&ascii.nul);
	--pnormal : chars_ptr := new_string("normalMatrix"&ascii.nul);

	ppcolor : chars_ptr := new_string("vPtCol"&ascii.nul);
	ppos : chars_ptr := new_string("vPtPos"&ascii.nul);
	peye : chars_ptr := new_string("eyePos"&ascii.nul);
	pmspc : chars_ptr := new_string("fracMspc"&ascii.nul);
	pmdif : chars_ptr := new_string("fracMdif"&ascii.nul);

	pmyopac : chars_ptr := new_string("opacity"&ascii.nul);

-- end string pointers for getUniformLocation: -------------------------






--------- begin new PIDs/UIDs ---------------------

	pidskyb01,
	pidterra02,
	pidfire03,
	pidstar04,
	pidtex05,
	pidcup06,
	pidava07, --avaTexShadID, 
	pidtree08,
	pidhole09,
	pidsky10, 
	pidsky11,
	pidsnake12,
	pidpool13,
	pidbull14: gluint; --PIDs

----------------------------------------


	mvpid01, mapid01,fcolid01,flevid01, 

	fcolid02, flevid02, eyeid02,
	mvpid02, sampid02, darkid02,
	
	mvpid03, sampid03, opacid03, timeid03, cenid03, radid03,

	timeid04,resid04,mvpid04,

	ndc05,
	eawe05, noso05,
	xdc05,zdc05,
	mvpid05,sampid05,flevid05,fcolid05,darkid05,
	lflagid05,lcolrid05,lposid05,eyeid05,ldifid05,lspcid05,

	mvpid06, sampid06, darkid06, cenid06, radid06,
	lcolrid06, lposid06, eyeid06, lflagid06, hangid06, flevid06, fcolid06,

	darkid07,fadid07,sampid07,hangid07,
	cenid07,mvpid07,timeid07,dirid07,

	fcolid08,flevid08,eyeid08,
	mvpid08,sampid08,darkid08,
	timeid08,trid08,baseid08,
	radid08, cenid08,

	mvpid09,sampid09,radid09,cenid09,
	darkid09,flevid09,fcolid09,
	lflagid09,lcolrid09,lposid09,eyeid09,ldifid09,lspcid09,

	mvpid10,resid10,timeid10,

	mvpid11,resid11,timeid11,

	mvpid12,sampid12,cenid12,radid12,
	anglid12,wvelid12,wampid12,
	darkid12,eyeid12, flevid12, fcolid12,

	eyeid13,darkid13,flevid13,fcolid13,
	mvpid13,timeid13,cenid13,radid13, wlevid13,
	
	imvp14, icen14, hang14, time14, samp14,idir14

	: glint; --UIDs


--------- end new PIDs/UIDs ---------------------





	j1,j2,j3,j4,j5,j6 : float; -- junk bounds to ignore

	xgxp,zgxp, xgxm,zgxm, xgzp,zgzp, xgzm,zgzm: float;

	gateheld,
	gkeyheld,
	bkeyheld, lionnear, labnear,
	seen1already, batested9, batested7, bat7sent, bat9sent,
	batested1, batested5, bat1sent, bat5sent, batfly, 
	bathaswkey, bathasbkey, bathaschalice,
	bdragondead, bdragonsent,
	rdragondead, rdragonsent, rdragonfly, bdragonfly,
	minosent, 
	minorun, minotaurdead,

	bkeyseen, wkeyseen, 
	pedestalnear,
	swordnear, chalicenear, swordheld, chaliceheld,
	interior, gatewait, 
	mazewait, lionwait, labwait,
	gkeynear, bkeynear,wkeynear, wkeyheld: boolean := false;

	mazenear, pgatenear, gatenear : boolean := false;

	openlab, openlion, openmaze, opengate : boolean := false;

	gk1,gk2, -- exterior maze gates
	wlabko, elabko,
	lko, -- lion gate
	gzpk,gzmk, gxpk,gxmk : integer;

	labopening,
	mazegoingup,
	labopen, gateopen,
	liongoingup, lionopen, mazeopen,
	xpup,xmup, zpup,zmup : boolean := false;

	mazetime,
	labtime, liontime, lifttime : float ;
	liftduration : constant float := 8.3; --seconds


tt, pltime, yg, elapsed: float := 0.0;
pickdwell : constant float := 0.3;



------------------------------ end stuff from main -----------------------------
cdo, mdo5, mdo6, 
	mdo9, mdo7, mdo8, tdo : droomobj.room; --castle, maze, temple
--tdo7: troomobj.room; --topless room


	nuscene, scene: integer := 0;

dragonduration: constant float := 7.0; --seconds
batduration: constant float := 30.0; --seconds



bsdra, rsdra : integer; --scene# of dragon death

mxdra,mydra,mzdra,
bxdra,bydra,bzdra,
rxdra,rydra,rzdra,
dragonstart, batstart,xbat,ybat,zbat: float;


-- this must exclude other nearby connections
samequad: constant float := 1.5; --threshold distance to neighbor maze

heralded, success : boolean := false;

----- begin new mazes -------------------------------------

	-- make consistent with interiors -10..10, -3..3, -10..10

	subtype scenerng is integer range 5..9; -- 5 multiply-connected parts
	mrows, mcols : constant integer := 10;
	mzwall : array(scenerng, -mrows..mrows, -mcols..mcols) of pictobj.pictangle;


	--passthru, --most convenient way to identify "shortcuts"

	iswall : array(scenerng, -mrows..mrows, -mcols..mcols) of boolean
		:= (others=>(others=>(others=>false)));


	package longtube is new ztubeobj(32); --25);
	snake : longtube.ztube;

	snake7rad, snake7angl, x7snake, z7snake,
	snake8rad, snake8angl, x8snake, z8snake,

	snake5angl, snake6angl, snake5rad, snake6rad,
	x6snake,z6snake, x5snake,z5snake : float;


	warning1, 
	--threshold,
	imdead_fireball,
	imdead_minotaur,
	imdead_dragon, imdead_snake: boolean := false;

	snakeVSsword: integer := 0;


--------- family of moorish columns with cornices ---------------

	pwaterlevel : chars_ptr := new_string("waterlevel"&ascii.nul);


	moorishpillar : array(0..4) of cylobj.cylinder;
	mpx,mpz : array(0..4) of float; -- pillar centers


	slab, edgezm,edgezp,edgexp : rectobj.rectangle; 
	-- interior roof to pillars, pool
	-- and sides of pool

	rr: float; --hole radius






	package newrectsurf is new rectsurfobj(40);
	rso : newrectsurf.rectsurf;


	nsortlimit: constant integer := 99;
	subtype nsortrng is integer range 0..nsortlimit;

	type sortarray is array(nsortrng) of integer;
	pfar2near, pnear2far, cf2n : sortarray;


	type limarray is array(nsortrng) of float;

	-- these describe locations of objects to be sorted:
	ox,oz : limarray := ( others => 0.0 );

	-- 1st subscript = no,so,ea,we
	-- 2nd subscript = pillar #
	hox, hoy, hoz : array(1..4,0..4) of float; --hole centers
	cornice : array(1..4,0..4) of rectobj.rectangle;

	bugEt, bugTimeStart: float := 0.0;
	bugThreshold: constant float := 15.0; --seconds
	imdead_bug, bugloop: boolean := false;

	-- soundIDs:
	evilBugs,
	wind1, ceph8, dama8, tmpl4,
	fanfare, stone, down, up, die, eat, roar, won,
	hiss, misr, turk, water, medusascream, girlyscream,
	monsterScream, womanScream: glint;


	resfile : string := "./data/resume_av.txt";

	major, minor, profile, flags, mtu :  glint;

-----------------------------------------------------------

	veldir, horiang, vertang : float := 0.0; -- avatar actual
	choriang : float := 0.0; -- cam actual
	ahoriang : float := 0.0; -- cam looking @ avatar

	ixcam,iycam,izcam,        -- ideal cam.pos
	xcam, ycam, zcam: float;  -- actual cam.pos

	cxlook,cylook,czlook,       -- actual camera orientation
		xlook,ylook,zlook : float := 0.0; -- avatar orientation = ideal camera

	thirdPerson, showingHand, showingGlyph: boolean := false;

	direction: integer;

	ava : avatarolay.avatar;

	--28may18:
	bull: avatarolay.avatar;
	bulltime: float := -20.0;
	xbull: float := +5.0;
	zbull: float := -5.0;
	ybull,
	hbull: float := -fourthpi; --0.0; --horiAng of bull
	dbull: integer;



	extdarkness,	
	extfogclr,
	extfoglev -- 14dec17
		: glint;

	okmultisamp: boolean := false;


-- lev: 0=>none, 1=>normal, 2=>dense, 3=>extreme fog
-- clr: 0=>true color, 1=>white, 2=>brown, 3=>purple, 4=>gray

-- glint == interfaces.c.int
--darkness : glint := 2; -- 0=none ... 4=darkest


-- castle2:
	castledarkness : constant glint := 3; --3; 
	pooldarkness : constant glint := 2; --2;
	foglev2 : constant glint := 0;
	fogclr2 : constant glint := 1;

type dctype is array(1..14) of float;

xdc,zdc: dctype := (others=>99.0);
noso, eawe : glint := 0;

	chapter: integer; --moved here 30oct19

--================chapter 2 below:

-- maze9:
	mazedarkness9 : glint := 4; --3; 
	foglev9: constant glint := 0;
	fogclr9: constant glint := 1;
	ndc9: constant glint:=13;
	xdc9,zdc9: dctype; --discard centers

--lab8:
	darkness8: constant glint := 2;
	foglev8 : constant glint := 1;
	fogclr8 : constant glint := 3;

--maze7
	darkness7 : constant glint := 2;
	foglev7 : constant glint := 2; --3;
	fogclr7 : constant glint := 1;
	ndc7: constant glint:=13;
	xdc7,zdc7: dctype; --discard centers


--================chapter 1 below:

--maze6
	darkness6 : constant glint := 2;
	foglev6 : constant glint := 2;
	fogclr6 : constant glint := 1;
	ndc6: constant glint:=14;
	xdc6,zdc6: dctype; --discard centers

--maze5
	darkness5 : constant glint := 2;
	foglev5 : constant glint := 2;
	fogclr5 : constant glint := 1;
	ndc5: constant glint:=10;
	xdc5,zdc5: dctype; --discard centers

	ndc8: constant glint:=2;
	xdc8,zdc8: dctype; --discard centers

--temple4
	darkness4 : constant glint := 2;
	foglev4 : constant glint := 1;
	fogclr4 : constant glint := 3;

--==========chapter 3/4 (dark chapter 1/2):
-- foglev:=3; --extreme (dense)
-- fogclr:=4; --gray color
-- darkness := 2;


	-- bounds for secret room (see avent-setup_maze9.adb)
	xmin9, xmax9, zmin9, zmax9: float; 

	stop9, stop4,
	play9, play4  --signal after 1st playing of chalice choir
		: boolean := false;	

-- castle bounds:
	x2c, z2c: constant float := -5.0;
	x2r, z2r: constant float := +5.0;
	y2c, y2r: constant float := iymax/2.0;



-------------------------------------------------

package fireballobj is new rectxfineobj(16);
fireball : fireballobj.rectfine;
barrad: constant float := 0.5; --radius of fireball


-----------------------------------------------------------




	-- Camera Standoff Parms:

	hoffset: constant float := 0.8; --4.0*margin; --0.8
	voffset: constant float := 0.1; --0.5*margin; --0.1

	ocamdist, camdist: float := 1.0;
	test_event: aliased SDL_Event;


	--linear move speed factor
	speed : constant float := 2.0;

	--keyboard angular speed factor:
	angrate1: constant float := 4.0; -- 1st person
	angrate3: constant float := 4.0; -- 3rd person

	lazyCam: boolean := true; --toggle between 2 camera types




-- begin Mappings of special characters in Font-Dictionary:
	bat1   : constant integer := 16; --123; ----"{"
	bat2   : constant integer := 18; --125; ----"}"

	blakey : constant integer := 17; --124; ----"|"
	whikey : constant integer := 19; --126; ----"~"
	grekey : constant integer := 20; -- 94; ----"^"

	hand   : constant integer :=  0; --0=normalHand, 3=splayedHand
	spider : constant integer := 11; -- 58; ----":"
	csword : constant integer := 14; -- 61; ----"="
	chalis : constant integer := 12; -- 59; ----";"
	gnu    : constant integer :=  1; -- 33; ----"!"

	bladra : constant integer := 15; -- 62; ----">"
	blakil : constant integer := 13; -- 60; ----"<"

	reddra : constant integer :=  9; -- 41; ----")"
	redkil : constant integer :=  8; -- 40; ----"("

	gatfar : constant integer :=  4; -- 36; ----"$"
	gatner : constant integer :=  5; -- 37; ----"%"

-- end Mappings of special characters in Font-Dictionary:

	statefile : constant string := "data/gamestate.txt";


end gametypes;

