
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_castle is

	i,k: integer;



procedure drawarches(k: integer) is
begin
		glbindtexture(gl_texture_2d, gmarble_texid);
		glUniform1f(radid09, glfloat(rr) );

		-- sort the arched "cornices" = rectangles with holes
		for ii in 1..4 loop
			ox(ii):=hox(ii,k);
			oz(ii):=hoz(ii,k);
		end loop;
		sort(cf2n,ox,oz,1,4,xme,zme);

		--now draw far to near
		for ii in 1..4 loop
			i:=cf2n(ii);
			glUniform3f(
				cenid09,
				glfloat(hox(i,k)),
				glfloat(hoy(i,k)),
				glfloat(hoz(i,k)) );
			rectobj.ldraw(cornice(i,k), vertbuff,uvbuff,normbuff,elembuff);
		end loop;

end drawarches;


	angl: float;

	kbeet: integer := 0;

	xeye,yeye,zeye: float;

begin
	if thirdPerson then
		xeye:=xcam; yeye:=ycam; zeye:=zcam;
	else
		xeye:=xme; yeye:=yme; zeye:=zme;
	end if;



		glUseProgram( pidtex05 );


gluniform1i(eawe05,0);
gluniform1i(noso05,0);



		gluniformmatrix4fv( mvpid05, 1, gl_false, imvp(1,1)'address );

		if success then
			gluniform1i(lflagid05,1); -- 1=>use light effects
			gluniform3f(lColrid05, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
			glUniform1i(darkid05, castledarkness); -- was -1
			gluniform1f(lspcid05, 0.5); --fracMspc (dflt=0.1)
		else
			gluniform1i(lflagid05,0); -- 0=>NO light effects
			gluniform3f(lColrid05, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
			glUniform1i(darkid05, castledarkness);
		end if;
		gluniform3f(lposid05, glfloat(xchalice),glfloat(ychalice),glfloat(zchalice) );

		gluniform3f(eyeid05, glfloat(xeye),glfloat(yeye),glfloat(zeye) );


		gluniform1i(sampid05,0);

		gluniform1i(flevid05, foglev2 ); 
		gluniform1i(fcolid05, fogclr2 ); 


		--moorish alcove
		glbindtexture(gl_texture_2d, moorwall_texid);
		pictobj.ldraw(wallmoor, vertbuff,uvbuff,normbuff,elembuff);


		--floor
		glbindtexture(gl_texture_2d, floor_texid);
		rectobj.ldraw(floor, vertbuff,uvbuff,normbuff,elembuff);

		--pedestal
		glbindtexture(gl_texture_2d, cherry_texid);
		pictobj.ldraw(pedestal, vertbuff,uvbuff,normbuff,elembuff);

		--tapestry
		glbindtexture(gl_texture_2d, rug_texid);
		pictobj.draw(rug, vertbuff,uvbuff,elembuff); --no shine on rug




		if not gkeyheld and sgkey=2  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;

		if not bkeyheld and sbkey=2 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=2 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=2 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;

		if not gateheld and sgate=2 and kgate=0 then
			glbindtexture(gl_texture_2d, frame_texid);
			pictobj.draw(gateway, vertbuff,uvbuff,elembuff);
		end if;




-------- begin reflective pool -------------------------------

			glUseProgram( pidpool13 );

--glbindtexture(gl_texture_2d, pool_texid);

		gluniform3f(eyeid13, glfloat(xeye),glfloat(yeye),glfloat(zeye) );


			gluniform1i(darkid13, pooldarkness);
			gluniform1i(flevid13, foglev2);
			gluniform1i(fcolid13, fogclr2);

			gluniformmatrix4fv( mvpid13, 1, gl_false, imvp(1,1)'address );
			gluniform1f(timeid13, glfloat(currentTime) );
			gluniform3f(cenid13, glfloat(mpx(0)), 0.1, glfloat(mpz(0)) );
			gluniform3f(radid13, 1.9, 0.1, 1.9 );
			gluniform1f(wlevid13, 0.15 ); --water level
			newrectsurf.draw(rso,vertbuff);

-------- end reflective pool -------------------------------





		glUseProgram( pidhole09 );
		gluniformmatrix4fv( mvpid09, 1, gl_false, imvp(1,1)'address );
		gluniform1i(sampid09,0);

		if success then
			gluniform1i(lFlagid09,1); -- 1=>use light effects
			gluniform3f(lColrid09, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
			glUniform1i(darkid09, castledarkness); -- was -1
			gluniform1f(lspcid09, 0.5); --fracMspc (dflt=0.1)
		else
			gluniform1i(lFlagid09,0); -- 0=>NO light effects
			gluniform3f(lColrid09, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
			glUniform1i(darkid09, castledarkness);
		end if;

		gluniform3f(lPosid09, glfloat(xchalice),glfloat(ychalice),glfloat(zchalice) );

		gluniform3f(eyeid09, glfloat(xeye),glfloat(yeye),glfloat(zeye) );


		gluniform1i(flevid09, foglev2 ); 
		gluniform1i(fcolid09, fogclr2 ); 

		glUniform1f(radid09, 0.0 );
		glbindtexture(gl_texture_2d, adobe_texid); --13oct16
		cylobj.draw(iskylight, vertbuff,uvbuff,elembuff);



-------------------------------------------------------------------
		--new frame as of 24nov19:
		glbindtexture(gl_texture_2d, sgate_texid);
		pictobj.draw(roq,vertbuff,uvbuff,elembuff);
-------------------------------------------------------------------




---------------------- begin room & ceiling -----------------------------
		-- we now draw room & ceiling here to draw
		-- a hole in the ceiling center:
		glUniform1f(radid09, 0.5 );
		glUniform3f(cenid09, -5.0, glfloat(iymax), -5.0 );

		--main interior
		glbindtexture(gl_texture_2d, adobe_texid);
		droomobj.ldraw(cdo,vertbuff,uvbuff,normbuff,elembuff); --textured room

		--ceiling
		glbindtexture(gl_texture_2d, ceil_texid);
		pictobj.ldraw(ceil, vertbuff,uvbuff,normbuff,elembuff);
---------------------- end room & ceiling -----------------------------

		glUniform1f(radid09, 0.0 ); --disable hole for other stuff



		-- I like the looks better without golden-discoloring
		-- of Korla, or the marble...
		gluniform1i(lFlagid09,0); -- 0=>NO light effects

		if success then
			angl:=currentTime*onepi*0.1;

			--draw rotating Korla Pandit
			twictobj.setrect2(korla,
				-5.0, 1.0, -5.0,      -- xc,yc,zc
				0.2,  0.3, 0.2, angl, -- xr,yr,zr,angle
				j1,j2,j3,j4,j5,j6);

			glbindtexture(gl_texture_2d, korla_texid);
			twictobj.draw(korla, vertbuff,uvbuff,elembuff);
		end if;


		glbindtexture(gl_texture_2d, bmarble_texid);
		rectobj.ldraw(slab, vertbuff,uvbuff,normbuff,elembuff); --pool roof

		--3 pool edges
		rectobj.ldraw(edgezm, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgezp, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgexp, vertbuff,uvbuff,normbuff,elembuff);


--------- begin pillar with cornices ------------------------------------------

		for ii in 0..4 loop
			ox(ii):=mpx(ii);
			oz(ii):=mpz(ii);
		end loop;
		sort( pfar2near, ox, oz, 0,4, xme,zme );

		glbindtexture(gl_texture_2d, bmarble_texid);
		for i in 0..4 loop
			k:=pfar2near(i);
			cylobj.draw(moorishpillar(k), vertbuff,uvbuff,elembuff);
		end loop;

		-- the only way I've found to make these arches
		-- look correct is to draw twice:

		-- draw arches:
		gldepthmask(gl_false);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;
		gldepthmask(gl_true);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;

--------- end pillar with cornices --------------------------------------------








	if drawchalice and schalice=2 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(pidcup06);

		glUniformMatrix4fv(mvpid06, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(sampid06, 0);
		gluniform1i(lFlagid06, 1 ); --light effects (always)
		glUniform1i(darkid06, 0); --castledarkness);
		if success then
			gluniform3f(lColrid06, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
		else
			gluniform3f(lColrid06, 30.0/255.0, 27.0/255.0, 2.0/255.0 ); --dddgold
		end if;
		glUniform1f(hangid06, 0.0);

		gluniform3f(lPosid06, glfloat(xchalice),glfloat(ychalice),glfloat(zchalice) );

		gluniform3f(eyeid06, glfloat(xeye),glfloat(yeye),glfloat(zeye) );



		glUniform3f(cenid06, glfloat(xchalice),glfloat(ychalice),glfloat(zchalice) );
		glUniform3f(radid06, glfloat(wcup), glfloat(hcup), glfloat(wcup) );

		gluniform1i(flevid06, 0); --foglev2 ); 
		gluniform1i(fcolid06, 0); --fogclr2 ); 

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.ldraw(chalice, vertbuff,uvbuff,normbuff,elembuff);
	end if;




	if scene=2 then
		showWhatIsHeld;
	end if;

end draw_castle;


