pragma Ada_2012;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with SDL_stdinc_h;
--limited with x86_64_linux_gnu_bits_types_FILE_h;
with x86_64_linux_gnu_bits_types_FILE_h; --fastrgv
with System;
with stddef_h;
with Interfaces.C.Strings;

package SDL_rwops_h is

   SDL_RWOPS_UNKNOWN : constant := 0;  --  ../../inc10/SDL2/SDL_rwops.h:42
   SDL_RWOPS_WINFILE : constant := 1;  --  ../../inc10/SDL2/SDL_rwops.h:43
   SDL_RWOPS_STDFILE : constant := 2;  --  ../../inc10/SDL2/SDL_rwops.h:44
   SDL_RWOPS_JNIFILE : constant := 3;  --  ../../inc10/SDL2/SDL_rwops.h:45
   SDL_RWOPS_MEMORY : constant := 4;  --  ../../inc10/SDL2/SDL_rwops.h:46
   SDL_RWOPS_MEMORY_RO : constant := 5;  --  ../../inc10/SDL2/SDL_rwops.h:47

   RW_SEEK_SET : constant := 0;  --  ../../inc10/SDL2/SDL_rwops.h:174
   RW_SEEK_CUR : constant := 1;  --  ../../inc10/SDL2/SDL_rwops.h:175
   RW_SEEK_END : constant := 2;  --  ../../inc10/SDL2/SDL_rwops.h:176

  --  Simple DirectMedia Layer
  --  Copyright (C) 1997-2019 Sam Lantinga <slouken@libsdl.org>
  --  This software is provided 'as-is', without any express or implied
  --  warranty.  In no event will the authors be held liable for any damages
  --  arising from the use of this software.
  --  Permission is granted to anyone to use this software for any purpose,
  --  including commercial applications, and to alter it and redistribute it
  --  freely, subject to the following restrictions:
  --  1. The origin of this software must not be misrepresented; you must not
  --     claim that you wrote the original software. If you use this software
  --     in a product, an acknowledgment in the product documentation would be
  --     appreciated but is not required.
  --  2. Altered source versions must be plainly marked as such, and must not be
  --     misrepresented as being the original software.
  --  3. This notice may not be removed or altered from any source distribution.
  -- 

  --*
  -- *  \file SDL_rwops.h
  -- *
  -- *  This file provides a general interface for SDL to read and write
  -- *  data streams.  It can easily be extended to files, memory, etc.
  --  

  -- Set up for C function definitions, even when using C++  
  -- RWops Types  
  --*
  -- * This is the read/write operation structure -- very basic.
  --  

  --*
  --     *  Return the size of the file in this rwops, or -1 if unknown
  --      

   type anon_74 is record
      autoclose : aliased SDL_stdinc_h.SDL_bool;  -- ../../inc10/SDL2/SDL_rwops.h:126
      fp : access x86_64_linux_gnu_bits_types_FILE_h.FILE;  -- ../../inc10/SDL2/SDL_rwops.h:127
   end record
   with Convention => C_Pass_By_Copy;
   type anon_75 is record
      base : access SDL_stdinc_h.Uint8;  -- ../../inc10/SDL2/SDL_rwops.h:132
      here : access SDL_stdinc_h.Uint8;  -- ../../inc10/SDL2/SDL_rwops.h:133
      stop : access SDL_stdinc_h.Uint8;  -- ../../inc10/SDL2/SDL_rwops.h:134
   end record
   with Convention => C_Pass_By_Copy;
   type anon_76 is record
      data1 : System.Address;  -- ../../inc10/SDL2/SDL_rwops.h:138
      data2 : System.Address;  -- ../../inc10/SDL2/SDL_rwops.h:139
   end record
   with Convention => C_Pass_By_Copy;
   type anon_73 (discr : unsigned := 0) is record
      case discr is
         when 0 =>
            stdio : aliased anon_74;  -- ../../inc10/SDL2/SDL_rwops.h:128
         when 1 =>
            mem : aliased anon_75;  -- ../../inc10/SDL2/SDL_rwops.h:135
         when others =>
            unknown : aliased anon_76;  -- ../../inc10/SDL2/SDL_rwops.h:140
      end case;
   end record
   with Convention => C_Pass_By_Copy,
        Unchecked_Union => True;
   type SDL_RWops;
   type SDL_RWops is record
      size : access function (arg1 : access SDL_RWops) return SDL_stdinc_h.Sint64;  -- ../../inc10/SDL2/SDL_rwops.h:57
      seek : access function
           (arg1 : access SDL_RWops;
            arg2 : SDL_stdinc_h.Sint64;
            arg3 : int) return SDL_stdinc_h.Sint64;  -- ../../inc10/SDL2/SDL_rwops.h:66
      read : access function
           (arg1 : access SDL_RWops;
            arg2 : System.Address;
            arg3 : stddef_h.size_t;
            arg4 : stddef_h.size_t) return stddef_h.size_t;  -- ../../inc10/SDL2/SDL_rwops.h:75
      write : access function
           (arg1 : access SDL_RWops;
            arg2 : System.Address;
            arg3 : stddef_h.size_t;
            arg4 : stddef_h.size_t) return stddef_h.size_t;  -- ../../inc10/SDL2/SDL_rwops.h:84
      close : access function (arg1 : access SDL_RWops) return int;  -- ../../inc10/SDL2/SDL_rwops.h:91
      c_type : aliased SDL_stdinc_h.Uint32;  -- ../../inc10/SDL2/SDL_rwops.h:93
      hidden : aliased anon_73;  -- ../../inc10/SDL2/SDL_rwops.h:141
   end record
   with Convention => C_Pass_By_Copy;  -- ../../inc10/SDL2/SDL_rwops.h:52

  --*
  --     *  Seek to \c offset relative to \c whence, one of stdio's whence values:
  --     *  RW_SEEK_SET, RW_SEEK_CUR, RW_SEEK_END
  --     *
  --     *  \return the final offset in the data stream, or -1 on error.
  --      

  --*
  --     *  Read up to \c maxnum objects each of size \c size from the data
  --     *  stream to the area pointed at by \c ptr.
  --     *
  --     *  \return the number of objects read, or 0 at error or end of file.
  --      

  --*
  --     *  Write exactly \c num objects each of size \c size from the area
  --     *  pointed at by \c ptr to data stream.
  --     *
  --     *  \return the number of objects written, or 0 at error or end of file.
  --      

  --*
  --     *  Close and free an allocated SDL_RWops structure.
  --     *
  --     *  \return 0 if successful or -1 on write error when flushing data.
  --      

  --*
  -- *  \name RWFrom functions
  -- *
  -- *  Functions to create SDL_RWops structures from various data streams.
  --  

  -- @{  
   function SDL_RWFromFile (file : Interfaces.C.Strings.chars_ptr; mode : Interfaces.C.Strings.chars_ptr) return access SDL_RWops  -- ../../inc10/SDL2/SDL_rwops.h:153
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWFromFile";

   function SDL_RWFromFP (fp : access x86_64_linux_gnu_bits_types_FILE_h.FILE; autoclose : SDL_stdinc_h.SDL_bool) return access SDL_RWops  -- ../../inc10/SDL2/SDL_rwops.h:157
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWFromFP";

   function SDL_RWFromMem (mem : System.Address; size : int) return access SDL_RWops  -- ../../inc10/SDL2/SDL_rwops.h:164
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWFromMem";

   function SDL_RWFromConstMem (mem : System.Address; size : int) return access SDL_RWops  -- ../../inc10/SDL2/SDL_rwops.h:165
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWFromConstMem";

  -- @}  
  -- RWFrom functions  
   function SDL_AllocRW return access SDL_RWops  -- ../../inc10/SDL2/SDL_rwops.h:171
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_AllocRW";

   procedure SDL_FreeRW (area : access SDL_RWops)  -- ../../inc10/SDL2/SDL_rwops.h:172
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_FreeRW";

  --*
  -- *  Return the size of the file in this rwops, or -1 if unknown
  --  

   function SDL_RWsize (context : access SDL_RWops) return SDL_stdinc_h.Sint64  -- ../../inc10/SDL2/SDL_rwops.h:181
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWsize";

  --*
  -- *  Seek to \c offset relative to \c whence, one of stdio's whence values:
  -- *  RW_SEEK_SET, RW_SEEK_CUR, RW_SEEK_END
  -- *
  -- *  \return the final offset in the data stream, or -1 on error.
  --  

   function SDL_RWseek
     (context : access SDL_RWops;
      offset : SDL_stdinc_h.Sint64;
      whence : int) return SDL_stdinc_h.Sint64  -- ../../inc10/SDL2/SDL_rwops.h:189
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWseek";

  --*
  -- *  Return the current offset in the data stream, or -1 on error.
  --  

   function SDL_RWtell (context : access SDL_RWops) return SDL_stdinc_h.Sint64  -- ../../inc10/SDL2/SDL_rwops.h:195
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWtell";

  --*
  -- *  Read up to \c maxnum objects each of size \c size from the data
  -- *  stream to the area pointed at by \c ptr.
  -- *
  -- *  \return the number of objects read, or 0 at error or end of file.
  --  

   function SDL_RWread
     (context : access SDL_RWops;
      ptr : System.Address;
      size : stddef_h.size_t;
      maxnum : stddef_h.size_t) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:203
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWread";

  --*
  -- *  Write exactly \c num objects each of size \c size from the area
  -- *  pointed at by \c ptr to data stream.
  -- *
  -- *  \return the number of objects written, or 0 at error or end of file.
  --  

   function SDL_RWwrite
     (context : access SDL_RWops;
      ptr : System.Address;
      size : stddef_h.size_t;
      num : stddef_h.size_t) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:212
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWwrite";

  --*
  -- *  Close and free an allocated SDL_RWops structure.
  -- *
  -- *  \return 0 if successful or -1 on write error when flushing data.
  --  

   function SDL_RWclose (context : access SDL_RWops) return int  -- ../../inc10/SDL2/SDL_rwops.h:220
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_RWclose";

  --*
  -- *  Load all the data from an SDL data stream.
  -- *
  -- *  The data is allocated with a zero byte at the end (null terminated)
  -- *
  -- *  If \c datasize is not NULL, it is filled with the size of the data read.
  -- *
  -- *  If \c freesrc is non-zero, the stream will be closed after being read.
  -- *
  -- *  The data should be freed with SDL_free().
  -- *
  -- *  \return the data, or NULL if there was an error.
  --  

   function SDL_LoadFile_RW
     (src : access SDL_RWops;
      datasize : access stddef_h.size_t;
      freesrc : int) return System.Address  -- ../../inc10/SDL2/SDL_rwops.h:235
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_LoadFile_RW";

  --*
  -- *  Load an entire file.
  -- *
  -- *  The data is allocated with a zero byte at the end (null terminated)
  -- *
  -- *  If \c datasize is not NULL, it is filled with the size of the data read.
  -- *
  -- *  If \c freesrc is non-zero, the stream will be closed after being read.
  -- *
  -- *  The data should be freed with SDL_free().
  -- *
  -- *  \return the data, or NULL if there was an error.
  --  

   function SDL_LoadFile (file : Interfaces.C.Strings.chars_ptr; datasize : access stddef_h.size_t) return System.Address  -- ../../inc10/SDL2/SDL_rwops.h:251
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_LoadFile";

  --*
  -- *  \name Read endian functions
  -- *
  -- *  Read an item of the specified endianness and return in native format.
  --  

  -- @{  
   function SDL_ReadU8 (src : access SDL_RWops) return SDL_stdinc_h.Uint8  -- ../../inc10/SDL2/SDL_rwops.h:259
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadU8";

   function SDL_ReadLE16 (src : access SDL_RWops) return SDL_stdinc_h.Uint16  -- ../../inc10/SDL2/SDL_rwops.h:260
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadLE16";

   function SDL_ReadBE16 (src : access SDL_RWops) return SDL_stdinc_h.Uint16  -- ../../inc10/SDL2/SDL_rwops.h:261
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadBE16";

   function SDL_ReadLE32 (src : access SDL_RWops) return SDL_stdinc_h.Uint32  -- ../../inc10/SDL2/SDL_rwops.h:262
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadLE32";

   function SDL_ReadBE32 (src : access SDL_RWops) return SDL_stdinc_h.Uint32  -- ../../inc10/SDL2/SDL_rwops.h:263
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadBE32";

   function SDL_ReadLE64 (src : access SDL_RWops) return SDL_stdinc_h.Uint64  -- ../../inc10/SDL2/SDL_rwops.h:264
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadLE64";

   function SDL_ReadBE64 (src : access SDL_RWops) return SDL_stdinc_h.Uint64  -- ../../inc10/SDL2/SDL_rwops.h:265
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_ReadBE64";

  -- @}  
  -- Read endian functions  
  --*
  -- *  \name Write endian functions
  -- *
  -- *  Write an item of native format to the specified endianness.
  --  

  -- @{  
   function SDL_WriteU8 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint8) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:274
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteU8";

   function SDL_WriteLE16 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint16) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:275
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteLE16";

   function SDL_WriteBE16 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint16) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:276
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteBE16";

   function SDL_WriteLE32 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint32) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:277
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteLE32";

   function SDL_WriteBE32 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint32) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:278
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteBE32";

   function SDL_WriteLE64 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint64) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:279
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteLE64";

   function SDL_WriteBE64 (dst : access SDL_RWops; value : SDL_stdinc_h.Uint64) return stddef_h.size_t  -- ../../inc10/SDL2/SDL_rwops.h:280
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_WriteBE64";

  -- @}  
  -- Write endian functions  
  -- Ends C function definitions when using C++  
  -- vi: set ts=4 sw=4 expandtab:  
end SDL_rwops_h;
