#!/bin/sh


if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# use the Xcode C++ compiler...
# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal



#--------------------------------------------------------


# set path to AdaCore gnat compiler...
# or delete next line if gnat is visible:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH

#fails using this:
#-mmacosx-version-min=10.5 \

gnatmake  adaventure -O3  \
-o adaventure_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs -lm -lz \
oal.o \
-lc++ \
$PWD/libs/osx/libglfw3.a \
$PWD/libs/osx/libfreetype.a \
$PWD/libs/osx/libpng16.a \
$PWD/libs/osx/libbz2.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 


