
# Mainline script for Linux
#
# linus compile script for adaventure
# suitable for AdaCore Ada
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libglfw.so

#########################################################
#
# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi



# set path to AdaCore gnat compiler...
# or delete next line if gnat is visible:
export PATH=$HOME/opt/GNAT/2021/bin:$PATH



# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal







gnatmake adaventure -o adaventure_gnu \
-O3 -gnat12 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs \
oal.o \
-lGL -lpthread -lstdc++ -lm -lz -lX11 \
-lopenal \
-Wl,-rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lfreetype -lpng12 \
-lglfw335


# Note that 9 libs must be found on target system
# in order to build & execute on linux:
#	(explicit:)
# libopenal.so.1
# libpthread.so.0
# libstdc++.so.6
# libz.so.1
# libm.so.6 
#	(implicit:)
# libdl.so.2
# librt.so.1 
# libc.so.6
# libgcc_s.so.1

# this version is not understood by GNU/GNAT:
#-Xlinker -rpath='$ORIGIN/libs/gnu' \

# -- Copyright (C) 2021  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

