
# Gocmp.sh : FAILs due to unresolved references
# in oal.o WHEN oal.cpp IS COMPILED WITH GNU ADA
#
# oal.o built with Xcode g++,
# remainder built with gcc v11.2.0 GNAT
#
# FLAWLESS:

# In nov2021 my Xcode was upgraded to 10.1 but
# my MacBookPro TBD files became "out-of-sync"
# with SDK libraries. Here, I give specific path
# to libraries & frameworks.


#!/bin/sh

# this ensures a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi



export GROOT=/opt/gcc-11.2.0/bin

# using the GNU g++ compiler...
# first, create oal.o:
$GROOT/g++ \
adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-std=c++11 \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal



#---------------------------------------------------

export PATH=$GROOT:$PATH

# set priority path to AdaCore compiler...
# or delete next line if GNAT is visible:
#export PATH=$HOME/opt/GNAT/2020/bin:$PATH

export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks



$GROOT/gnatmake  adaventure -O3  \
-o adaventure_osx_gnat112 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs \
oal.o \
$PWD/libs/osx/libglfw3.a \
$PWD/libs/osx/libfreetype.a \
$PWD/libs/osx/libpng16.a \
$PWD/libs/osx/libbz2.a \
\
-L$SDKROOT/usr/lib \
-lm -lz -lc++ \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 




# -- Copyright (C) 2021  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

