--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)

procedure first_prep is -- main program setup
	--rcd : string(1..80);
	linestr: string(1..9);
	last,last2: natural;
	HiRes: boolean := false;
begin

---------- prep transient sounds ----------------------------------------

	snd4ada_hpp.initSnds;

	laser := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/laser-gun.wav"),50);

	stone := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/concrete.ogg"),99);

	xport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/sci-fi.ogg"),40);

	wormx := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/worm8s.ogg"),40);

	kick := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/soccer-kick.wav"),99);

	beachkick := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/beachZpm.wav"),99);

	qport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/quick_portal.wav"),50);

	shriek := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/medusa.ogg"),99);

	kwush := snd4ada_hpp.initSnd(
		--Interfaces.C.Strings.New_String("data/kawhoosh.wav"),30);
		Interfaces.C.Strings.New_String("data/4sec_Kawoosh.ogg"),50);

------- now for the soundLoops --------------------------------------


	chatter := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/chimp-chatter-loop.wav"),40);

	kbub := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/nulava.ogg"),90); --stargate
		--Interfaces.C.Strings.New_String("data/bubbling.wav"),90);


	splash := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/splash.wav"),20);

	water := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/lake-waves-01.ogg"),70);

	lava := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/bubbling.ogg"),70);
		--Interfaces.C.Strings.New_String("data/nulava.ogg"),99);

	hum := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/hum.ogg"),50);

	beach := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/beach00.ogg"),99);

	falls := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/falls.ogg"),50);

	dark := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/dark-metal-electronic-loop.ogg"),50);

	gothic := snd4ada_hpp.initLoop(
		--Interfaces.C.Strings.New_String("data/gothic-dutch-trance.ogg"),30); in your face
		Interfaces.C.Strings.New_String("data/Opium-Loop.ogg"),30); --more subtle

	neptune := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/portals-to-neptune_loop.ogg"),50);

	choir := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/briefChurchChoir.ogg"),50);


	if laser<0 or stone<0 or xport<0 or kick<0 or qport<0 or shriek<0 
		or kwush<0 or chatter<0 or kbub<0
		or splash<0 or water<0 or lava<0 or hum<0 or beach<0 
		or falls<0 or dark<0 or gothic<0 or neptune<0 or choir<0 
	then
		put_line("snd4ada_hpp initializer error !");
		raise program_error;
	end if;



	-- assume level=0 => beach prologue...


	-- set default starting level, which will be overridden if
	-- there is a command line parm, or a non-empty restore file:
	level:= 0;

	if ada.directories.Exists(resfile) then 
	-- takes precedence over defaults
		put_line("Resume file found");
		text_io.open(tfile, in_file, resfile);
			linestr:=(others=>' ');
		text_io.get_line(tfile,linestr,last);
		myint_io.get(linestr(1..last),dod,last2); --30oct19
		myassert( dod>=1, 1012 );  
		myassert( dod<=5, 1013 );

		for i in 1..mxlev loop
			--myint_io.get(tfile,good); FAILS on DOS file
			linestr:=(others=>' ');
			text_io.get_line(tfile,linestr,last);
			myint_io.get(linestr(1..last),good,last2); --30oct19
			myassert( (good=0) or (good=1), 1014 );
			if (good=1) then
				solved(i):=true;
			else
				solved(i):=false;
			end if;
		end loop;
		text_io.close(tfile);
	else
		put_line("No resume file found");
	end if;




	-- before we call readPuzzle we should set "dod" [DegreeOfDifficulty] 
	-- as 1(easy), 2(medium), 3(hard), 4(harder), 5(advanced)
	-- but only in DEBUG mode, which is indicated by 2 cmdline args:

	dbug:=false;
	bkgd:=0;

	--debug mode only:
   if Ada.Command_Line.Argument_Count = 2 then -- 1) DOD, 2) bkgd#

		-- DEBUG-MODE: we ignore any resume file values:
		for i in 1..mxlev loop
			solved(i):=false; -- 9mar18
		end loop;
		dod:=1;
		level:=0;
		solved(0):=true;
		solved(5):=false;


	-- dflg in {-4..+5}:
	--  0=> skip flyover,  
	-- -1=>dbug mode adobe
	-- -2=>dbug mode wood
	-- -3=>dbug mode brick
	-- -4=>dbug mode granite 
	--
	--bkgd in {0..4} [ (only used if dflg=0): skybox#, 0=>sunny ... 4=>night ]
	--
	-- EG1: normal debug beach day(sb0):  "adagate_gnu 0 0"
	-- EG2: normal debug beach night(sb4):  "adagate_gnu 0 4"
	-- EG3: normal debug brick:  "adagate_gnu -3 0"
  
  		levdebug:=0;
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--dod level
       bstr : string := Ada.Command_Line.Argument(2);--bkgd
		 dflg : integer;
     begin
       myint_io.get(dstr,dflg,lst); -- overrides both previous, default
       myint_io.get(bstr,bkgd,lst); -- overrides both previous, default
		if dflg<0 and dflg>-5 then
			levdebug:=-dflg;
			for i in 1..4 loop solved(i):=false; end loop;
			dbug:=true;
			skipflyover:=true;
		elsif dflg<1 then
		 	skipflyover:=true; --skip flyover
			dbug:=true;
			dod:=1;
			myassert( 0<=bkgd, 551 );
			myassert( bkgd<=4, 552 );
			put_line("debug w/bkgd="&integer'image(bkgd));

		elsif dflg<=5 then
			dod:=dflg;
		else
			put_line("invalid DOD value...ignoring");
		end if;

		 exception
			when others =>
				put_line("...2 integers were expected...");
				put_line(" 3 x => jump to brick3");
				put_line(" 0 2 => debug using skybox2");
				raise;

     end; --declare
  

	--ONE CmdLineArg => HiRes flag (as of 1dec19):
   elsif Ada.Command_Line.Argument_Count = 1 then


		--iflg in {0,1}, 1=>HiDpi
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--level
		 iflg : integer;
     begin
       myint_io.get(dstr,iflg,lst); -- overrides both previous, default
		 if iflg>0 then
		 	HiRes:=true;
		 end if;

		 exception
			when others =>
				put_line("...a single integer was expected...");
				raise;

     end; --declare
   

   elsif Ada.Command_Line.Argument_Count > 2 then --TOO MANY ARGS...ABORT

	--DOD in {-4..+5}:
	--  0=> skip flyover,  
	-- -1=>dbug mode adobe
	-- -2=>dbug mode wood
	-- -3=>dbug mode brick
	-- -4=>dbug mode granite 
	--
	--bkgd in {0..4} [ 4=>night ]
 
		new_line;
     	put_line("Expect at most 2 command line parms:");
		put_line("DoD  in {-4...+5} (-4=>dbgGranite, 0=>skipFlyover)");
		put_line("beachBkgd in {0..4}");

     raise program_error;

   end if;


	if dbug then

		if ada.directories.Exists(resfile) then
			--delete it 4apr18
			ada.directories.Delete_File(resfile);
		end if;

	else
		put_line(" Puzzle Difficulty = " & integer'image(dod) );
	end if;



	InitGlfw("AdaGate",winwidth,winheight,Fwid,Fhit);


	playSecs := glfwGetTime;
	lastTime := playSecs;
	portalTime := lastTime-20.0;






	-- if any OGL errors already, spit them out
	-- to avoid misleading messages in utex
	nerr:=dumpGLerrorQueue("first_prep_1"); 

	--utex.inittext2d("data/sans3g.png", integer(winwidth),integer(winheight));
	utex.inittext2d("data/sans3g2.png", integer(winwidth),integer(winheight));
	put_line( "Window: wid-X-hit :" 
		& interfaces.c.int'image(winwidth)&" X "
		& interfaces.c.int'image(winheight) );



	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	-- from the literature it seems I might not have to
	-- call this explicitly because the first texture
	-- unit is the active texture unit, by default.
	-- And I have no multi-texturing needs yet,
	-- like a tarnish on top of an existing texture.
	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)


	glgenbuffers(1, normbuff'address);
	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );


	-- 6nov14  allow antialiasing if supported:
	glEnable(GL_MULTISAMPLE); -- default setting anyway!



	--minimal error test
	nerr:=dumpGLerrorQueue("first_prep_2");



	level:=0;
	solved(0):=true;
	solved(5):=false;




end first_prep;




