#version 330 core

// fragment shader reflective water pool

in vec3 position;    // water pos from vert.shader
in vec3 worldNormal; // water nrm from vert.shader

in vec4 aPos;

out vec4 color;


uniform samplerCube envMap;

const float pi = 3.14159;




//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=1; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int foglevl=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////



const float fStart=0.0;
const float fEnd=30.0;


float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}

const float yc=-2.85;




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 eyePos;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////



vec4 fixGamma( vec4 linearColor ) 
{

	// do gamma correction:
	vec3 gamma = vec3(1.0/2.2);
	vec3 finalColor = pow(linearColor.rgb,gamma);
	return vec4( finalColor, linearColor.a );

}



void main(){

	vec4 vEyePos = vec4( aPos.xyz-eyePos, 1.0 );

	float rx = eyePos.x/8;
	float rz = eyePos.z/20;
	float rxz = sqrt( rx*rx + rz*rz );

   vec3 eye = normalize(position-eyePos);
   vec3 r = reflect(eye, worldNormal);

	r.y=r.y*3.0; //adjust reflection depth
	r.x = r.x * 0.8*(1+rxz); //adjust reflection width
	r.x = r.x + eyePos.x/10; //translate reflection
	//note:  reflection accuracy can be checked by setting
	//wave amplitude to zero, and opacity to one.

   //color = fixGamma( texture(envMap, r) );
	// use above only if texhalf.fs uses fixGamma too.

   color = texture(envMap, r);
   // show off piranha:
	color.a = 0.4; //16jan17

	if(foglevl>1) {
		float dist2 = pow(vEyePos.x,2) + pow(vEyePos.z,2);
		float dist = abs( sqrt(dist2)/vEyePos.w );

		if( fogcolr==4 )
			color = mix(color,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			color = mix(color, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			color = mix(color, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			color = mix(color,  vFogColor, getFogFactor(dist)); //white

	}

	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - eyePos;
	vec3 cP2 =  port2 - eyePos;
	vec3 vP0 = aPos.xyz - eyePos;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}

}



//--
//-- Copyright (C) 2020  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

