#version 330 core

// StarTripV2     by I.G.P
// y position of mouse = travel speed


uniform float time;
//uniform vec2 mouse;
uniform vec2 resolution;
#define speed 8.0
#define kRotate 0.002
#define k2PI (2.*3.14159265359)
#define kStarDensity 0.4
#define kMotionBlur 0.2
#define kNumAngles 256.

out vec4 fragColor;

const float onepi = 3.14159;



vec2 rotate(vec2 p, float a)
{
	return vec2(p.x * cos(a) - p.y * sin(a), p.x * sin(a) + p.y * cos(a));
}



void main( void )
{

	// fastrgv:  lets put a spin on this...
	//           spin about the screen center:
	float ang = onepi*time/8.0;
	vec2 cen = resolution*0.5;
	vec2 vrad = gl_FragCoord.xy - cen;
	vec2 rot = cen + rotate( vrad, ang );

	vec2 position = .3*( rot.xy -  resolution.xy*.5 ) / resolution.x;
	//vec2 position = .3*( gl_FragCoord.xy -  resolution.xy*.5 ) / resolution.x;

	//position.x += 0.1*mouse.x - 0.05; // use this for mouse panning
	float angle0 = atan(position.y, position.x) / k2PI;
	float angle = fract(angle0 + kRotate*time);
	float rad = length(position);
	float angleFract = fract(angle*kNumAngles);
	float angleStep = floor(angle*kNumAngles)+1.;
	float angleToRandZ = 10.*fract(angleStep*fract(angleStep*.7535)*45.1);
	float angleSquareDist = fract(angleStep*fract(angleStep*.82657)*13.724);
	//float t = (speed+mouse.y*22.) * time - 222.*angleToRandZ;
	float t = speed * time - 222.*angleToRandZ;
	float angleDist = (angleSquareDist+0.1);
	float adist = angleDist/rad*kStarDensity;
	float dist = abs(fract((t*.1+adist))-.3);
	//float white1 = max(0.,1.0 - dist * 100.0 / ((kMotionBlur+mouse.y*3.0)*speed+adist));
	float white1 = max(0.,1.0 - dist * 100.0 / (kMotionBlur*speed+adist));
	float white2 = max(0.,(.5-.5*cos(k2PI * angleFract))*1./max(0.6,2.*adist*angleDist));
	float white = white1*white2;
	vec3 color = vec3(0.0);
	color.r = .03*white1 + white*(0.3 + 5.0*angleDist);
	color.b = white*(0.1 + .5*angleToRandZ);
	color.g = 1.5*white;
	fragColor = vec4( color, 1.0);
}


//--
//-- Copyright (C) 2020  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

