
separate (gameutils)


procedure setup_textures is  -- prepare dungeon textures
	use glext.binding;
begin 

	marstex := loadPng(repeat, "data/mars.png"); --use yseteli
	juptex := loadPng(repeat, "data/jupitermap.png"); --use yseteli


	--new fireball (level=3):
	pidfire01 := loadshaders("./data/fireball.vs", "./data/fireball.fs");
	imvp01 := glgetuniformlocation(pidfire01, pmvp);
	samp01  := glgetuniformlocation(pidfire01, pmyts);
	opac01  := glgetuniformlocation(pidfire01, pmyopac);
	time01  := glgetuniformlocation(pidfire01, ptime);
	icen01  := glgetuniformlocation(pidfire01, pwPos);
	irad01 := glgetuniformlocation(pidfire01, pwRad);
	side01:= glgetuniformlocation(pidfire01, pside);
	ieye01  := glgetuniformlocation(pidfire01, pme);
	lprt01:=glgetuniformlocation(pidfire01,pport1);
	rprt01:=glgetuniformlocation(pidfire01,pport2);

	ball_texid:= loadPng(mirror,"data/explosion2.png"); --radial color
	fireballobj.setrect(fireball);




	--new kwhoosh (level=0):
	--kwshadid
	pidkw02:= loadshaders("./data/kwhoosh.vs", "./data/kwhoosh2.fs");
	ilev02 := glgetuniformlocation(pidkw02,pmylevel);
	imvp02 := glgetuniformlocation(pidkw02, pmvp);
	samp02  := glgetuniformlocation(pidkw02, pmyts);
	--opac02  := glgetuniformlocation(pidkw02, pmyopac);
	time02  := glgetuniformlocation(pidkw02, ptime);
	icen02  := glgetuniformlocation(pidkw02, pwPos);
	irad02 := glgetuniformlocation(pidkw02, pwRad);
	--side02:= glgetuniformlocation(pidkw02, pside);
	ieye02  := glgetuniformlocation(pidkw02, pme);
	--lprt02:=glgetuniformlocation(pidkw02,pport1);
	--rprt02:=glgetuniformlocation(pidkw02,pport2);

	--a bit more like SG1 colors:
	kw_texid:= loadPng(mirror,"data/blugraygrad.png");

	--kwhooshobj.setrect(kwhoosh);
	kwhooshobj.yseteli(kwhoosh);









	--cartoon palmTree
	--x1picshadid 
	pidpic03:= loadshaders("data/picZ.vs", "data/palmTreeWindmill.fs");
	time03 := glgetuniformlocation(pidpic03, ptime);
	ires03  := glgetuniformlocation(pidpic03, presol);
	imvp03  := glgetuniformlocation(pidpic03, pmvp);
	irad03  := glgetuniformlocation(pidpic03, pwRad);
	icen03  := glgetuniformlocation(pidpic03, pwPos);
	--------------------------------------------------------------
	side03 := glgetuniformlocation(pidpic03, pside);
	ieye03 := glgetuniformlocation(pidpic03, pme);
	lprt03 :=glgetuniformlocation(pidpic03,pport1);
	rprt03 :=glgetuniformlocation(pidpic03,pport2);



	--waterworld
	--x2picshadid 
	pidpic04:= loadshaders("data/picZ.vs", "data/waterworldCCNCSA3.fs");
	time04 := glgetuniformlocation(pidpic04, ptime);
	ires04  := glgetuniformlocation(pidpic04, presol);
	imvp04  := glgetuniformlocation(pidpic04, pmvp);
	irad04  := glgetuniformlocation(pidpic04, pwRad);
	icen04  := glgetuniformlocation(pidpic04, pwPos);
	--------------------------------------------------------------
	side04 := glgetuniformlocation(pidpic04, pside);
	ieye04  := glgetuniformlocation(pidpic04, pme);
	lprt04:=glgetuniformlocation(pidpic04,pport1);
	rprt04:=glgetuniformlocation(pidpic04,pport2);



	--mountainscape
	--x2pic2shadid 
	pidpic05:= loadshaders("data/picZ.vs", "data/mountainscape.fs");

	time05 := glgetuniformlocation(pidpic05, ptime);
	ires05  := glgetuniformlocation(pidpic05, presol);
	imvp05  := glgetuniformlocation(pidpic05, pmvp);
	irad05  := glgetuniformlocation(pidpic05, pwRad);
	icen05  := glgetuniformlocation(pidpic05, pwPos);
	--------------------------------------------------------------
	side05 := glgetuniformlocation(pidpic05, pside);
	ieye05  := glgetuniformlocation(pidpic05, pme);
	lprt05:=glgetuniformlocation(pidpic05,pport1);
	rprt05:=glgetuniformlocation(pidpic05,pport2);



	--DaliClock
	--x3picshadid 
	pidpic06:= loadshaders("data/picZ.vs", "data/bwClock.fs");

	time06 := glgetuniformlocation(pidpic06, ptime);
	ires06  := glgetuniformlocation(pidpic06, presol);

	imvp06  := glgetuniformlocation(pidpic06, pmvp);

	irad06  := glgetuniformlocation(pidpic06, pwRad);
	icen06  := glgetuniformlocation(pidpic06, pwPos);
	--------------------------------------------------------------
	side06 := glgetuniformlocation(pidpic06, pside);
	ieye06  := glgetuniformlocation(pidpic06, pme);
	lprt06:=glgetuniformlocation(pidpic06,pport1);
	rprt06:=glgetuniformlocation(pidpic06,pport2);



	--MagmaPlanet
	--x3pic2shadid 
	pidpic07:= loadshaders("data/picZ.vs", "data/redPlanet.fs");
	time07 := glgetuniformlocation(pidpic07, ptime);
	ires07  := glgetuniformlocation(pidpic07, presol);

	imvp07  := glgetuniformlocation(pidpic07, pmvp);

	irad07  := glgetuniformlocation(pidpic07, pwRad);
	icen07  := glgetuniformlocation(pidpic07, pwPos);
	--------------------------------------------------------------
	side07 := glgetuniformlocation(pidpic07, pside);
	ieye07  := glgetuniformlocation(pidpic07, pme);
	lprt07:=glgetuniformlocation(pidpic07,pport1);
	rprt07:=glgetuniformlocation(pidpic07,pport2);


	--spinning Galaxy
	--x4picshadid 
	pidpic08:= loadshaders("data/picZ.vs", "data/blueSpiral.fs");
	time08 := glgetuniformlocation(pidpic08, ptime);
	ires08  := glgetuniformlocation(pidpic08, presol);
	imvp08  := glgetuniformlocation(pidpic08, pmvp);
	irad08  := glgetuniformlocation(pidpic08, pwRad);
	icen08  := glgetuniformlocation(pidpic08, pwPos);
	--------------------------------------------------------------
	side08 := glgetuniformlocation(pidpic08, pside);
	ieye08  := glgetuniformlocation(pidpic08, pme);
	lprt08:=glgetuniformlocation(pidpic08,pport1);
	rprt08:=glgetuniformlocation(pidpic08,pport2);



--------------------------------------------------------------------

	-- nice black&white clouds in a black sky (lightweight)
	--star2shadid 
	pidstar09:= loadshaders("data/skyX.vs", "data/bw2clouds.fs"); --gluint
	time09 := glgetuniformlocation(pidstar09, ptime); -- need glint
	ires09 := glgetuniformlocation(pidstar09, presol);
	imvp09 := glgetuniformlocation(pidstar09, pmvp);

	-- portal-exterior discard uniforms
	side09 := glgetuniformlocation(pidstar09, pside);
	ieye09 := glgetuniformlocation(pidstar09, pme);
	lprt09 := glgetuniformlocation(pidstar09,pport1);
	rprt09 := glgetuniformlocation(pidstar09,pport2);


--------------------------------------------------------------------
	--starshadid 
	pidstar10:= loadshaders("data/skyX.vs", "data/starfield4.fs"); --gluint
	time10 := glgetuniformlocation(pidstar10, ptime); -- need glint
	ires10 := glgetuniformlocation(pidstar10, presol);
	imvp10 := glgetuniformlocation(pidstar10, pmvp);

	-- portal-exterior discard uniforms
	side10 := glgetuniformlocation(pidstar10, pside);
	ieye10 := glgetuniformlocation(pidstar10, pme);
	lprt10 := glgetuniformlocation(pidstar10,pport1);
	rprt10 := glgetuniformlocation(pidstar10,pport2);




-- fish begin -------------------------------------------------------------
	--fishtexshadid 
	pidfish11:= loadshaders("data/fishw2.vs","data/fish.fs");
	imvp11 := glgetuniformlocation(pidfish11, pmvp);
	time11 := glgetuniformlocation(pidfish11, pmytime);
	icen11 := glgetuniformlocation(pidfish11, pwPos);

	flev11 := glgetuniformlocation(pidfish11, pmylev);

	irad11  := glGetUniformLocation( pidfish11, prad ); --RadPortal
	svel11 := glGetUniformLocation( pidfish11, psvel );     
	wvel11 := glGetUniformLocation( pidfish11, pwvel );     
	wamp11 := glGetUniformLocation( pidfish11, pwamp );

	arot11 := glGetUniformLocation( pidfish11, prot ); --28jan17

------ fish.fs:

	samp11  := glgetuniformlocation(pidfish11, pmyts);

	-- portal-exterior discard uniforms (fish.fs)
	side11 := glgetuniformlocation(pidfish11, pside);
	ieye11  := glgetuniformlocation(pidfish11, pme);
	lprt11:=glgetuniformlocation(pidfish11,pport1);
	rprt11:=glgetuniformlocation(pidfish11,pport2);



-- fish end -------------------------------------------------------------



	--poolshadid (lev#1)
	pidpool12:= loadshaders("data/poolobjFog.vs","data/bluwater.fs");

	--note: foglev defaulted to 1
	ieye12  := glgetuniformlocation(pidpool12, pme);

	imvp12 := glgetuniformlocation(pidpool12, pmvp);
	time12    := glgetuniformlocation(pidpool12, pmytime);
	wlev12    := glgetuniformlocation(pidpool12, pwaterlevel);
	irad12    := glgetuniformlocation(pidpool12, pwRad);
	icen12    := glgetuniformlocation(pidpool12, pwPos);

	side12 := glgetuniformlocation(pidpool12, pside);
	lprt12:=glgetuniformlocation(pidpool12,pport1);
	rprt12:=glgetuniformlocation(pidpool12,pport2);


--------------------------------------------------------------------

	--dpooltexshadid (lev#4)
	pidpool13:= loadshaders("data/poolobjFog.vs","data/darkwater.fs");

	--note:  foglev,fogclr defaulted
	ieye13  := glgetuniformlocation(pidpool13, pme);

	imvp13 := glgetuniformlocation(pidpool13, pmvp);
	time13    := glgetuniformlocation(pidpool13, pmytime);
	wlev13    := glgetuniformlocation(pidpool13, pwaterlevel);
	irad13    := glgetuniformlocation(pidpool13, pwRad);
	icen13    := glgetuniformlocation(pidpool13, pwPos);

	side13 := glgetuniformlocation(pidpool13, pside);
	lprt13:=glgetuniformlocation(pidpool13,pport1);
	rprt13:=glgetuniformlocation(pidpool13,pport2);



--------------------------------------------------------------------

	--lava pool lev#3:

	pidpool15:= loadshaders("data/lavaPool.vs", "data/lavaPool.fs");--7apr20

	imv15 := glgetuniformlocation(pidpool15, pmv);
	imvp15 := glgetuniformlocation(pidpool15, pmvp);
	ires15  := glgetuniformlocation(pidpool15, presol);
	time15 := glgetuniformlocation(pidpool15, ptime);
	mtime15 := glgetuniformlocation(pidpool15, pmytime);
	wlev15 := glgetuniformlocation(pidpool15, pwaterlevel);
	irad15 := glgetuniformlocation(pidpool15, pwRad);--(xprad,yprad,zprad)
	icen15 := glgetuniformlocation(pidpool15, pwPos);--(xpcen,ypcen,zpcen)

	side15 := glgetuniformlocation(pidpool15, pside);
	lprt15:=glgetuniformlocation(pidpool15,pport1);
	rprt15:=glgetuniformlocation(pidpool15,pport2);

	--note: foglevl,fogcolr defaulted
	ieye15  := glgetuniformlocation(pidpool15, pme);
	samp15  := glgetuniformlocation(pidpool15, pmyts);



------- begin primary shader with lighting ---------------------------
	--pgmtexshadid 
	pidpgm16:= loadshaders("./data/texhalf.vs", "./data/texhalf.fs");
	irad16:= glgetuniformlocation(pidpgm16,pprad); 
	isel16:= glgetuniformlocation(pidpgm16,pisel); 
	lprt16:=glgetuniformlocation(pidpgm16,pport1);
	rprt16:=glgetuniformlocation(pidpgm16,pport2);
	imvp16 := glgetuniformlocation(pidpgm16, pmvp);
	samp16  := glgetuniformlocation(pidpgm16, pmyts);

	flev16  := glgetuniformlocation(pidpgm16, pmylev); --fog
	fcol16  := glgetuniformlocation(pidpgm16, pmyclr); --fog

	opac16 := glgetuniformlocation(pidpgm16, popac); --to reduce opacity

	side16 := glgetuniformlocation(pidpgm16, pside);
	ieye16  := glgetuniformlocation(pidpgm16, pme);

--------------- begin lighting effects addendum ----------------------
	flag16 := glgetuniformlocation(pidpgm16, pflag); --lightingEffects flag
	-- set to zero unless object defines normals

	lcol16 := glgetuniformlocation(pidpgm16, ppcolor);
	posa16 := glgetuniformlocation(pidpgm16, ppos1);
	posb16 := glgetuniformlocation(pidpgm16, ppos2);
	posc16 := glgetuniformlocation(pidpgm16, ppos3);

------- end typical lighting shaders -----------------------------------





------- begin turtle shaders ------------------------------------
	--tpgmtexshadid (lev#3)
	pidpgm17 := loadshaders("./data/turtle.vs", "./data/turt.fs");
	imvp17 := glgetuniformlocation(pidpgm17, pmvp); -- vs2
	samp17  := glgetuniformlocation(pidpgm17, pmyts); -- fs1

	icen17   := glgetuniformlocation(pidpgm17, pwPos); -- vs5
	angl17   := glgetuniformlocation(pidpgm17, pangl); -- vs6

	flev17  := glgetuniformlocation(pidpgm17, pmylev); --FOG fs11
	fcol17  := glgetuniformlocation(pidpgm17, pmyclr); --FOG fs11

	-- portal-exterior-discard uniforms
	side17 := glgetuniformlocation(pidpgm17, pside); -- fs7
	ieye17  := glgetuniformlocation(pidpgm17, pme); -- fs10
	lprt17:=glgetuniformlocation(pidpgm17,pport1);
	rprt17:=glgetuniformlocation(pidpgm17,pport2);


	----------------- begin lighting effects addendum ----------------
	flag17 := glgetuniformlocation(pidpgm17, pflag); -- flag fs2 vs4
	-- set to zero unless object defines normals
	-- and lighting effects are desired

	lcol17 := glgetuniformlocation(pidpgm17, ppcolor); -- fs3
	posa17 := glgetuniformlocation(pidpgm17, ppos1); -- fs4
	posb17 := glgetuniformlocation(pidpgm17, ppos2); -- fs5
	posc17 := glgetuniformlocation(pidpgm17, ppos3); -- fs6

	----------------- end lighting effects addendum ----------------

------- end turtle shaders --------------------------------------

	turtle_texid := loadPng(mirror,"data/turtbody2.png"); 
	turhead_texid := loadPng(mirror,"data/turthead4.png"); 

	turtleobj.setround(turtle, 0.4, 0.3, 0.5);
	turtleobj.setround(turhead, 0.1, 0.05, 0.2);

	-- 16 uniforms 11fs, 6vs (1 used twice)











--------------------------------------------------------------------

	-- level 2 reflective pool:
	--rpoolshadid  (lev#2)
	pidpool14:= loadshaders("data/reflwater.vs", "data/reflwater.fs");
	--note:  fogcolr,foglevl use defaulted values
	envm14 := glgetuniformlocation(pidpool14, penvmap);
	ieye14 := glgetuniformlocation(pidpool14, peyePos);
	imvp14 := glgetuniformlocation(pidpool14, pmvp);
	time14 := glgetuniformlocation(pidpool14, pmytime);
	wlev14 := glgetuniformlocation(pidpool14, pwaterlevel);
	irad14 := glgetuniformlocation(pidpool14, pwRad);
	icen14 := glgetuniformlocation(pidpool14, pwPos);

	side14 := glgetuniformlocation(pidpool14, pside);
	lprt14:=glgetuniformlocation(pidpool14,pport1);
	rprt14:=glgetuniformlocation(pidpool14,pport2);


	-- level 2 reflective pool;  
	-- Here, only used as reflective environment, but not drawn.
	-- ...in this case, a close match to actual environment...
	cubemap_texid := loadCubePng(
	"data/woodsq.png","data/woodsq.png",
	"data/woodsq.png","data/woodsq.png", --small but Ok for EnvCubeMap
	"data/woodsq.png","data/woodsq.png");




------ begin level 5 epilog setup ------------------------------------

	-- pretty awesome:
	-- used as reflective environment, but also drawn
	circubemap_texid := loadCubePng(
	"data/skyBoxes/totality/ft.png",	"data/skyBoxes/totality/bk.png",
	"data/skyBoxes/totality/upmsg.png",	"data/skyBoxes/totality/dn.png",
	"data/skyBoxes/totality/rt.png",	"data/skyBoxes/totality/lf.png"	);

	--pidskyb
	pidskyb18 := loadshaders("data/osky.vs", "data/osky.fs");
	imvp18 := glgetuniformlocation(pidskyb18, pmvp);
	cmap18 := glgetuniformlocation(pidskyb18, pcubemap);

	--pidskyw 
	pidskyw19:= loadshaders("data/sundown.vs", "data/sundown.fs");
	imvp19  := glgetuniformlocation(pidskyw19, pmvp);
	time19  := glgetuniformlocation(pidskyw19, pmytime);
	wlev19  := glgetuniformlocation(pidskyw19, pwaterlevel);
	ieye19  := glgetuniformlocation(pidskyw19, peyePos);
	envm19  := glgetuniformlocation(pidskyw19, penvMap);

------ end level 5 epilog setup --------------------------------------



-- load textures used in all levels:


	lining_texid := loadPng(mirror,"data/bricksr.png");

	opaqueport_texid := loadPng(mirror,"data/stargate_opaque.png");
	port_texid := loadPng(mirror,"data/stargate_texture.png");
	offport_texid := loadPng(mirror,"data/stargate_off.png");
	xbox1_texid := loadPng(mirror,"data/door.png");
	xbox2_texid := loadPng(mirror,"data/stargate_off.png");
	xbox3_texid := loadPng(mirror,"data/stargate_fade.png");
	barloc0_texid:= loadPng(mirror,"data/stargate_off.png");
	offportr_texid:= loadPng(mirror,"data/stargateRed_off.png");
	offportg_texid:= loadPng(mirror,"data/stargateGreen_off.png");
	barloc1_texid:= loadPng(mirror,"data/stargate_texture.png");

	granite_texid  := loadPng(mirror,"data/granitergb.png");

	grunge_texid := loadPng(mirror,"data/grungeRGBA.png");

	glassw_texid  := loadPng(mirror,"data/glassWallx.png"); --medium


	woodw_texid := loadPng(mirror,"data/woodenceilingW.png");
	woodt_texid := loadPng(mirror,"data/woodenceilingT.png");
	woodwr_texid := loadPng(repeat,"data/woodenceilingW.png");
	woodtr_texid := loadPng(repeat,"data/woodenceilingT.png");

	woodblue_texid := loadPng(repeat,"data/woodblue.png");

	adobe_texid := loadPng(mirror,"data/wallT.png"); 
	--dark, contrasting adobe

	pfish_texid  := loadPng(mirror,"data/p1.png");

	-- ...and these 3 others are loaded dynamically (per level):
	-- room_texid,  pic_texid, ceil_texid



---- ava begin ----------------------------

	--avaTexShadID
	pidava20:=LoadShaders("./data/avatarobj.vs","./data/avatarobj.fs");
	imvp20 := glGetUniformLocation( pidava20, pmvp );     
	icen20 := glGetUniformLocation(pidava20, pwpos); --// vec3
	hang20 := glgetuniformlocation(pidava20, phori); --horiAng
	time20 := glGetUniformLocation( pidava20, pmytime );
	idir20 := glGetUniformLocation( pidava20, pmydir );
	fade20 := glGetUniformLocation( pidava20, pmyfade );

	side20 := glGetUniformLocation( pidava20, pinterior );
	--integer flag for inside/outside

	samp20 := glGetUniformLocation( pidava20, pmyts );

	--ava_texid := loadPng(mirror,"data/skin.png",false); --noInvert
	--5aug18:
	ava_texid := loadPng(clamp,"data/skin.png",false); --noInvert

	avatarolay.setrect(ava);



---- monkey begin ----------------------------

	pidmky22:=LoadShaders("./data/animalObj.vs","./data/avatarobj.fs");
	imvp22 := glGetUniformLocation( pidmky22, pmvp );     
	icen22 := glGetUniformLocation(pidmky22, pwpos); --// vec3
	hang22 := glgetuniformlocation(pidmky22, phori); --horiAng
	time22 := glGetUniformLocation( pidmky22, pmytime );
	idir22 := glGetUniformLocation( pidmky22, pmydir );

	side22 := glGetUniformLocation( pidmky22, pinterior );
	--integer flag for inside/outside

	samp22 := glGetUniformLocation( pidmky22, pmyts );

	--5aug18:
	mky_texid := loadPng(clamp,"data/monkey.png",false); --noInvert

	avatarobj.setrect(monkey);













	-- ZPMs (barrels):
	--nontexshadid 
	pidzpm21:= loadshaders("./data/nontex.vs", "./data/nontex.fs");
	imvp21 := glgetuniformlocation(pidzpm21, pmvp);




-------- begin UN-numbered ------------------------------------------
-- these are unchanged since confusion is unlikely
--------------------------------------------------------------------------
	-- back to Island:

	tunshadid3:=loadshaders("data/tunnelstars.vs","data/perfectWorm.fs");
	-- 20nov19 more like stargate sg1
	-- awesome, but graphically heavy

--------------------------------------------------------------------------
	-- from Island:
	tunshadid1:=loadshaders("data/tunnelstars.vs","data/perfectWorm.fs");
	-- 20nov19 more like stargate sg1
	-- awesome, but graphically heavy

--------------------------------------------------------------------------

	-- dungeon local:
	tunshadid2:=loadshaders("data/tunnelstars.vs","data/myspiral.fs");
	-- very nice too;  great lightweight color spiral (no stars)

--------------------------------------------------------------------------

	tuntimeid1 := glgetuniformlocation(tunshadid1, ptime); -- need glint
	tunresid1  := glgetuniformlocation(tunshadid1, presol);
	tunmatid1  := glgetuniformlocation(tunshadid1, pmvp);

	tuntimeid2 := glgetuniformlocation(tunshadid2, ptime);
	tunresid2  := glgetuniformlocation(tunshadid2, presol);
	tunmatid2  := glgetuniformlocation(tunshadid2, pmvp);

	tuntimeid3 := glgetuniformlocation(tunshadid3, ptime);
	tunresid3  := glgetuniformlocation(tunshadid3, presol);
	tunmatid3  := glgetuniformlocation(tunshadid3, pmvp);



end setup_textures; -----------------------------------------------



