#version 330 core

in float mynoise; // -eps...+eps

in vec3 oPos;

out vec4 color;

uniform sampler2D myTextureSampler; //unused

// color assigned to match radial perturbations



void main(){

	float spread = 4.0; // color spread
	float yavg=0.3; // avg color (bigger=>darker)

	float yval= spread*mynoise;
	float tt = clamp(yval+yavg,0.0,1.0);
	vec3 dblu = vec3(0/255.,0/255.,128/255.); //darkBlue
	vec3 white = vec3(1.,1.,1.);
	vec3 dlta = white-dblu;

	color = vec4(dblu + (1.0-tt)*dlta, 1.0);


	// this removes graphical glitch:
	if(length(oPos)>1.0001) discard;


}

/*
--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/

