# Linux
# gnu compile script for adagate
# using NO static libs, size=1.3Mb
#
# This script uses only shared libs
# SFML-v2.3.2 and SDL2-v2.0.3
# both included in ./libs/gnu/
#
# this system builds shared snd4ada.so file
#
# note: library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere

#########################################################
# prepares libsnd4ada.so file prior to gnatmake


# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


g++ snd4ada.cpp -c -Werror -fPIC -I./incLocal

g++ -shared -o ./libs/gnu/libsnd4ada.so snd4ada.o \
$PWD/libs/gnu/libsfml-audio.so \
$PWD/libs/gnu/libsfml-system.so


#########################################################

# this is the typical path of gnat gpl 2015 (20150428):
export PATH=/usr/gnat/bin:$PATH


gnatmake adagate -o adagate_gnu \
-O3 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdlada \
-I./adabindings/AdaPngLib \
-largs \
-lGL -lz -lstdc++ \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lSDL2 -lsfml-audio -lsfml-system -lopenal \
-logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC \
-lsnd4ada

cp ./obj/adagate_gnu .



# -- Copyright (C) 2016  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



