
separate (gameutils)

-- Turtle transport parameters (level 3 only):
-- pool:  [ -10..10, 3..16 ],  zc=9.5, zr=6.5
-- start whenver zme is near z=3, and yme is near -3+0.7=-2.3
-- point @ horiang
-- wl = -3+0.02+0.125*1.5 = -2.8+0.1875 = -2.6125

-- lava turtle
-- WARNING:  many embedded hard constants may fail 
-- if other parms change...
-- eg. turtle size, pool location, size, waterlevel
procedure updateFerryPos(

	tm: in float;

	xb,yb,zb,      -- body pos
	ab,
	xh,yh,zh,      -- head pos
	ah: out float  -- head angle

) is 

	xh0, zh0: float;

	-- lava pool:
	lzmax : constant float := 16.0;
	lzmin : constant float :=  3.0;
	wlev : constant float := -2.6125;

	-- ground height:
	glev : constant float := -2.3; -- -ymax+aheight


	parkthreshold: constant float := 0.6;
	ridethreshold: constant float := 0.3;


	-- apogee test values
	zapoNo : constant float := lzmax+margin; --16.125
	zapoSo : constant float := lzmin-margin; -- 2.875
-- 2.836, 2.871, 2.865, 2.830
-- 2.8467, 2.870, 2.869

	-- turtle bounds:
	tlev  : constant float := wlev-0.2; -- nice turtle height
	tzmax : constant float := lzmax-0.8; -- 15.2
	tzmin : constant float := lzmin+0.8; --  3.8

	txmax : constant float := 9.0;
	txmin : constant float :=-9.0;

	ds, dfx,dfz,dfa : float;

	--exmarg=0.12
	--inmarg=0.05
begin




	if mounting then -- triggered by moveforward while turtlenear

		if parkingSo then
			tfz:=tzmin+exmarg; -- 3.8+0.12 = 3.92
			parkingSo:=false;
		elsif parkingNo then
			tfz:=tzmax-exmarg; -- 15.2-0.12 = 15.08
			parkingNo:=false;
		end if;

		xme:=tfx;
		zme:=tfz;
		yme:=yme+1.0; --high enough to look down, see turtle
		ferrying:=true;
		mounting:=false;
		turtlenear:=false;

	end if;


if not ferrying then

	-- test launch conditions near north end of pool
	if 
		abs(yme-glev)<margin and   -- zme>16
		zme<zapoNo+parkthreshold and zme>lzmax and
		--abs(horiang) > halfpi -- looking toward turtle
		fmath.cos(horiang) < 0.0
	then
		parkingNo:=true;
	else
		parkingNo:=false;
	end if;


	-- test launch conditions near Z=3 : south end of pool
	if 
		abs(yme-glev)<margin and   -- zme<3
		zme>zapoSo-parkthreshold and zme<lzmin and
		--abs(horiang) < onepi/3.0 -- looking toward turtle
		fmath.cos(horiang) > 0.0
	then
		parkingSo:=true;
	else
		parkingSo:=false;
	end if;

	if 
		parkingSo
		or parkingNo
	then 
	-- move turtle into ferry-loading position (toward camera)

		dfx := xme - tfx;
		dfz := zme - tfz;

		-- note tfa is current turtle angle
		dfa := fmath.sin(horiang - tfa); --minimal delta

		tfx := tfx + 0.01*dfx;
		tfz := tfz + 0.01*dfz; --approach slowly
		tfa := tfa + 0.01*dfa;

		--keep distance from NO/SO ends:
		if tfz<tzmin then tfz:=tzmin; end if; -- south (Z-) end pool
		if tfz>tzmax then tfz:=tzmax; end if; -- north (Z+) end pool

		--keep distance from EA/WE edges:
		if tfx>txmax then tfx:=txmax; end if;
		if tfx<txmin then tfx:=txmin; end if;

	else

		tfx := tfx + 0.01*(hx-tfx);
		tfz := tfz + 0.01*(hz-tfz); -- resume home pos
		dfa := fmath.sin(ha-tfa); --minimal delta
		tfa := tfa + 0.01 * dfa;

		-- add small nervous motions while idle:
		tfa := tfa + fmath.sin(fourthpi*tm)*0.005;
		tfz := tfz + fmath.sin(halfpi*tm)*0.005;

	end if;

	ab := tfa;
	ah := ab;

	xb := 0.0;
	yb := tlev;
	zb := 0.0;

	xh0:= 0.0;
	yh := yb + 0.03; -- relative head height
	zh0:= 0.7;

	xh := fmath.cos(ab)*xh0 - fmath.sin(ab)*zh0;
	zh := fmath.sin(ab)*xh0 + fmath.cos(ab)*zh0;

	xb := xb+tfx;
	zb := zb+tfz;
	xh := xh+tfx;
	zh := zh+tfz;


	-- begin nearness test:

	turtlenear:=false;

	if 
		parkingSo and 
		abs(xme-tfx)<0.5 and 
		zme>zapoSo-ridethreshold and
		abs(tfz-tzmin)<inmarg and 
		abs(fmath.sin(horiang-tfa))<fmath.sin(fourthpi) --within 45deg
	then
		-- close enough to mount but want user
		-- to hit up-arrow or w-key to mount
		turtlenear:=true;
	end if;

	if 
		parkingNo and 
		abs(xme-tfx)<0.5 and 
		zme<zapoNo+ridethreshold and
		abs(tfz-tzmax)<inmarg and 
		abs(fmath.sin(horiang-tfa))<fmath.sin(fourthpi) --within 45deg
	then
		-- close enough to mount but want user
		-- to hit up-arrow or w-key to mount
		turtlenear:=true;
	end if;

	-- end nearness test:


else -- ferrying

	-- follow the controls
	ds:=abs(xme-tfx)+abs(zme-tfz); -- test for motion
	tfx:=xme;
	tfz:=zme;
	tfa:=-horiang;

	ab := tfa;
	ah := ab;

	xb := 0.0;
	yb := tlev;
	zb := 0.0;

	xh0:= 0.0;
	yh := yb + 0.03; -- relative head height

	if ds < 0.001 then -- not moving
		zh0:= 0.7;
	else
		zh0:= 0.7 + 0.03*fmath.sin(twopi*tm); --swimming head bob
	end if;

	xh := fmath.cos(ab)*xh0 - fmath.sin(ab)*zh0;
	zh := fmath.sin(ab)*xh0 + fmath.cos(ab)*zh0;

	xb := xb+tfx;
	zb := zb+tfz;
	xh := xh+tfx;
	zh := zh+tfz;

	if tfx>txmax then 
		tfx:=txmax; xme:=txmax;
	end if;
	if tfx<txmin then 
		tfx:=txmin; xme:=txmin;
	end if;
	if tfz<tzmin then
		tfz:=tzmin; zme:=tzmin;
	end if;

	-- parms to avoid immediate dismount on south are fussy,
	-- so disallow this south dismount, if problems
	if abs(tfz-tzmin)<inmarg then -- south exit...dismount
		ferrying:=false;
		zme := zapoSo - parkthreshold - margin;
		yme:=-ymax+aheight; -- restore proper height
		tfz:=tzmin;
	end if; --southern (Z-) turtle boundary

	if abs(tfz-tzmax)<inmarg then -- north exit...dismount
		ferrying:=false; 
		zme := zapoNo + parkthreshold + margin;
		yme:=-ymax+aheight; -- restore proper height
		tfz:=tzmax; --15.2 = inside pool (0.8 min dist to edge)
	end if;

end if;


end updateFerryPos;







