/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.swig;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.List;
import org.sqlite.auth.Authorizer;
import org.sqlite.callback.Callback;
import org.sqlite.callback.ExecCallback;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CollationNeededHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.profiler.Profiler;
import org.sqlite.profiler.Tracer;
import org.sqlite.swig.SQLite3Constants;
import org.sqlite.swig.SQLite3JNI;
import org.sqlite.swig.SWIGTYPE_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_f_p_void__void;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_blob;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_blob;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_context;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_mutex;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_vfs;
import org.sqlite.swig.SWIGTYPE_p_void;
import org.sqlite.text.Collator;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLite3
implements SQLite3Constants {
    public static final int SQLITE_TRANSIENT = -1;

    public static String getInMemoryFileName() {
        return ":memory:";
    }

    public static String getDateFormatPattern() {
        return "yyyy-MM-dd";
    }

    public static String getTimeFormatPattern() {
        return "HH:mm:ss";
    }

    public static String getTimestampFormatPattern() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static String format(String pattern, java.util.Date x) {
        return new SimpleDateFormat(pattern).format(x);
    }

    public static String format(Date x) {
        return SQLite3.format(SQLite3.getDateFormatPattern(), x);
    }

    public static String format(Time x) {
        return SQLite3.format(SQLite3.getTimeFormatPattern(), x);
    }

    public static String format(Timestamp x) {
        return SQLite3.format(SQLite3.getTimestampFormatPattern(), x);
    }

    public static long parse(String pattern, String x) throws SQLException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        ParsePosition position = new ParsePosition(0);
        java.util.Date date = ((DateFormat)formatter).parse(x, position);
        if (position.getErrorIndex() != -1 || position.getIndex() != x.length()) {
            throw new SQLException("Format error.", "90J09");
        }
        return date.getTime();
    }

    public static long parseDate(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getDateFormatPattern(), x);
    }

    public static long parseTime(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getTimeFormatPattern(), x);
    }

    public static long parseTimestamp(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getTimestampFormatPattern(), x);
    }

    public static String unescapeSingleQuotedString(String str) {
        if (str != null && str.length() > 1 && str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return str.substring(1, str.length() - 1).replaceAll("''", "'");
        }
        return str;
    }

    public static String getEncodingName(int enc) {
        switch (enc) {
            case 1: {
                return "UTF8";
            }
            case 3: {
                return "UnicodeBigUnmarked";
            }
            case 2: {
                return "UnicodeLittleUnmarked";
            }
            case 4: 
            case 8: {
                return "UTF-16";
            }
        }
        throw new IllegalArgumentException("Unsupported text encodings '" + enc + "'");
    }

    public static void delete_callback(Callback callback) {
        SQLite3JNI.delete_callback(callback);
    }

    public static int sqlite3_exec(SWIGTYPE_p_sqlite3 db, String sql) {
        return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(db), sql, null, 0L);
    }

    public static int sqlite3_exec(SWIGTYPE_p_sqlite3 db, String sql, ExecCallback callback, SWIGTYPE_p_p_char errmsg) {
        return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(db), sql, callback, SWIGTYPE_p_p_char.getCPtr(errmsg));
    }

    public static int sqlite3_get_table(SWIGTYPE_p_sqlite3 db, String sql, List<String[]> result, SWIGTYPE_p_p_char errmsg) {
        return SQLite3JNI.sqlite3_get_table(SWIGTYPE_p_sqlite3.getCPtr(db), sql, result, SWIGTYPE_p_p_char.getCPtr(errmsg));
    }

    public static int sqlite3_prepare(SWIGTYPE_p_sqlite3 db, String zSql, int nBytes, SWIGTYPE_p_p_sqlite3_stmt ppStmt, String[] pzTail) {
        return SQLite3JNI.sqlite3_prepare_v2(SWIGTYPE_p_sqlite3.getCPtr(db), zSql, nBytes, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(ppStmt), pzTail);
    }

    public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, byte[] val, int len) {
        return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, len, -1L);
    }

    public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, SWIGTYPE_p_void val, int len) {
        return SQLite3JNI.sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, SWIGTYPE_p_void.getCPtr(val), len, -1L);
    }

    public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, String val) {
        return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, -1, -1L);
    }

    public static int sqlite3_create_function(SWIGTYPE_p_sqlite3 db, Function func) {
        return SQLite3JNI.sqlite3_create_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
    }

    public static int sqlite3_drop_function(SWIGTYPE_p_sqlite3 db, Function func) {
        return SQLite3JNI.sqlite3_drop_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, SWIGTYPE_p_void blob, int len) {
        SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), SWIGTYPE_p_void.getCPtr(blob), len, -1L);
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, byte[] val, int len) {
        SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, len, -1L);
    }

    public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context ctx, String message) {
        SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), message, -1);
    }

    public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context ctx, String val) {
        SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, -1, -1L);
    }

    public static int sqlite3_create_collation(SWIGTYPE_p_sqlite3 db, Collator col) {
        return SQLite3JNI.sqlite3_create_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
    }

    public static int sqlite3_drop_collation(SWIGTYPE_p_sqlite3 db, Collator col) {
        return SQLite3JNI.sqlite3_drop_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
    }

    public static SWIGTYPE_p_sqlite3 new_p_sqlite3(long cPtr) {
        return new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_sqlite3_context new_p_sqlite3_context(long cPtr) {
        return new SWIGTYPE_p_sqlite3_context(cPtr, false);
    }

    public static SWIGTYPE_p_p_Mem new_p_p_sqlite3_value(long cPtr) {
        return new SWIGTYPE_p_p_Mem(cPtr, false);
    }

    public static int sqlite3_collation_needed(SWIGTYPE_p_sqlite3 db, CollationNeededHandler needed) {
        return SQLite3JNI.sqlite3_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(db), needed);
    }

    public static int sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3 db, CollationNeededHandler needed) {
        return SQLite3JNI.sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(db), needed);
    }

    public static int sqlite3_set_authorizer(SWIGTYPE_p_sqlite3 db, Authorizer auth) {
        return SQLite3JNI.sqlite3_set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
    }

    public static int sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3 db, Authorizer auth) {
        return SQLite3JNI.sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
    }

    public static int sqlite3_busy_handler(SWIGTYPE_p_sqlite3 db, BusyHandler busy) {
        return SQLite3JNI.sqlite3_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
    }

    public static int sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3 db, BusyHandler busy) {
        return SQLite3JNI.sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
    }

    public static void sqlite3_progress_handler(SWIGTYPE_p_sqlite3 db, ProgressHandler prog) {
        SQLite3JNI.sqlite3_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
    }

    public static void sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3 db, ProgressHandler prog) {
        SQLite3JNI.sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
    }

    public static void sqlite3_commit_hook(SWIGTYPE_p_sqlite3 db, CommitHook hook) {
        SQLite3JNI.sqlite3_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void sqlite3_rollback_hook(SWIGTYPE_p_sqlite3 db, RollbackHook hook) {
        SQLite3JNI.sqlite3_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void sqlite3_update_hook(SWIGTYPE_p_sqlite3 db, UpdateHook hook) {
        SQLite3JNI.sqlite3_update_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void sqlite3_profile(SWIGTYPE_p_sqlite3 db, Profiler prof) {
        SQLite3JNI.sqlite3_profile(SWIGTYPE_p_sqlite3.getCPtr(db), prof);
    }

    public static void sqlite3_trace(SWIGTYPE_p_sqlite3 db, Tracer tracer) {
        SQLite3JNI.sqlite3_trace(SWIGTYPE_p_sqlite3.getCPtr(db), tracer);
    }

    public static int sqlite3_prepare_v1(SWIGTYPE_p_sqlite3 arg0, String arg1, int arg2, SWIGTYPE_p_p_sqlite3_stmt arg3, Object[] arg4) {
        return SQLite3JNI.sqlite3_prepare_v1(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(arg3), arg4);
    }

    public static int sqlite3_prepare_v2(SWIGTYPE_p_sqlite3 arg0, String arg1, int arg2, SWIGTYPE_p_p_sqlite3_stmt arg3, Object[] arg4) {
        return SQLite3JNI.sqlite3_prepare_v2(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(arg3), arg4);
    }

    private static int sqlite3_create_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_create_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_drop_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_drop_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_create_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_create_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_drop_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_drop_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_set_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_collation_needed(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void sqlite3_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void sqlite3_commit_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    public static void sqlite3_clear_commit_hook(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_clear_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    private static void sqlite3_rollback_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    public static void sqlite3_clear_rollback_hook(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_clear_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    private static void sqlite3_update_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    public static void sqlite3_clear_update_hook(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_clear_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    private static void sqlite3_profile(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_profile(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    public static void sqlite3_clear_profile(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_clear_profile(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    private static void sqlite3_trace(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.sqlite3_trace(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    public static void sqlite3_clear_trace(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_clear_trace(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static void sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1, Object arg2) {
        SQLite3JNI.sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2);
    }

    public static Object sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
        return SQLite3JNI.sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static byte[] sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static byte[] sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static void set_sqlite3_temp_directory(String arg0) {
        SQLite3JNI.set_sqlite3_temp_directory(arg0);
    }

    private static int sqlite3_exec(SWIGTYPE_p_sqlite3 arg0, String arg1, Object arg2, long arg3) {
        return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, arg3);
    }

    private static int sqlite3_get_table(SWIGTYPE_p_sqlite3 arg0, String arg1, Object arg2, long arg3) {
        return SQLite3JNI.sqlite3_get_table(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, arg3);
    }

    private static void delete_callback(Object arg0) {
        SQLite3JNI.delete_callback(arg0);
    }

    public static String sqlite3_libversion() {
        return SQLite3JNI.sqlite3_libversion();
    }

    public static int sqlite3_libversion_number() {
        return SQLite3JNI.sqlite3_libversion_number();
    }

    public static int sqlite3_threadsafe() {
        return SQLite3JNI.sqlite3_threadsafe();
    }

    public static int sqlite3_close(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_close(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_extended_result_codes(SWIGTYPE_p_sqlite3 arg0, int onoff) {
        return SQLite3JNI.sqlite3_extended_result_codes(SWIGTYPE_p_sqlite3.getCPtr(arg0), onoff);
    }

    public static long sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_changes(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_total_changes(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_total_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static void sqlite3_interrupt(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_interrupt(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_complete(String sql) {
        return SQLite3JNI.sqlite3_complete(sql);
    }

    public static int sqlite3_busy_timeout(SWIGTYPE_p_sqlite3 arg0, int ms) {
        return SQLite3JNI.sqlite3_busy_timeout(SWIGTYPE_p_sqlite3.getCPtr(arg0), ms);
    }

    public static SWIGTYPE_p_void sqlite3_malloc(int arg0) {
        long cPtr = SQLite3JNI.sqlite3_malloc(arg0);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_realloc(SWIGTYPE_p_void arg0, int arg1) {
        long cPtr = SQLite3JNI.sqlite3_realloc(SWIGTYPE_p_void.getCPtr(arg0), arg1);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static void sqlite3_free(SWIGTYPE_p_void arg0) {
        SQLite3JNI.sqlite3_free(SWIGTYPE_p_void.getCPtr(arg0));
    }

    public static long sqlite3_memory_used() {
        return SQLite3JNI.sqlite3_memory_used();
    }

    public static long sqlite3_memory_highwater(int resetFlag) {
        return SQLite3JNI.sqlite3_memory_highwater(resetFlag);
    }

    public static void sqlite3_randomness(int N, SWIGTYPE_p_void P) {
        SQLite3JNI.sqlite3_randomness(N, SWIGTYPE_p_void.getCPtr(P));
    }

    public static int sqlite3_open(String filename, SWIGTYPE_p_p_sqlite3 ppDb) {
        return SQLite3JNI.sqlite3_open(filename, SWIGTYPE_p_p_sqlite3.getCPtr(ppDb));
    }

    public static int sqlite3_open_v2(String filename, SWIGTYPE_p_p_sqlite3 ppDb, int flags, String zVfs) {
        return SQLite3JNI.sqlite3_open_v2(filename, SWIGTYPE_p_p_sqlite3.getCPtr(ppDb), flags, zVfs);
    }

    public static int sqlite3_errcode(SWIGTYPE_p_sqlite3 db) {
        return SQLite3JNI.sqlite3_errcode(SWIGTYPE_p_sqlite3.getCPtr(db));
    }

    public static String sqlite3_errmsg(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_errmsg(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_limit(SWIGTYPE_p_sqlite3 arg0, int id, int newVal) {
        return SQLite3JNI.sqlite3_limit(SWIGTYPE_p_sqlite3.getCPtr(arg0), id, newVal);
    }

    public static String sqlite3_sql(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_sql(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, SWIGTYPE_p_void arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
        return SQLite3JNI.sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, SWIGTYPE_p_void.getCPtr(arg2), n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
    }

    public static int sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, double arg2) {
        return SQLite3JNI.sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, int arg2) {
        return SQLite3JNI.sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, long arg2) {
        return SQLite3JNI.sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, String arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
        return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2, n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
    }

    public static int sqlite3_bind_value(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, SWIGTYPE_p_Mem arg2) {
        return SQLite3JNI.sqlite3_bind_value(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, SWIGTYPE_p_Mem.getCPtr(arg2));
    }

    public static int sqlite3_bind_zeroblob(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, int n) {
        return SQLite3JNI.sqlite3_bind_zeroblob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, n);
    }

    public static int sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static String sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static int sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt arg0, String zName) {
        return SQLite3JNI.sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), zName);
    }

    public static int sqlite3_clear_bindings(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_clear_bindings(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static int sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static String sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt arg0, int N) {
        return SQLite3JNI.sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), N);
    }

    public static String sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static int sqlite3_step(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_step(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static int sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static SWIGTYPE_p_void sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        long cPtr = SQLite3JNI.sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static double sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static long sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static String sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static SWIGTYPE_p_Mem sqlite3_column_value(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        long cPtr = SQLite3JNI.sqlite3_column_value(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
        return cPtr == 0L ? null : new SWIGTYPE_p_Mem(cPtr, false);
    }

    public static int sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static int sqlite3_reset(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_reset(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static SWIGTYPE_p_void sqlite3_value_blob(SWIGTYPE_p_Mem arg0) {
        long cPtr = SQLite3JNI.sqlite3_value_blob(SWIGTYPE_p_Mem.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_value_bytes(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static double sqlite3_value_double(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_double(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_int(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_int(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static long sqlite3_value_int64(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_int64(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static String sqlite3_value_text(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_text(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_type(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_type(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_numeric_type(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_numeric_type(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static SWIGTYPE_p_sqlite3 sqlite3_context_db_handle(SWIGTYPE_p_sqlite3_context arg0) {
        long cPtr = SQLite3JNI.sqlite3_context_db_handle(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_void arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
        SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_void.getCPtr(arg1), arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
    }

    public static void sqlite3_result_double(SWIGTYPE_p_sqlite3_context arg0, double arg1) {
        SQLite3JNI.sqlite3_result_double(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2) {
        SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2);
    }

    public static void sqlite3_result_error_toobig(SWIGTYPE_p_sqlite3_context arg0) {
        SQLite3JNI.sqlite3_result_error_toobig(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
    }

    public static void sqlite3_result_error_nomem(SWIGTYPE_p_sqlite3_context arg0) {
        SQLite3JNI.sqlite3_result_error_nomem(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
    }

    public static void sqlite3_result_error_code(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
        SQLite3JNI.sqlite3_result_error_code(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_int(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
        SQLite3JNI.sqlite3_result_int(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_int64(SWIGTYPE_p_sqlite3_context arg0, long arg1) {
        SQLite3JNI.sqlite3_result_int64(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_null(SWIGTYPE_p_sqlite3_context arg0) {
        SQLite3JNI.sqlite3_result_null(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
    }

    public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
        SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
    }

    public static void sqlite3_result_value(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_Mem arg1) {
        SQLite3JNI.sqlite3_result_value(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_Mem.getCPtr(arg1));
    }

    public static void sqlite3_result_zeroblob(SWIGTYPE_p_sqlite3_context arg0, int n) {
        SQLite3JNI.sqlite3_result_zeroblob(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), n);
    }

    public static int sqlite3_sleep(int arg0) {
        return SQLite3JNI.sqlite3_sleep(arg0);
    }

    public static int sqlite3_get_autocommit(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_get_autocommit(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static SWIGTYPE_p_sqlite3 sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt arg0) {
        long cPtr = SQLite3JNI.sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_sqlite3_stmt sqlite3_next_stmt(SWIGTYPE_p_sqlite3 pDb, SWIGTYPE_p_sqlite3_stmt pStmt) {
        long cPtr = SQLite3JNI.sqlite3_next_stmt(SWIGTYPE_p_sqlite3.getCPtr(pDb), SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_stmt(cPtr, false);
    }

    public static int sqlite3_enable_shared_cache(int arg0) {
        return SQLite3JNI.sqlite3_enable_shared_cache(arg0);
    }

    public static int sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3 db, String zDbName, String zTableName, String zColumnName, SWIGTYPE_p_p_char pzDataType, SWIGTYPE_p_p_char pzCollSeq, SWIGTYPE_p_int pNotNull, SWIGTYPE_p_int pPrimaryKey, SWIGTYPE_p_int pAutoinc) {
        return SQLite3JNI.sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3.getCPtr(db), zDbName, zTableName, zColumnName, SWIGTYPE_p_p_char.getCPtr(pzDataType), SWIGTYPE_p_p_char.getCPtr(pzCollSeq), SWIGTYPE_p_int.getCPtr(pNotNull), SWIGTYPE_p_int.getCPtr(pPrimaryKey), SWIGTYPE_p_int.getCPtr(pAutoinc));
    }

    public static int sqlite3_load_extension(SWIGTYPE_p_sqlite3 db, String zFile, String zProc, SWIGTYPE_p_p_char pzErrMsg) {
        return SQLite3JNI.sqlite3_load_extension(SWIGTYPE_p_sqlite3.getCPtr(db), zFile, zProc, SWIGTYPE_p_p_char.getCPtr(pzErrMsg));
    }

    public static int sqlite3_enable_load_extension(SWIGTYPE_p_sqlite3 db, int onoff) {
        return SQLite3JNI.sqlite3_enable_load_extension(SWIGTYPE_p_sqlite3.getCPtr(db), onoff);
    }

    public static int sqlite3_auto_extension(SWIGTYPE_p_void xEntryPoint) {
        return SQLite3JNI.sqlite3_auto_extension(SWIGTYPE_p_void.getCPtr(xEntryPoint));
    }

    public static void sqlite3_reset_auto_extension() {
        SQLite3JNI.sqlite3_reset_auto_extension();
    }

    public static int sqlite3_blob_open(SWIGTYPE_p_sqlite3 arg0, String zDb, String zTable, String zColumn, long iRow, int flags, SWIGTYPE_p_p_sqlite3_blob ppBlob) {
        return SQLite3JNI.sqlite3_blob_open(SWIGTYPE_p_sqlite3.getCPtr(arg0), zDb, zTable, zColumn, iRow, flags, SWIGTYPE_p_p_sqlite3_blob.getCPtr(ppBlob));
    }

    public static int sqlite3_blob_close(SWIGTYPE_p_sqlite3_blob arg0) {
        return SQLite3JNI.sqlite3_blob_close(SWIGTYPE_p_sqlite3_blob.getCPtr(arg0));
    }

    public static int sqlite3_blob_bytes(SWIGTYPE_p_sqlite3_blob arg0) {
        return SQLite3JNI.sqlite3_blob_bytes(SWIGTYPE_p_sqlite3_blob.getCPtr(arg0));
    }

    public static SWIGTYPE_p_sqlite3_vfs sqlite3_vfs_find(String zVfsName) {
        long cPtr = SQLite3JNI.sqlite3_vfs_find(zVfsName);
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_vfs(cPtr, false);
    }

    public static int sqlite3_vfs_register(SWIGTYPE_p_sqlite3_vfs arg0, int makeDflt) {
        return SQLite3JNI.sqlite3_vfs_register(SWIGTYPE_p_sqlite3_vfs.getCPtr(arg0), makeDflt);
    }

    public static int sqlite3_vfs_unregister(SWIGTYPE_p_sqlite3_vfs arg0) {
        return SQLite3JNI.sqlite3_vfs_unregister(SWIGTYPE_p_sqlite3_vfs.getCPtr(arg0));
    }

    public static SWIGTYPE_p_sqlite3_mutex sqlite3_mutex_alloc(int arg0) {
        long cPtr = SQLite3JNI.sqlite3_mutex_alloc(arg0);
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_mutex(cPtr, false);
    }

    public static void sqlite3_mutex_free(SWIGTYPE_p_sqlite3_mutex arg0) {
        SQLite3JNI.sqlite3_mutex_free(SWIGTYPE_p_sqlite3_mutex.getCPtr(arg0));
    }

    public static void sqlite3_mutex_enter(SWIGTYPE_p_sqlite3_mutex arg0) {
        SQLite3JNI.sqlite3_mutex_enter(SWIGTYPE_p_sqlite3_mutex.getCPtr(arg0));
    }

    public static int sqlite3_mutex_try(SWIGTYPE_p_sqlite3_mutex arg0) {
        return SQLite3JNI.sqlite3_mutex_try(SWIGTYPE_p_sqlite3_mutex.getCPtr(arg0));
    }

    public static void sqlite3_mutex_leave(SWIGTYPE_p_sqlite3_mutex arg0) {
        SQLite3JNI.sqlite3_mutex_leave(SWIGTYPE_p_sqlite3_mutex.getCPtr(arg0));
    }

    public static int sqlite3_file_control(SWIGTYPE_p_sqlite3 arg0, String zDbName, int op, SWIGTYPE_p_void arg3) {
        return SQLite3JNI.sqlite3_file_control(SWIGTYPE_p_sqlite3.getCPtr(arg0), zDbName, op, SWIGTYPE_p_void.getCPtr(arg3));
    }

    public static int sqlite3_status(int op, SWIGTYPE_p_int pCurrent, SWIGTYPE_p_int pHighwater, int resetFlag) {
        return SQLite3JNI.sqlite3_status(op, SWIGTYPE_p_int.getCPtr(pCurrent), SWIGTYPE_p_int.getCPtr(pHighwater), resetFlag);
    }

    public static int sqlite3_db_status(SWIGTYPE_p_sqlite3 arg0, int op, SWIGTYPE_p_int pCur, SWIGTYPE_p_int pHiwtr, int resetFlg) {
        return SQLite3JNI.sqlite3_db_status(SWIGTYPE_p_sqlite3.getCPtr(arg0), op, SWIGTYPE_p_int.getCPtr(pCur), SWIGTYPE_p_int.getCPtr(pHiwtr), resetFlg);
    }

    public static int sqlite3_stmt_status(SWIGTYPE_p_sqlite3_stmt arg0, int op, int resetFlg) {
        return SQLite3JNI.sqlite3_stmt_status(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), op, resetFlg);
    }

    public static SWIGTYPE_p_p_sqlite3 new_p_p_sqlite3() {
        long cPtr = SQLite3JNI.new_p_p_sqlite3();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3(cPtr, false);
    }

    public static void delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3 self) {
        SQLite3JNI.delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3.getCPtr(self));
    }

    public static SWIGTYPE_p_sqlite3 get_p_sqlite3(SWIGTYPE_p_p_sqlite3 self) {
        long cPtr = SQLite3JNI.get_p_sqlite3(SWIGTYPE_p_p_sqlite3.getCPtr(self));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_p_sqlite3_stmt new_p_p_sqlite3_stmt() {
        long cPtr = SQLite3JNI.new_p_p_sqlite3_stmt();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3_stmt(cPtr, false);
    }

    public static void delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt self) {
        SQLite3JNI.delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
    }

    public static SWIGTYPE_p_sqlite3_stmt get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt self) {
        long cPtr = SQLite3JNI.get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_stmt(cPtr, false);
    }

    public static SWIGTYPE_p_p_char new_p_p_char() {
        long cPtr = SQLite3JNI.new_p_p_char();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_char(cPtr, false);
    }

    public static void delete_p_p_char(SWIGTYPE_p_p_char self) {
        SQLite3JNI.delete_p_p_char(SWIGTYPE_p_p_char.getCPtr(self));
    }

    public static String get_p_char(SWIGTYPE_p_p_char self) {
        return SQLite3JNI.get_p_char(SWIGTYPE_p_p_char.getCPtr(self));
    }

    public static SWIGTYPE_p_int new_p_int() {
        long cPtr = SQLite3JNI.new_p_int();
        return cPtr == 0L ? null : new SWIGTYPE_p_int(cPtr, false);
    }

    public static void delete_p_int(SWIGTYPE_p_int self) {
        SQLite3JNI.delete_p_int(SWIGTYPE_p_int.getCPtr(self));
    }

    public static int get_int(SWIGTYPE_p_int self) {
        return SQLite3JNI.get_int(SWIGTYPE_p_int.getCPtr(self));
    }

    public static SWIGTYPE_p_p_sqlite3_blob new_p_p_sqlite3_blob() {
        long cPtr = SQLite3JNI.new_p_p_sqlite3_blob();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3_blob(cPtr, false);
    }

    public static void delete_p_p_sqlite3_blob(SWIGTYPE_p_p_sqlite3_blob self) {
        SQLite3JNI.delete_p_p_sqlite3_blob(SWIGTYPE_p_p_sqlite3_blob.getCPtr(self));
    }

    public static SWIGTYPE_p_sqlite3_blob get_p_sqlite3_blob(SWIGTYPE_p_p_sqlite3_blob self) {
        long cPtr = SQLite3JNI.get_p_sqlite3_blob(SWIGTYPE_p_p_sqlite3_blob.getCPtr(self));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_blob(cPtr, false);
    }

    private static int sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt pStmt, int parameterIndex, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
        return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt), parameterIndex, BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
    }

    public static void read_blob(SWIGTYPE_p_void blob, long pos, byte[] BYTE, int offset, int len) {
        SQLite3JNI.read_blob(SWIGTYPE_p_void.getCPtr(blob), pos, BYTE, offset, len);
    }

    public static SWIGTYPE_p_Mem get_p_sqlite3_value(SWIGTYPE_p_p_Mem value, int i) {
        long cPtr = SQLite3JNI.get_p_sqlite3_value(SWIGTYPE_p_p_Mem.getCPtr(value), i);
        return cPtr == 0L ? null : new SWIGTYPE_p_Mem(cPtr, false);
    }

    public static void sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context pCtx, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
        SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(pCtx), BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
    }

    public static String sqlite3_get_errmsg(int rc) {
        return SQLite3JNI.sqlite3_get_errmsg(rc);
    }

    public static int sqlite3_blob_read(SWIGTYPE_p_sqlite3_blob pBlob, byte[] BYTE, int n, int iOffset) {
        return SQLite3JNI.sqlite3_blob_read(SWIGTYPE_p_sqlite3_blob.getCPtr(pBlob), BYTE, n, iOffset);
    }

    public static int sqlite3_blob_write(SWIGTYPE_p_sqlite3_blob pBlob, byte[] BYTE, int n, int iOffset) {
        return SQLite3JNI.sqlite3_blob_write(SWIGTYPE_p_sqlite3_blob.getCPtr(pBlob), BYTE, n, iOffset);
    }

    public static class SQLite3BlobPtrPtr
    extends SWIGTYPE_p_p_sqlite3_blob {
        private boolean isDeleted = false;

        public SQLite3BlobPtrPtr() {
            super(SQLite3JNI.new_p_p_sqlite3_blob(), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3_blob(this);
                this.isDeleted = true;
            }
        }

        public SWIGTYPE_p_sqlite3_blob getSQLite3BlobPtr() {
            if (!this.isDeleted) {
                return SQLite3.get_p_sqlite3_blob(this);
            }
            throw new IllegalStateException("SQLite3BlobPtrPtr is already deleted.");
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }

    public static class SQLite3StmtPtrPtr
    extends SWIGTYPE_p_p_sqlite3_stmt {
        private boolean isDeleted = false;

        public SQLite3StmtPtrPtr() {
            super(SQLite3JNI.new_p_p_sqlite3_stmt(), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3_stmt(this);
                this.isDeleted = true;
            }
        }

        public SWIGTYPE_p_sqlite3_stmt getSQLite3StmtPtr() {
            if (!this.isDeleted) {
                return SQLite3.get_p_sqlite3_stmt(this);
            }
            throw new IllegalStateException("SQLite3StmtPtrPtr is already deleted.");
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }

    public static class SQLite3PtrPtr
    extends SWIGTYPE_p_p_sqlite3 {
        private boolean isDeleted = false;
        private SWIGTYPE_p_sqlite3 handle;

        public SQLite3PtrPtr() {
            super(SQLite3JNI.new_p_p_sqlite3(), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3(this);
                this.isDeleted = true;
                this.handle = null;
            }
        }

        public void allocateHandle() {
            if (!this.isDeleted) {
                if (this.handle != null) {
                    throw new IllegalStateException("sqlite3 handle is already allocated.");
                }
            } else {
                throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
            }
            this.handle = SQLite3.get_p_sqlite3(this);
        }

        public SWIGTYPE_p_sqlite3 getSQLite3Ptr() {
            if (!this.isDeleted) {
                return this.handle;
            }
            throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }
}

