import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.profiler.Profiler;

public class ProfilerExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new profiler
            final Profiler prof
                    = new Profiler() {
                            @Override
                            protected void xProfile(String sql, long elapseTime) {
                                System.out.println("prof: [" + elapseTime + " : " + sql + "]");
                            }
                        };
            // set profiler
            conn.setProfiler(prof);
            
            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT VAL FROM ("
                        + "SELECT 1 AS VAL UNION ALL "
                        + "SELECT 2 AS VAL UNION ALL "
                        + "SELECT 3 AS VAL UNION ALL "
                        + "SELECT 4 AS VAL UNION ALL "
                        + "SELECT 5 AS VAL"
                    + ")";

            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println("VAL: " + rs.getString(1));
            }
            stmt.close();

            // clear profiler
            conn.clearProfiler();
            
        } finally {
            conn.close();
        }
    }
    
    public static void main(String[] args) throws Exception {
        new ProfilerExample().example();
    }
}
