/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_mutex;

public class Mutex {
    private final SWIGTYPE_p_sqlite3_mutex mutex;
    private boolean isDeleted;

    public Mutex(int type) {
        this.mutex = SQLite3.sqlite3_mutex_alloc(type);
        if (this.mutex == null) {
            throw new NullPointerException("Failed sqlite3_mutex_alloc(" + type + ")");
        }
        this.isDeleted = false;
    }

    public void enter() {
        if (this.isDeleted) {
            throw new IllegalStateException("Mutex is already deleted.");
        }
        SQLite3.sqlite3_mutex_enter(this.mutex);
    }

    public synchronized void free() {
        if (!this.isDeleted) {
            SQLite3.sqlite3_mutex_free(this.mutex);
            this.isDeleted = true;
        }
    }

    public void leave() {
        if (this.isDeleted) {
            throw new IllegalStateException("Mutex is already deleted.");
        }
        SQLite3.sqlite3_mutex_leave(this.mutex);
    }

    public int try_() {
        if (this.isDeleted) {
            throw new IllegalStateException("Mutex is already deleted.");
        }
        return SQLite3.sqlite3_mutex_try(this.mutex);
    }

    public boolean held() {
        if (this.isDeleted) {
            throw new IllegalStateException("Mutex is already deleted.");
        }
        return SQLite3.sqlite3_mutex_held(this.mutex) != 0;
    }

    public boolean notHeld() {
        if (this.isDeleted) {
            throw new IllegalStateException("Mutex is already deleted.");
        }
        return SQLite3.sqlite3_mutex_notheld(this.mutex) != 0;
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }
}

