/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.swig;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import org.sqlite.auth.Authorizer;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.swig.SQLite3Constants;
import org.sqlite.swig.SQLite3JNI;
import org.sqlite.swig.SWIGTYPE_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_f_p_struct_sqlite3_context__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_struct_sqlite3_context_int_p_p_struct_Mem__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_void__int;
import org.sqlite.swig.SWIGTYPE_p_f_p_void__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_int__int;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_int_p_p_char_p_p_char__int;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_long_long__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_p_q_const__char_p_q_const__char__int;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_int_p_q_const__void_int_p_q_const__void__int;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_p_q_const__char__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_p_q_const__char_unsigned_long_long__void;
import org.sqlite.swig.SWIGTYPE_p_f_p_void_p_struct_sqlite3_int_p_q_const__char__void;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_context;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_va_list;
import org.sqlite.swig.SWIGTYPE_p_void;
import org.sqlite.text.Collator;
import org.sqlite.udf.Function;

public class SQLite3
implements SQLite3Constants {
    public static final int SQLITE_TRANSIENT = -1;

    public static String getInMemoryFileName() {
        return ":memory:";
    }

    public static String getDateFormatPattern() {
        return "yyyy-MM-dd";
    }

    public static String getTimeFormatPattern() {
        return "HH:mm:ss";
    }

    public static String getTimestampFormatPattern() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static String format(String pattern, java.util.Date x) {
        return new SimpleDateFormat(pattern).format(x);
    }

    public static String format(Date x) {
        return SQLite3.format(SQLite3.getDateFormatPattern(), x);
    }

    public static String format(Time x) {
        return SQLite3.format(SQLite3.getTimeFormatPattern(), x);
    }

    public static String format(Timestamp x) {
        return SQLite3.format(SQLite3.getTimestampFormatPattern(), x);
    }

    public static long parse(String pattern, String x) throws SQLException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        ParsePosition position = new ParsePosition(0);
        java.util.Date date = ((DateFormat)formatter).parse(x, position);
        if (position.getErrorIndex() != -1 || position.getIndex() != x.length()) {
            throw new SQLException("Format error.", "90J09");
        }
        return date.getTime();
    }

    public static long parseDate(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getDateFormatPattern(), x);
    }

    public static long parseTime(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getTimeFormatPattern(), x);
    }

    public static long parseTimestamp(String x) throws SQLException {
        return SQLite3.parse(SQLite3.getTimestampFormatPattern(), x);
    }

    public static long addressOf(SWIGTYPE_p_sqlite3_stmt stmt) {
        return SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt);
    }

    public static int sqlite3_exec(SWIGTYPE_p_sqlite3 db, String sql) {
        return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(db), sql, 0L, 0L, 0L);
    }

    public static int sqlite3_prepare(SWIGTYPE_p_sqlite3 db, String zSql, int nBytes, SWIGTYPE_p_p_sqlite3_stmt ppStmt) {
        return SQLite3JNI.sqlite3_prepare(SWIGTYPE_p_sqlite3.getCPtr(db), zSql, nBytes, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(ppStmt), 0L);
    }

    public static int sqlite3_prepare(SWIGTYPE_p_sqlite3 db, String zSql, int nBytes, SWIGTYPE_p_p_sqlite3_stmt ppStmt, String[] tail) {
        return SQLite3JNI.sqlite3_prepare_tail(SWIGTYPE_p_sqlite3.getCPtr(db), zSql, nBytes, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(ppStmt), tail);
    }

    public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, byte[] val, int len) {
        return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, len, -1L);
    }

    public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, String val) {
        return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, -1, -1L);
    }

    public static int create_function(SWIGTYPE_p_sqlite3 db, Function func) {
        return SQLite3JNI.create_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
    }

    public static int drop_function(SWIGTYPE_p_sqlite3 db, Function func) {
        return SQLite3JNI.drop_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, SWIGTYPE_p_void blob, int len) {
        SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), SWIGTYPE_p_void.getCPtr(blob), len, -1L);
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, byte[] val, int len) {
        SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, len, -1L);
    }

    public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context ctx, String message) {
        SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), message, -1);
    }

    public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context ctx, String val) {
        SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, -1, -1L);
    }

    public static int create_collation(SWIGTYPE_p_sqlite3 db, Collator col) {
        return SQLite3JNI.create_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
    }

    public static int drop_collation(SWIGTYPE_p_sqlite3 db, Collator col) {
        return SQLite3JNI.drop_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
    }

    public static int set_authorizer(SWIGTYPE_p_sqlite3 db, Authorizer auth) {
        return SQLite3JNI.set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
    }

    public static int clear_authorizer(SWIGTYPE_p_sqlite3 db, Authorizer auth) {
        return SQLite3JNI.clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
    }

    public static int set_busy_handler(SWIGTYPE_p_sqlite3 db, BusyHandler busy) {
        return SQLite3JNI.set_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
    }

    public static int clear_busy_handler(SWIGTYPE_p_sqlite3 db, BusyHandler busy) {
        return SQLite3JNI.clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
    }

    public static void set_progress_handler(SWIGTYPE_p_sqlite3 db, ProgressHandler prog) {
        SQLite3JNI.set_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
    }

    public static void clear_progress_handler(SWIGTYPE_p_sqlite3 db, ProgressHandler prog) {
        SQLite3JNI.clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
    }

    public static void set_commit_hook(SWIGTYPE_p_sqlite3 db, CommitHook hook) {
        SQLite3JNI.set_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void clear_commit_hook(SWIGTYPE_p_sqlite3 db, CommitHook hook) {
        SQLite3JNI.clear_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void set_rollback_hook(SWIGTYPE_p_sqlite3 db, RollbackHook hook) {
        SQLite3JNI.set_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void clear_rollback_hook(SWIGTYPE_p_sqlite3 db, RollbackHook hook) {
        SQLite3JNI.clear_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void set_update_hook(SWIGTYPE_p_sqlite3 db, UpdateHook hook) {
        SQLite3JNI.set_update_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static void clear_update_hook(SWIGTYPE_p_sqlite3 db, UpdateHook hook) {
        SQLite3JNI.clear_update_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
    }

    public static int sqlite3_clear_bindings(SWIGTYPE_p_sqlite3_stmt stmt) {
        int max = SQLite3.sqlite3_bind_parameter_count(stmt) + 1;
        int ret = 0;
        for (int i = 1; ret == 0 && i < max; ++i) {
            ret = SQLite3.sqlite3_bind_null(stmt, i);
        }
        return ret;
    }

    public static String getSqlite3_version() {
        return SQLite3JNI.sqlite3_version_get();
    }

    public static String sqlite3_libversion() {
        return SQLite3JNI.sqlite3_libversion();
    }

    public static int sqlite3_libversion_number() {
        return SQLite3JNI.sqlite3_libversion_number();
    }

    public static int sqlite3_close(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_close(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_exec(SWIGTYPE_p_sqlite3 arg0, String sql, SWIGTYPE_p_f_p_void_int_p_p_char_p_p_char__int arg2, SWIGTYPE_p_void arg3, SWIGTYPE_p_p_char errmsg) {
        return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(arg0), sql, SWIGTYPE_p_f_p_void_int_p_p_char_p_p_char__int.getCPtr(arg2), SWIGTYPE_p_void.getCPtr(arg3), SWIGTYPE_p_p_char.getCPtr(errmsg));
    }

    public static long sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_changes(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_total_changes(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_total_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static void sqlite3_interrupt(SWIGTYPE_p_sqlite3 arg0) {
        SQLite3JNI.sqlite3_interrupt(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static int sqlite3_complete(String sql) {
        return SQLite3JNI.sqlite3_complete(sql);
    }

    public static int sqlite3_busy_handler(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void_int__int arg1, SWIGTYPE_p_void arg2) {
        return SQLite3JNI.sqlite3_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void_int__int.getCPtr(arg1), SWIGTYPE_p_void.getCPtr(arg2));
    }

    public static int sqlite3_busy_timeout(SWIGTYPE_p_sqlite3 arg0, int ms) {
        return SQLite3JNI.sqlite3_busy_timeout(SWIGTYPE_p_sqlite3.getCPtr(arg0), ms);
    }

    public static int sqlite3_get_table(SWIGTYPE_p_sqlite3 arg0, String sql, SWIGTYPE_p_p_p_char resultp, SWIGTYPE_p_int nrow, SWIGTYPE_p_int ncolumn, SWIGTYPE_p_p_char errmsg) {
        return SQLite3JNI.sqlite3_get_table(SWIGTYPE_p_sqlite3.getCPtr(arg0), sql, SWIGTYPE_p_p_p_char.getCPtr(resultp), SWIGTYPE_p_int.getCPtr(nrow), SWIGTYPE_p_int.getCPtr(ncolumn), SWIGTYPE_p_p_char.getCPtr(errmsg));
    }

    public static void sqlite3_free_table(SWIGTYPE_p_p_char result) {
        SQLite3JNI.sqlite3_free_table(SWIGTYPE_p_p_char.getCPtr(result));
    }

    public static String sqlite3_mprintf(String arg0) {
        return SQLite3JNI.sqlite3_mprintf(arg0);
    }

    public static String sqlite3_vmprintf(String arg0, SWIGTYPE_p_va_list arg1) {
        return SQLite3JNI.sqlite3_vmprintf(arg0, SWIGTYPE_p_va_list.getCPtr(arg1));
    }

    public static void sqlite3_free(String z) {
        SQLite3JNI.sqlite3_free(z);
    }

    public static String sqlite3_snprintf(int arg0, String arg1, String arg2) {
        return SQLite3JNI.sqlite3_snprintf(arg0, arg1, arg2);
    }

    public static int sqlite3_set_authorizer(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_p_q_const__char_p_q_const__char__int xAuth, SWIGTYPE_p_void pUserData) {
        return SQLite3JNI.sqlite3_set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_p_q_const__char_p_q_const__char__int.getCPtr(xAuth), SWIGTYPE_p_void.getCPtr(pUserData));
    }

    public static SWIGTYPE_p_void sqlite3_trace(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void_p_q_const__char__void xTrace, SWIGTYPE_p_void arg2) {
        long cPtr = SQLite3JNI.sqlite3_trace(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void_p_q_const__char__void.getCPtr(xTrace), SWIGTYPE_p_void.getCPtr(arg2));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_profile(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void_p_q_const__char_unsigned_long_long__void xProfile, SWIGTYPE_p_void arg2) {
        long cPtr = SQLite3JNI.sqlite3_profile(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void_p_q_const__char_unsigned_long_long__void.getCPtr(xProfile), SWIGTYPE_p_void.getCPtr(arg2));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static void sqlite3_progress_handler(SWIGTYPE_p_sqlite3 arg0, int arg1, SWIGTYPE_p_f_p_void__int arg2, SWIGTYPE_p_void arg3) {
        SQLite3JNI.sqlite3_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, SWIGTYPE_p_f_p_void__int.getCPtr(arg2), SWIGTYPE_p_void.getCPtr(arg3));
    }

    public static SWIGTYPE_p_void sqlite3_commit_hook(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void__int arg1, SWIGTYPE_p_void arg2) {
        long cPtr = SQLite3JNI.sqlite3_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void__int.getCPtr(arg1), SWIGTYPE_p_void.getCPtr(arg2));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_open(String filename, SWIGTYPE_p_p_sqlite3 ppDb) {
        return SQLite3JNI.sqlite3_open(filename, SWIGTYPE_p_p_sqlite3.getCPtr(ppDb));
    }

    public static int sqlite3_errcode(SWIGTYPE_p_sqlite3 db) {
        return SQLite3JNI.sqlite3_errcode(SWIGTYPE_p_sqlite3.getCPtr(db));
    }

    public static String sqlite3_errmsg(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_errmsg(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    private static int sqlite3_prepare(SWIGTYPE_p_sqlite3 db, String zSql, int nBytes, SWIGTYPE_p_p_sqlite3_stmt ppStmt, SWIGTYPE_p_p_char pzTail) {
        return SQLite3JNI.sqlite3_prepare(SWIGTYPE_p_sqlite3.getCPtr(db), zSql, nBytes, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(ppStmt), SWIGTYPE_p_p_char.getCPtr(pzTail));
    }

    public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, SWIGTYPE_p_void arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
        return SQLite3JNI.sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, SWIGTYPE_p_void.getCPtr(arg2), n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
    }

    public static int sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, double arg2) {
        return SQLite3JNI.sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, int arg2) {
        return SQLite3JNI.sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, long arg2) {
        return SQLite3JNI.sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
    }

    public static int sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, String arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
        return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2, n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
    }

    public static int sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static String sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static int sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt arg0, String zName) {
        return SQLite3JNI.sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), zName);
    }

    public static int sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static String sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static String sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt arg0, int i) {
        return SQLite3JNI.sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), i);
    }

    public static int sqlite3_step(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_step(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static int sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static SWIGTYPE_p_void sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        long cPtr = SQLite3JNI.sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static double sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static long sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static String sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
        return SQLite3JNI.sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    }

    public static int sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static int sqlite3_reset(SWIGTYPE_p_sqlite3_stmt pStmt) {
        return SQLite3JNI.sqlite3_reset(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
    }

    public static int sqlite3_create_function(SWIGTYPE_p_sqlite3 arg0, String zFunctionName, int nArg, int eTextRep, SWIGTYPE_p_void arg4, SWIGTYPE_p_f_p_struct_sqlite3_context_int_p_p_struct_Mem__void xFunc, SWIGTYPE_p_f_p_struct_sqlite3_context_int_p_p_struct_Mem__void xStep, SWIGTYPE_p_f_p_struct_sqlite3_context__void xFinal) {
        return SQLite3JNI.sqlite3_create_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), zFunctionName, nArg, eTextRep, SWIGTYPE_p_void.getCPtr(arg4), SWIGTYPE_p_f_p_struct_sqlite3_context_int_p_p_struct_Mem__void.getCPtr(xFunc), SWIGTYPE_p_f_p_struct_sqlite3_context_int_p_p_struct_Mem__void.getCPtr(xStep), SWIGTYPE_p_f_p_struct_sqlite3_context__void.getCPtr(xFinal));
    }

    public static int sqlite3_aggregate_count(SWIGTYPE_p_sqlite3_context arg0) {
        return SQLite3JNI.sqlite3_aggregate_count(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
    }

    public static SWIGTYPE_p_void sqlite3_value_blob(SWIGTYPE_p_Mem arg0) {
        long cPtr = SQLite3JNI.sqlite3_value_blob(SWIGTYPE_p_Mem.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_value_bytes(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static double sqlite3_value_double(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_double(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_int(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_int(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static long sqlite3_value_int64(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_int64(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static String sqlite3_value_text(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_text(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_type(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_type(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static int sqlite3_value_numeric_type(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_numeric_type(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    public static SWIGTYPE_p_void sqlite3_aggregate_context(SWIGTYPE_p_sqlite3_context arg0, int nBytes) {
        long cPtr = SQLite3JNI.sqlite3_aggregate_context(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), nBytes);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_user_data(SWIGTYPE_p_sqlite3_context arg0) {
        long cPtr = SQLite3JNI.sqlite3_user_data(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
        long cPtr = SQLite3JNI.sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static void sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1, SWIGTYPE_p_void arg2, SWIGTYPE_p_f_p_void__void arg3) {
        SQLite3JNI.sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, SWIGTYPE_p_void.getCPtr(arg2), SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
    }

    public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_void arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
        SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_void.getCPtr(arg1), arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
    }

    public static void sqlite3_result_double(SWIGTYPE_p_sqlite3_context arg0, double arg1) {
        SQLite3JNI.sqlite3_result_double(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2) {
        SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2);
    }

    public static void sqlite3_result_int(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
        SQLite3JNI.sqlite3_result_int(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_int64(SWIGTYPE_p_sqlite3_context arg0, long arg1) {
        SQLite3JNI.sqlite3_result_int64(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
    }

    public static void sqlite3_result_null(SWIGTYPE_p_sqlite3_context arg0) {
        SQLite3JNI.sqlite3_result_null(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
    }

    public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
        SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
    }

    public static void sqlite3_result_value(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_Mem arg1) {
        SQLite3JNI.sqlite3_result_value(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_Mem.getCPtr(arg1));
    }

    public static int sqlite3_create_collation(SWIGTYPE_p_sqlite3 arg0, String zName, int eTextRep, SWIGTYPE_p_void arg3, SWIGTYPE_p_f_p_void_int_p_q_const__void_int_p_q_const__void__int xCompare) {
        return SQLite3JNI.sqlite3_create_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), zName, eTextRep, SWIGTYPE_p_void.getCPtr(arg3), SWIGTYPE_p_f_p_void_int_p_q_const__void_int_p_q_const__void__int.getCPtr(xCompare));
    }

    public static int sqlite3_collation_needed(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_void arg1, SWIGTYPE_p_f_p_void_p_struct_sqlite3_int_p_q_const__char__void arg2) {
        return SQLite3JNI.sqlite3_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_void.getCPtr(arg1), SWIGTYPE_p_f_p_void_p_struct_sqlite3_int_p_q_const__char__void.getCPtr(arg2));
    }

    public static int sqlite3_expired(SWIGTYPE_p_sqlite3_stmt arg0) {
        return SQLite3JNI.sqlite3_expired(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    }

    public static int sqlite3_transfer_bindings(SWIGTYPE_p_sqlite3_stmt arg0, SWIGTYPE_p_sqlite3_stmt arg1) {
        return SQLite3JNI.sqlite3_transfer_bindings(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), SWIGTYPE_p_sqlite3_stmt.getCPtr(arg1));
    }

    public static void setSqlite3_temp_directory(String value) {
        SQLite3JNI.sqlite3_temp_directory_set(value);
    }

    public static String getSqlite3_temp_directory() {
        return SQLite3JNI.sqlite3_temp_directory_get();
    }

    public static int sqlite3_global_recover() {
        return SQLite3JNI.sqlite3_global_recover();
    }

    public static int sqlite3_get_autocommit(SWIGTYPE_p_sqlite3 arg0) {
        return SQLite3JNI.sqlite3_get_autocommit(SWIGTYPE_p_sqlite3.getCPtr(arg0));
    }

    public static SWIGTYPE_p_sqlite3 sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt arg0) {
        long cPtr = SQLite3JNI.sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_update_hook(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_long_long__void arg1, SWIGTYPE_p_void arg2) {
        long cPtr = SQLite3JNI.sqlite3_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void_int_p_q_const__char_p_q_const__char_long_long__void.getCPtr(arg1), SWIGTYPE_p_void.getCPtr(arg2));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static SWIGTYPE_p_void sqlite3_rollback_hook(SWIGTYPE_p_sqlite3 arg0, SWIGTYPE_p_f_p_void__void arg1, SWIGTYPE_p_void arg2) {
        long cPtr = SQLite3JNI.sqlite3_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), SWIGTYPE_p_f_p_void__void.getCPtr(arg1), SWIGTYPE_p_void.getCPtr(arg2));
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public static int sqlite3_enable_shared_cache(int arg0) {
        return SQLite3JNI.sqlite3_enable_shared_cache(arg0);
    }

    public static void sqlite3_thread_cleanup() {
        SQLite3JNI.sqlite3_thread_cleanup();
    }

    public static int sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3 db, String zDbName, String zTableName, String zColumnName, SWIGTYPE_p_p_char pzDataType, SWIGTYPE_p_p_char pzCollSeq, SWIGTYPE_p_int pNotNull, SWIGTYPE_p_int pPrimaryKey, SWIGTYPE_p_int pAutoinc) {
        return SQLite3JNI.sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3.getCPtr(db), zDbName, zTableName, zColumnName, SWIGTYPE_p_p_char.getCPtr(pzDataType), SWIGTYPE_p_p_char.getCPtr(pzCollSeq), SWIGTYPE_p_int.getCPtr(pNotNull), SWIGTYPE_p_int.getCPtr(pPrimaryKey), SWIGTYPE_p_int.getCPtr(pAutoinc));
    }

    public static SWIGTYPE_p_p_sqlite3 new_p_p_sqlite3() {
        long cPtr = SQLite3JNI.new_p_p_sqlite3();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_p_sqlite3 copy_p_p_sqlite3(SWIGTYPE_p_sqlite3 value) {
        long cPtr = SQLite3JNI.copy_p_p_sqlite3(SWIGTYPE_p_sqlite3.getCPtr(value));
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3(cPtr, false);
    }

    public static void delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3 self) {
        SQLite3JNI.delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3.getCPtr(self));
    }

    public static void p_p_sqlite3_assign(SWIGTYPE_p_p_sqlite3 self, SWIGTYPE_p_sqlite3 value) {
        SQLite3JNI.p_p_sqlite3_assign(SWIGTYPE_p_p_sqlite3.getCPtr(self), SWIGTYPE_p_sqlite3.getCPtr(value));
    }

    public static SWIGTYPE_p_sqlite3 p_p_sqlite3_value(SWIGTYPE_p_p_sqlite3 self) {
        long cPtr = SQLite3JNI.p_p_sqlite3_value(SWIGTYPE_p_p_sqlite3.getCPtr(self));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
    }

    public static SWIGTYPE_p_p_sqlite3_stmt new_p_p_sqlite3_stmt() {
        long cPtr = SQLite3JNI.new_p_p_sqlite3_stmt();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3_stmt(cPtr, false);
    }

    public static SWIGTYPE_p_p_sqlite3_stmt copy_p_p_sqlite3_stmt(SWIGTYPE_p_sqlite3_stmt value) {
        long cPtr = SQLite3JNI.copy_p_p_sqlite3_stmt(SWIGTYPE_p_sqlite3_stmt.getCPtr(value));
        return cPtr == 0L ? null : new SWIGTYPE_p_p_sqlite3_stmt(cPtr, false);
    }

    public static void delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt self) {
        SQLite3JNI.delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
    }

    public static void p_p_sqlite3_stmt_assign(SWIGTYPE_p_p_sqlite3_stmt self, SWIGTYPE_p_sqlite3_stmt value) {
        SQLite3JNI.p_p_sqlite3_stmt_assign(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self), SWIGTYPE_p_sqlite3_stmt.getCPtr(value));
    }

    public static SWIGTYPE_p_sqlite3_stmt p_p_sqlite3_stmt_value(SWIGTYPE_p_p_sqlite3_stmt self) {
        long cPtr = SQLite3JNI.p_p_sqlite3_stmt_value(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
        return cPtr == 0L ? null : new SWIGTYPE_p_sqlite3_stmt(cPtr, false);
    }

    public static SWIGTYPE_p_p_char new_p_p_char() {
        long cPtr = SQLite3JNI.new_p_p_char();
        return cPtr == 0L ? null : new SWIGTYPE_p_p_char(cPtr, false);
    }

    public static SWIGTYPE_p_p_char copy_p_p_char(String value) {
        long cPtr = SQLite3JNI.copy_p_p_char(value);
        return cPtr == 0L ? null : new SWIGTYPE_p_p_char(cPtr, false);
    }

    public static void delete_p_p_char(SWIGTYPE_p_p_char self) {
        SQLite3JNI.delete_p_p_char(SWIGTYPE_p_p_char.getCPtr(self));
    }

    public static void p_p_char_assign(SWIGTYPE_p_p_char self, String value) {
        SQLite3JNI.p_p_char_assign(SWIGTYPE_p_p_char.getCPtr(self), value);
    }

    public static String p_p_char_value(SWIGTYPE_p_p_char self) {
        return SQLite3JNI.p_p_char_value(SWIGTYPE_p_p_char.getCPtr(self));
    }

    public static SWIGTYPE_p_int new_p_int() {
        long cPtr = SQLite3JNI.new_p_int();
        return cPtr == 0L ? null : new SWIGTYPE_p_int(cPtr, false);
    }

    public static SWIGTYPE_p_int copy_p_int(int value) {
        long cPtr = SQLite3JNI.copy_p_int(value);
        return cPtr == 0L ? null : new SWIGTYPE_p_int(cPtr, false);
    }

    public static void delete_p_int(SWIGTYPE_p_int self) {
        SQLite3JNI.delete_p_int(SWIGTYPE_p_int.getCPtr(self));
    }

    public static void p_int_assign(SWIGTYPE_p_int self, int value) {
        SQLite3JNI.p_int_assign(SWIGTYPE_p_int.getCPtr(self), value);
    }

    public static int p_int_value(SWIGTYPE_p_int self) {
        return SQLite3JNI.p_int_value(SWIGTYPE_p_int.getCPtr(self));
    }

    private static int sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt pStmt, int parameterIndex, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
        return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt), parameterIndex, BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
    }

    public static void read_blob(SWIGTYPE_p_void blob, long pos, byte[] BYTE, int offset, int len) {
        SQLite3JNI.read_blob(SWIGTYPE_p_void.getCPtr(blob), pos, BYTE, offset, len);
    }

    public static SWIGTYPE_p_Mem get_p_sqlite3_value(SWIGTYPE_p_p_Mem value, int i) {
        long cPtr = SQLite3JNI.get_p_sqlite3_value(SWIGTYPE_p_p_Mem.getCPtr(value), i);
        return cPtr == 0L ? null : new SWIGTYPE_p_Mem(cPtr, false);
    }

    public static void sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context pCtx, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
        SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(pCtx), BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
    }

    public static byte[] sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
        return SQLite3JNI.sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
    }

    public static byte[] sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem arg0) {
        return SQLite3JNI.sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
    }

    private static int sqlite3_prepare_tail(SWIGTYPE_p_sqlite3 arg0, String arg1, int arg2, SWIGTYPE_p_p_sqlite3_stmt arg3, Object[] arg4) {
        return SQLite3JNI.sqlite3_prepare_tail(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(arg3), arg4);
    }

    private static int create_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.create_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int drop_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.drop_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int create_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.create_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int drop_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.drop_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int set_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int clear_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int set_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.set_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static int clear_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        return SQLite3JNI.clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void set_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.set_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void clear_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void set_commit_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.set_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void clear_commit_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.clear_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void set_rollback_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.set_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void clear_rollback_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.clear_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void set_update_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.set_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }

    private static void clear_update_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
        SQLite3JNI.clear_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
    }
}

