/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.util.Properties;
import org.sqlite.swig.SQLite3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Scheme {
    JDBC_SQLITE_FILE("jdbc:sqlite:file:"),
    JDBC_SQLITE_MEMORY("jdbc:sqlite:mem:"),
    JDBC_SQLITE("jdbc:sqlite:");

    private final String scheme;

    private Scheme(String scheme) {
        this.scheme = scheme;
    }

    public String toString() {
        return this.scheme;
    }

    public boolean matches(String url) {
        return url.startsWith(this.scheme);
    }

    public Properties parse(String url) {
        Properties prop = null;
        if (this.matches(url)) {
            prop = new Properties();
            String[] props = url.substring(this.scheme.length()).split(";");
            prop.setProperty(";filename;", this != JDBC_SQLITE_MEMORY ? props[0] : SQLite3.getInMemoryFileName());
            for (int i = 1; i < props.length; ++i) {
                String[] option = props[i].split("=", 2);
                prop.setProperty(option[0], option.length == 2 ? option[1] : "");
            }
        }
        return prop;
    }
}

