/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcDatabaseMetaData;
import org.sqlite.schema.ColumnMetaData;

public class JdbcResultSetMetaData
implements ResultSetMetaData {
    private final Statement stmt;

    public JdbcResultSetMetaData(Statement stmt) {
        this.stmt = stmt;
    }

    public int getColumnCount() throws SQLException {
        return this.stmt.getColumnCount();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return meta.isAutoIncrement;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return "NOCASE".equalsIgnoreCase(meta.collationSequenceName);
    }

    public boolean isSearchable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public int isNullable(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return meta.isNotNull ? 0 : 1;
    }

    public boolean isSigned(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.isSigned(this.stmt.getColumnType(column));
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.getColumnDisplaySize(this.stmt.getColumnType(column));
    }

    public String getColumnLabel(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.getPrecision(this.stmt.getColumnType(column));
    }

    public int getScale(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.getScale(this.stmt.getColumnType(column));
    }

    public String getTableName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.getColumnType(this.stmt.getColumnType(column));
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return JdbcDatabaseMetaData.getColumnClassName(this.stmt.getColumnType(column));
    }

    protected void validateColumnIndexRange(int columnIndex) throws SQLException {
        if (columnIndex > this.getColumnCount() || columnIndex < 1) {
            throw new SQLException("Column index out of range.", "90J01");
        }
    }

    public int getSQLiteColumnType(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnType(column);
    }

    public String getDatabaseName(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        return this.stmt.getColumnDatabaseName(column);
    }

    public ColumnMetaData getColumnMetaData(int column) throws SQLException {
        this.validateColumnIndexRange(column);
        String dbName = this.stmt.getColumnDatabaseName(column);
        String tableName = this.stmt.getColumnTableName(column);
        String columnName = this.stmt.getColumnName(column);
        return this.stmt.getDatabase().getColumnMetaData(dbName, tableName, columnName);
    }
}

