/*
 * Decompiled with CFR 0.152.
 */
package org.spirytus.tools.jboss.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.Launch;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.spirytus.tools.jboss.plugin.PluginMain;

public class Util {
    public static final String FS = File.separator;

    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name").toUpperCase();
        return osName.indexOf("WINDOWS") != -1;
    }

    public static void exec(String command) {
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            InputStream is = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getValue(String key) {
        IPreferenceStore store = PluginMain.getDefault().getPreferenceStore();
        return store.getString(key);
    }

    public static String getJBossHomeDir() {
        String jbossHomeDir = Util.getValue("PreferenceRootPage.ClassTypeString");
        if (jbossHomeDir == null || "".equals(jbossHomeDir)) {
            throw new IllegalArgumentException("");
        }
        return jbossHomeDir;
    }

    public static void runVM() throws CoreException {
        String jarPath = "C:\\Develop\\DbServer\\h2\\h2.jar;%H2DRIVERS%;%CLASSPATH%";
        String[] classpath = new String[]{jarPath};
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration("org.h2.tools.Console", classpath);
        String mode = "run";
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        Launch launch = new Launch((ILaunchConfiguration)launchType.newInstance(null, "JBoss launch"), mode, null);
        IVMRunner vmRunner = JavaRuntime.getDefaultVMInstall().getVMRunner(mode);
        vmRunner.run(vmConfig, (ILaunch)launch, null);
    }
}

